/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.engine.query.HQLQueryPlan;
import org.hibernate.engine.query.NativeSQLQueryPlan;
import org.hibernate.engine.query.sql.NativeSQLQuerySpecification;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.impl.QueryImpl;
import org.hibernate.impl.SQLQueryImpl;
import org.hibernate.impl.SessionFactoryImpl;

public abstract class AbstractSessionImpl
implements SessionImplementor {
    protected transient SessionFactoryImpl factory;
    private boolean closed = false;

    protected AbstractSessionImpl(SessionFactoryImpl factory) {
        this.factory = factory;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new SessionException("Session is closed!");
        }
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        AbstractQueryImpl query2;
        this.errorIfClosed();
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            String queryString = nqd.getQueryString();
            query2 = new QueryImpl(queryString, nqd.getFlushMode(), this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
            query2.setComment("named HQL query " + queryName);
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            query2 = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
            query2.setComment("named native SQL query " + queryName);
            nqd = nsqlqd;
        }
        this.initQuery(query2, nqd);
        return query2;
    }

    public Query getNamedSQLQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query2 = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
        query2.setComment("named native SQL query " + queryName);
        this.initQuery(query2, nsqlqd);
        return query2;
    }

    private void initQuery(Query query2, NamedQueryDefinition nqd) {
        query2.setCacheable(nqd.isCacheable());
        query2.setCacheRegion(nqd.getCacheRegion());
        if (nqd.getTimeout() != null) {
            query2.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query2.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query2.setCacheMode(nqd.getCacheMode());
        }
        query2.setReadOnly(nqd.isReadOnly());
        if (nqd.getComment() != null) {
            query2.setComment(nqd.getComment());
        }
    }

    public Query createQuery(String queryString) {
        this.errorIfClosed();
        QueryImpl query2 = new QueryImpl(queryString, this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query2.setComment(queryString);
        return query2;
    }

    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        SQLQueryImpl query2 = new SQLQueryImpl(sql, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
        query2.setComment("dynamic native SQL query");
        return query2;
    }

    protected HQLQueryPlan getHQLQueryPlan(String query2, boolean shallow) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(query2, shallow, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }
}

