/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.EntityKey;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.impl.AbstractQueryImpl;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private final String queryName;
    private final EntityPersister persister;
    private static final Logger log = LoggerFactory.getLogger(NamedQueryLoader.class);

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session, LockOptions lockOptions) {
        if (lockOptions != null) {
            log.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(id, optionalObject, session);
    }

    public Object load(Serializable id, Object optionalObject, SessionImplementor session) {
        AbstractQueryImpl query2;
        if (log.isDebugEnabled()) {
            log.debug("loading entity: " + this.persister.getEntityName() + " using named query: " + this.queryName);
        }
        if ((query2 = (AbstractQueryImpl)session.getNamedQuery(this.queryName)).hasNamedParameters()) {
            query2.setParameter(query2.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query2.setParameter(0, (Object)id, this.persister.getIdentifierType());
        }
        query2.setOptionalId(id);
        query2.setOptionalEntityName(this.persister.getEntityName());
        query2.setOptionalObject(optionalObject);
        query2.setFlushMode(FlushMode.MANUAL);
        query2.list();
        return session.getPersistenceContext().getEntity(new EntityKey(id, this.persister, session.getEntityMode()));
    }
}

