/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.jcache.interceptor;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.interceptor.AbstractCacheInvoker;
import org.springframework.cache.interceptor.CacheOperationInvocationContext;
import org.springframework.cache.interceptor.CacheOperationInvoker;
import org.springframework.cache.jcache.interceptor.CachePutInterceptor;
import org.springframework.cache.jcache.interceptor.CachePutOperation;
import org.springframework.cache.jcache.interceptor.CacheRemoveAllInterceptor;
import org.springframework.cache.jcache.interceptor.CacheRemoveAllOperation;
import org.springframework.cache.jcache.interceptor.CacheRemoveEntryInterceptor;
import org.springframework.cache.jcache.interceptor.CacheRemoveOperation;
import org.springframework.cache.jcache.interceptor.CacheResultInterceptor;
import org.springframework.cache.jcache.interceptor.CacheResultOperation;
import org.springframework.cache.jcache.interceptor.DefaultCacheInvocationContext;
import org.springframework.cache.jcache.interceptor.JCacheOperation;
import org.springframework.cache.jcache.interceptor.JCacheOperationSource;
import org.springframework.util.Assert;

public class JCacheAspectSupport
extends AbstractCacheInvoker
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private JCacheOperationSource cacheOperationSource;
    private boolean initialized = false;
    private CacheResultInterceptor cacheResultInterceptor;
    private CachePutInterceptor cachePutInterceptor;
    private CacheRemoveEntryInterceptor cacheRemoveEntryInterceptor;
    private CacheRemoveAllInterceptor cacheRemoveAllInterceptor;

    public void setCacheOperationSource(JCacheOperationSource cacheOperationSource) {
        Assert.notNull(cacheOperationSource, "JCacheOperationSource must not be null");
        this.cacheOperationSource = cacheOperationSource;
    }

    public JCacheOperationSource getCacheOperationSource() {
        return this.cacheOperationSource;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.getCacheOperationSource() != null, "The 'cacheOperationSource' property is required: If there are no cacheable methods, then don't use a cache aspect.");
        Assert.state(this.getErrorHandler() != null, "The 'errorHandler' property is required");
        this.cacheResultInterceptor = new CacheResultInterceptor(this.getErrorHandler());
        this.cachePutInterceptor = new CachePutInterceptor(this.getErrorHandler());
        this.cacheRemoveEntryInterceptor = new CacheRemoveEntryInterceptor(this.getErrorHandler());
        this.cacheRemoveAllInterceptor = new CacheRemoveAllInterceptor(this.getErrorHandler());
        this.initialized = true;
    }

    protected Object execute(CacheOperationInvoker invoker, Object target, Method method, Object[] args) {
        if (this.initialized) {
            Class<?> targetClass = this.getTargetClass(target);
            JCacheOperation<?> operation = this.getCacheOperationSource().getCacheOperation(method, targetClass);
            if (operation != null) {
                CacheOperationInvocationContext<?> context = this.createCacheOperationInvocationContext(target, args, operation);
                return this.execute(context, invoker);
            }
        }
        return invoker.invoke();
    }

    private CacheOperationInvocationContext<?> createCacheOperationInvocationContext(Object target, Object[] args, JCacheOperation<?> operation) {
        return new DefaultCacheInvocationContext(operation, target, args);
    }

    private Class<?> getTargetClass(Object target) {
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass(target);
        if (targetClass == null && target != null) {
            targetClass = target.getClass();
        }
        return targetClass;
    }

    private Object execute(CacheOperationInvocationContext<?> context, CacheOperationInvoker invoker) {
        CacheOperationInvokerAdapter adapter = new CacheOperationInvokerAdapter(invoker);
        Object operation = context.getOperation();
        if (operation instanceof CacheResultOperation) {
            return this.cacheResultInterceptor.invoke(context, (CacheOperationInvoker)adapter);
        }
        if (operation instanceof CachePutOperation) {
            return this.cachePutInterceptor.invoke((CacheOperationInvocationContext<CachePutOperation>)context, (CacheOperationInvoker)adapter);
        }
        if (operation instanceof CacheRemoveOperation) {
            return this.cacheRemoveEntryInterceptor.invoke((CacheOperationInvocationContext<CacheRemoveOperation>)context, (CacheOperationInvoker)adapter);
        }
        if (operation instanceof CacheRemoveAllOperation) {
            return this.cacheRemoveAllInterceptor.invoke((CacheOperationInvocationContext<CacheRemoveAllOperation>)context, (CacheOperationInvoker)adapter);
        }
        throw new IllegalArgumentException("Cannot handle " + operation);
    }

    protected Object invokeOperation(CacheOperationInvoker invoker) {
        return invoker.invoke();
    }

    private class CacheOperationInvokerAdapter
    implements CacheOperationInvoker {
        private final CacheOperationInvoker delegate;

        public CacheOperationInvokerAdapter(CacheOperationInvoker delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object invoke() throws CacheOperationInvoker.ThrowableWrapper {
            return JCacheAspectSupport.this.invokeOperation(this.delegate);
        }
    }
}

