/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import javax.servlet.ServletRequest;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefaults;
import org.springframework.data.web.SpringDataAnnotationUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.context.request.NativeWebRequest;

@Deprecated
public class PageableArgumentResolver
implements WebArgumentResolver {
    private static final Pageable DEFAULT_PAGE_REQUEST = new PageRequest(0, 10);
    private static final String DEFAULT_PREFIX = "page";
    private static final String DEFAULT_SEPARATOR = ".";
    private Pageable fallbackPageable = DEFAULT_PAGE_REQUEST;
    private String prefix = "page";
    private String separator = ".";

    public void setFallbackPageable(Pageable fallbackPageable) {
        this.fallbackPageable = null == fallbackPageable ? DEFAULT_PAGE_REQUEST : fallbackPageable;
    }

    public void setPrefix(String prefix) {
        this.prefix = null == prefix ? DEFAULT_PREFIX : prefix;
    }

    public void setSeparator(String separator) {
        this.separator = null == separator ? DEFAULT_SEPARATOR : separator;
    }

    @Override
    public Object resolveArgument(MethodParameter methodParameter, NativeWebRequest webRequest) {
        if (methodParameter.getParameterType().equals(Pageable.class)) {
            SpringDataAnnotationUtils.assertPageableUniqueness(methodParameter);
            Pageable request = this.getDefaultFromAnnotationOrFallback(methodParameter);
            ServletRequest servletRequest = (ServletRequest)webRequest.getNativeRequest();
            ServletRequestParameterPropertyValues propertyValues = new ServletRequestParameterPropertyValues(servletRequest, this.getPrefix(methodParameter), this.separator);
            ServletRequestDataBinder binder = new ServletRequestDataBinder(request);
            binder.initDirectFieldAccess();
            binder.registerCustomEditor(Sort.class, new SortPropertyEditor("sort.dir", propertyValues));
            binder.bind(propertyValues);
            if (request.getPageNumber() > 0) {
                request = new PageRequest(request.getPageNumber() - 1, request.getPageSize(), request.getSort());
            }
            return request;
        }
        return UNRESOLVED;
    }

    private Pageable getDefaultFromAnnotationOrFallback(MethodParameter methodParameter) {
        for (Annotation annotation : methodParameter.getParameterAnnotations()) {
            if (!(annotation instanceof PageableDefaults)) continue;
            return PageableArgumentResolver.getDefaultPageRequestFrom((PageableDefaults)annotation);
        }
        return new PageRequest(this.fallbackPageable.getPageNumber(), this.fallbackPageable.getPageSize(), this.fallbackPageable.getSort());
    }

    static Pageable getDefaultPageRequestFrom(PageableDefaults defaults) {
        int defaultPageNumber = defaults.pageNumber() + 1;
        int defaultPageSize = defaults.value();
        if (defaults.sort().length == 0) {
            return new PageRequest(defaultPageNumber, defaultPageSize);
        }
        return new PageRequest(defaultPageNumber, defaultPageSize, defaults.sortDir(), defaults.sort());
    }

    private String getPrefix(MethodParameter parameter) {
        for (Annotation annotation : parameter.getParameterAnnotations()) {
            if (!(annotation instanceof Qualifier)) continue;
            return ((Qualifier)annotation).value() + "_" + this.prefix;
        }
        return this.prefix;
    }

    private static class SortPropertyEditor
    extends PropertyEditorSupport {
        private final String orderProperty;
        private final PropertyValues values;

        public SortPropertyEditor(String orderProperty, PropertyValues values) {
            this.orderProperty = orderProperty;
            this.values = values;
        }

        @Override
        public void setAsText(String text) {
            PropertyValue rawOrder = this.values.getPropertyValue(this.orderProperty);
            Sort.Direction order = null == rawOrder ? Sort.Direction.ASC : Sort.Direction.fromString(rawOrder.getValue().toString());
            this.setValue(new Sort(order, text));
        }
    }
}

