/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.metadata;

import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.metadata.GenericTableMetaDataProvider;
import org.springframework.jdbc.support.nativejdbc.NativeJdbcExtractor;
import org.springframework.util.ReflectionUtils;

public class OracleTableMetaDataProvider
extends GenericTableMetaDataProvider {
    private final boolean includeSynonyms;
    private String defaultSchema;

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData) throws SQLException {
        this(databaseMetaData, false);
    }

    public OracleTableMetaDataProvider(DatabaseMetaData databaseMetaData, boolean includeSynonyms) throws SQLException {
        super(databaseMetaData);
        this.includeSynonyms = includeSynonyms;
        this.lookupDefaultSchema(databaseMetaData);
    }

    private void lookupDefaultSchema(DatabaseMetaData databaseMetaData) {
        try {
            CallableStatement cstmt = null;
            try {
                cstmt = databaseMetaData.getConnection().prepareCall("{? = call sys_context('USERENV', 'CURRENT_SCHEMA')}");
                cstmt.registerOutParameter(1, 12);
                cstmt.execute();
                this.defaultSchema = cstmt.getString(1);
            }
            finally {
                if (cstmt != null) {
                    cstmt.close();
                }
            }
        }
        catch (SQLException ex) {
            logger.debug("Encountered exception during default schema lookup", ex);
        }
    }

    @Override
    protected String getDefaultSchema() {
        if (this.defaultSchema != null) {
            return this.defaultSchema;
        }
        return super.getDefaultSchema();
    }

    @Override
    public void initializeWithTableColumnMetaData(DatabaseMetaData databaseMetaData, String catalogName, String schemaName, String tableName) throws SQLException {
        Method setIncludeSynonyms;
        Boolean originalValueForIncludeSynonyms;
        if (!this.includeSynonyms) {
            logger.debug("Defaulting to no synonyms in table metadata lookup");
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        Connection con = databaseMetaData.getConnection();
        NativeJdbcExtractor nativeJdbcExtractor = this.getNativeJdbcExtractor();
        if (nativeJdbcExtractor != null) {
            con = nativeJdbcExtractor.getNativeConnection(con);
        }
        boolean isOracleCon = false;
        try {
            Class<?> oracleConClass = con.getClass().getClassLoader().loadClass("oracle.jdbc.OracleConnection");
            isOracleCon = oracleConClass.isInstance(con);
            if (!isOracleCon) {
                con = (Connection)con.unwrap(oracleConClass);
                isOracleCon = oracleConClass.isInstance(con);
            }
        }
        catch (ClassNotFoundException ex) {
            if (logger.isInfoEnabled()) {
                logger.info("Could not find Oracle JDBC API: " + ex);
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        if (!isOracleCon) {
            if (logger.isWarnEnabled()) {
                logger.warn("Unable to include synonyms in table metadata lookup - no Oracle Connection: " + con);
            }
            super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
            return;
        }
        logger.debug("Including synonyms in table metadata lookup");
        try {
            Method getIncludeSynonyms = con.getClass().getMethod("getIncludeSynonyms", null);
            ReflectionUtils.makeAccessible(getIncludeSynonyms);
            originalValueForIncludeSynonyms = (Boolean)getIncludeSynonyms.invoke((Object)con, new Object[0]);
            setIncludeSynonyms = con.getClass().getMethod("setIncludeSynonyms", Boolean.TYPE);
            ReflectionUtils.makeAccessible(setIncludeSynonyms);
            setIncludeSynonyms.invoke((Object)con, Boolean.TRUE);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not prepare Oracle Connection", ex);
        }
        super.initializeWithTableColumnMetaData(databaseMetaData, catalogName, schemaName, tableName);
        try {
            setIncludeSynonyms.invoke((Object)con, originalValueForIncludeSynonyms);
        }
        catch (Throwable ex) {
            throw new InvalidDataAccessApiUsageException("Could not reset Oracle Connection", ex);
        }
    }
}

