/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class EntityManagerFactoryAccessor
implements BeanFactoryAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private EntityManagerFactory entityManagerFactory;
    private String persistenceUnitName;
    private final Map<String, Object> jpaPropertyMap = new HashMap<String, Object>();

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setJpaProperties(Properties jpaProperties) {
        CollectionUtils.mergePropertiesIntoMap(jpaProperties, this.jpaPropertyMap);
    }

    public void setJpaPropertyMap(Map<String, Object> jpaProperties) {
        if (jpaProperties != null) {
            this.jpaPropertyMap.putAll(jpaProperties);
        }
    }

    public Map<String, Object> getJpaPropertyMap() {
        return this.jpaPropertyMap;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.getEntityManagerFactory() == null) {
            if (!(beanFactory instanceof ListableBeanFactory)) {
                throw new IllegalStateException("Cannot retrieve EntityManagerFactory by persistence unit name in a non-listable BeanFactory: " + beanFactory);
            }
            ListableBeanFactory lbf = (ListableBeanFactory)beanFactory;
            this.setEntityManagerFactory(EntityManagerFactoryUtils.findEntityManagerFactory(lbf, this.getPersistenceUnitName()));
        }
    }

    protected EntityManager createEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        Map<String, Object> properties = this.getJpaPropertyMap();
        return !CollectionUtils.isEmpty(properties) ? emf.createEntityManager(properties) : emf.createEntityManager();
    }

    protected EntityManager getTransactionalEntityManager() throws IllegalStateException {
        EntityManagerFactory emf = this.getEntityManagerFactory();
        Assert.state(emf != null, "No EntityManagerFactory specified");
        return EntityManagerFactoryUtils.getTransactionalEntityManager(emf, this.getJpaPropertyMap());
    }
}

