/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.context.BootstrapUtils;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestContextBootstrapper;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class TestContextManager {
    private static final Log logger = LogFactory.getLog(TestContextManager.class);
    private final TestContext testContext;
    private final List<TestExecutionListener> testExecutionListeners = new ArrayList<TestExecutionListener>();

    public TestContextManager(Class<?> testClass) {
        this(BootstrapUtils.resolveTestContextBootstrapper(BootstrapUtils.createBootstrapContext(testClass)));
    }

    public TestContextManager(TestContextBootstrapper testContextBootstrapper) {
        this.testContext = testContextBootstrapper.buildTestContext();
        this.registerTestExecutionListeners(testContextBootstrapper.getTestExecutionListeners());
    }

    public final TestContext getTestContext() {
        return this.testContext;
    }

    public void registerTestExecutionListeners(List<TestExecutionListener> testExecutionListeners) {
        this.registerTestExecutionListeners(testExecutionListeners.toArray(new TestExecutionListener[testExecutionListeners.size()]));
    }

    public void registerTestExecutionListeners(TestExecutionListener ... testExecutionListeners) {
        for (TestExecutionListener listener : testExecutionListeners) {
            if (logger.isTraceEnabled()) {
                logger.trace("Registering TestExecutionListener: " + listener);
            }
            this.testExecutionListeners.add(listener);
        }
    }

    public final List<TestExecutionListener> getTestExecutionListeners() {
        return this.testExecutionListeners;
    }

    private List<TestExecutionListener> getReversedTestExecutionListeners() {
        ArrayList<TestExecutionListener> listenersReversed = new ArrayList<TestExecutionListener>(this.getTestExecutionListeners());
        Collections.reverse(listenersReversed);
        return listenersReversed;
    }

    public void beforeTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace("beforeTestClass(): class [" + testClass.getName() + "]");
        }
        this.getTestContext().updateState(null, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestClass(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before class' callback for test class [" + testClass + "]", ex);
                }
                ReflectionUtils.rethrowException(ex);
            }
        }
    }

    public void prepareTestInstance(Object testInstance) throws Exception {
        Assert.notNull(testInstance, "Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("prepareTestInstance(): instance [" + testInstance + "]");
        }
        this.getTestContext().updateState(testInstance, null, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.prepareTestInstance(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isErrorEnabled()) {
                    logger.error("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to prepare test instance [" + testInstance + "]", ex);
                }
                ReflectionUtils.rethrowException(ex);
            }
        }
    }

    public void beforeTestMethod(Object testInstance, Method testMethod) throws Exception {
        Assert.notNull(testInstance, "Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("beforeTestMethod(): instance [" + testInstance + "], method [" + testMethod + "]");
        }
        this.getTestContext().updateState(testInstance, testMethod, null);
        for (TestExecutionListener testExecutionListener : this.getTestExecutionListeners()) {
            try {
                testExecutionListener.beforeTestMethod(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'before' execution of test method [" + testMethod + "] for test instance [" + testInstance + "]", ex);
                }
                ReflectionUtils.rethrowException(ex);
            }
        }
    }

    public void afterTestMethod(Object testInstance, Method testMethod, Throwable exception) throws Exception {
        Assert.notNull(testInstance, "Test instance must not be null");
        if (logger.isTraceEnabled()) {
            logger.trace("afterTestMethod(): instance [" + testInstance + "], method [" + testMethod + "], exception [" + exception + "]");
        }
        this.getTestContext().updateState(testInstance, testMethod, exception);
        Throwable afterTestMethodException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestMethod(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after' execution for test: method [" + testMethod + "], instance [" + testInstance + "], exception [" + exception + "]", ex);
                }
                if (afterTestMethodException != null) continue;
                afterTestMethodException = ex;
            }
        }
        if (afterTestMethodException != null) {
            ReflectionUtils.rethrowException(afterTestMethodException);
        }
    }

    public void afterTestClass() throws Exception {
        Class<?> testClass = this.getTestContext().getTestClass();
        if (logger.isTraceEnabled()) {
            logger.trace("afterTestClass(): class [" + testClass.getName() + "]");
        }
        this.getTestContext().updateState(null, null, null);
        Throwable afterTestClassException = null;
        for (TestExecutionListener testExecutionListener : this.getReversedTestExecutionListeners()) {
            try {
                testExecutionListener.afterTestClass(this.getTestContext());
            }
            catch (Throwable ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Caught exception while allowing TestExecutionListener [" + testExecutionListener + "] to process 'after class' callback for test class [" + testClass + "]", ex);
                }
                if (afterTestClassException != null) continue;
                afterTestClassException = ex;
            }
        }
        if (afterTestClassException != null) {
            ReflectionUtils.rethrowException(afterTestClassException);
        }
    }
}

