/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.web;

import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.mock.web.MockServletContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.support.AbstractContextLoader;
import org.springframework.test.context.web.WebMergedContextConfiguration;
import org.springframework.util.Assert;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.GenericWebApplicationContext;

public abstract class AbstractGenericWebContextLoader
extends AbstractContextLoader {
    protected static final Log logger = LogFactory.getLog(AbstractGenericWebContextLoader.class);

    @Override
    public final ConfigurableApplicationContext loadContext(MergedContextConfiguration mergedConfig) throws Exception {
        if (!(mergedConfig instanceof WebMergedContextConfiguration)) {
            throw new IllegalArgumentException(String.format("Cannot load WebApplicationContext from non-web merged context configuration %s. Consider annotating your test class with @WebAppConfiguration.", mergedConfig));
        }
        WebMergedContextConfiguration webMergedConfig = (WebMergedContextConfiguration)mergedConfig;
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading WebApplicationContext for merged context configuration %s.", webMergedConfig));
        }
        this.validateMergedContextConfiguration(webMergedConfig);
        GenericWebApplicationContext context = new GenericWebApplicationContext();
        ApplicationContext parent = mergedConfig.getParentApplicationContext();
        if (parent != null) {
            context.setParent(parent);
        }
        this.configureWebResources(context, webMergedConfig);
        this.prepareContext(context, webMergedConfig);
        this.customizeBeanFactory(context.getDefaultListableBeanFactory(), webMergedConfig);
        this.loadBeanDefinitions(context, webMergedConfig);
        AnnotationConfigUtils.registerAnnotationConfigProcessors(context);
        this.customizeContext(context, webMergedConfig);
        context.refresh();
        context.registerShutdownHook();
        return context;
    }

    protected void validateMergedContextConfiguration(WebMergedContextConfiguration mergedConfig) {
    }

    protected void configureWebResources(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        ApplicationContext parent = context.getParent();
        if (parent == null || !(parent instanceof WebApplicationContext)) {
            String resourceBasePath = webMergedConfig.getResourceBasePath();
            DefaultResourceLoader resourceLoader = resourceBasePath.startsWith("classpath:") ? new DefaultResourceLoader() : new FileSystemResourceLoader();
            MockServletContext servletContext = new MockServletContext(resourceBasePath, resourceLoader);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, context);
            context.setServletContext(servletContext);
        } else {
            ServletContext servletContext = null;
            while (parent != null) {
                if (parent instanceof WebApplicationContext && !(parent.getParent() instanceof WebApplicationContext)) {
                    servletContext = ((WebApplicationContext)parent).getServletContext();
                    break;
                }
                parent = parent.getParent();
            }
            Assert.state(servletContext != null, "Failed to find Root WebApplicationContext in the context hierarchy");
            context.setServletContext(servletContext);
        }
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory, WebMergedContextConfiguration webMergedConfig) {
    }

    protected abstract void loadBeanDefinitions(GenericWebApplicationContext var1, WebMergedContextConfiguration var2);

    protected void customizeContext(GenericWebApplicationContext context, WebMergedContextConfiguration webMergedConfig) {
        super.customizeContext(context, webMergedConfig);
    }

    @Override
    public final ApplicationContext loadContext(String ... locations) throws Exception {
        throw new UnsupportedOperationException("AbstractGenericWebContextLoader does not support the loadContext(String... locations) method");
    }
}

