/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.test.util.AopTestUtils;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class ReflectionTestUtils {
    private static final String SETTER_PREFIX = "set";
    private static final String GETTER_PREFIX = "get";
    private static final Log logger = LogFactory.getLog(ReflectionTestUtils.class);

    public static void setField(Object targetObject, String name, Object value) {
        ReflectionTestUtils.setField(targetObject, name, value, null);
    }

    public static void setField(Object targetObject, String name, Object value, Class<?> type) {
        ReflectionTestUtils.setField(targetObject, null, name, value, type);
    }

    public static void setField(Class<?> targetClass, String name, Object value) {
        ReflectionTestUtils.setField(null, targetClass, name, value, null);
    }

    public static void setField(Class<?> targetClass, String name, Object value, Class<?> type) {
        ReflectionTestUtils.setField(null, targetClass, name, value, type);
    }

    public static void setField(Object targetObject, Class<?> targetClass, String name, Object value, Class<?> type) {
        Field field;
        Object ultimateTarget;
        Assert.isTrue(targetObject != null || targetClass != null, "Either targetObject or targetClass for the field must be specified");
        Object object = ultimateTarget = targetObject != null ? (Object)AopTestUtils.getUltimateTargetObject(targetObject) : null;
        if (targetClass == null) {
            targetClass = ultimateTarget.getClass();
        }
        if ((field = ReflectionUtils.findField(targetClass, name, type)) == null) {
            throw new IllegalArgumentException(String.format("Could not find field '%s' of type [%s] on %s or target class [%s]", name, type, ReflectionTestUtils.safeToString(ultimateTarget), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Setting field '%s' of type [%s] on %s or target class [%s] to value [%s]", name, type, ReflectionTestUtils.safeToString(ultimateTarget), targetClass, value));
        }
        ReflectionUtils.makeAccessible(field);
        ReflectionUtils.setField(field, ultimateTarget, value);
    }

    public static Object getField(Object targetObject, String name) {
        return ReflectionTestUtils.getField(targetObject, null, name);
    }

    public static Object getField(Class<?> targetClass, String name) {
        return ReflectionTestUtils.getField(null, targetClass, name);
    }

    public static Object getField(Object targetObject, Class<?> targetClass, String name) {
        Field field;
        Object ultimateTarget;
        Assert.isTrue(targetObject != null || targetClass != null, "Either targetObject or targetClass for the field must be specified");
        Object object = ultimateTarget = targetObject != null ? (Object)AopTestUtils.getUltimateTargetObject(targetObject) : null;
        if (targetClass == null) {
            targetClass = ultimateTarget.getClass();
        }
        if ((field = ReflectionUtils.findField(targetClass, name)) == null) {
            throw new IllegalArgumentException(String.format("Could not find field '%s' on %s or target class [%s]", name, ReflectionTestUtils.safeToString(ultimateTarget), targetClass));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Getting field '%s' from %s or target class [%s]", name, ReflectionTestUtils.safeToString(ultimateTarget), targetClass));
        }
        ReflectionUtils.makeAccessible(field);
        return ReflectionUtils.getField(field, ultimateTarget);
    }

    public static void invokeSetterMethod(Object target, String name, Object value) {
        ReflectionTestUtils.invokeSetterMethod(target, name, value, null);
    }

    public static void invokeSetterMethod(Object target, String name, Object value, Class<?> type) {
        Method method;
        Class[] classArray;
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        if (type != null) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = type;
        } else {
            classArray = null;
        }
        Class[] paramTypes = classArray;
        String setterMethodName = name;
        if (!name.startsWith(SETTER_PREFIX)) {
            setterMethodName = SETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes)) == null && !setterMethodName.equals(name)) {
            setterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), setterMethodName, paramTypes);
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Could not find setter method '%s' on %s with parameter type [%s]", setterMethodName, ReflectionTestUtils.safeToString(target), type));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Invoking setter method '%s' on %s with value [%s]", setterMethodName, ReflectionTestUtils.safeToString(target), value));
        }
        ReflectionUtils.makeAccessible(method);
        ReflectionUtils.invokeMethod(method, target, value);
    }

    public static Object invokeGetterMethod(Object target, String name) {
        Method method;
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        String getterMethodName = name;
        if (!name.startsWith(GETTER_PREFIX)) {
            getterMethodName = GETTER_PREFIX + StringUtils.capitalize(name);
        }
        if ((method = ReflectionUtils.findMethod(target.getClass(), getterMethodName)) == null && !getterMethodName.equals(name)) {
            getterMethodName = name;
            method = ReflectionUtils.findMethod(target.getClass(), getterMethodName);
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Could not find getter method '%s' on %s", getterMethodName, ReflectionTestUtils.safeToString(target)));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Invoking getter method '%s' on %s", getterMethodName, ReflectionTestUtils.safeToString(target)));
        }
        ReflectionUtils.makeAccessible(method);
        return ReflectionUtils.invokeMethod(method, target);
    }

    public static <T> T invokeMethod(Object target, String name, Object ... args) {
        Assert.notNull(target, "Target object must not be null");
        Assert.hasText(name, "Method name must not be empty");
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetObject(target);
            methodInvoker.setTargetMethod(name);
            methodInvoker.setArguments(args);
            methodInvoker.prepare();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Invoking method '%s' on %s with arguments %s", name, ReflectionTestUtils.safeToString(target), ObjectUtils.nullSafeToString(args)));
            }
            return (T)methodInvoker.invoke();
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private static String safeToString(Object target) {
        try {
            return String.format("target object [%s]", target);
        }
        catch (Exception ex) {
            return String.format("target of type [%s] whose toString() method threw [%s]", target != null ? target.getClass().getName() : "unknown", ex);
        }
    }
}

