/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.web.client.DefaultRequestExpectation;
import org.springframework.test.web.client.ExpectedCount;
import org.springframework.test.web.client.RequestExpectation;
import org.springframework.test.web.client.RequestExpectationManager;
import org.springframework.test.web.client.RequestMatcher;
import org.springframework.test.web.client.ResponseActions;
import org.springframework.util.Assert;

public abstract class AbstractRequestExpectationManager
implements RequestExpectationManager {
    private final List<RequestExpectation> expectations = new LinkedList<RequestExpectation>();
    private final List<ClientHttpRequest> requests = new LinkedList<ClientHttpRequest>();
    private final Object lock = new Object();

    protected List<RequestExpectation> getExpectations() {
        return this.expectations;
    }

    protected List<ClientHttpRequest> getRequests() {
        return this.requests;
    }

    @Override
    public ResponseActions expectRequest(ExpectedCount count, RequestMatcher matcher) {
        Assert.state(this.getRequests().isEmpty(), "Cannot add more expectations after actual requests are made");
        DefaultRequestExpectation expectation = new DefaultRequestExpectation(count, matcher);
        this.getExpectations().add(expectation);
        return expectation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientHttpResponse validateRequest(ClientHttpRequest request) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.getRequests().isEmpty()) {
                this.afterExpectationsDeclared();
            }
            ClientHttpResponse response = this.validateRequestInternal(request);
            this.getRequests().add(request);
            return response;
        }
    }

    protected void afterExpectationsDeclared() {
    }

    protected abstract ClientHttpResponse validateRequestInternal(ClientHttpRequest var1) throws IOException;

    @Override
    public void verify() {
        if (this.getExpectations().isEmpty()) {
            return;
        }
        int count = 0;
        for (RequestExpectation expectation : this.getExpectations()) {
            if (expectation.isSatisfied()) continue;
            ++count;
        }
        if (count > 0) {
            String message = "Further request(s) expected leaving " + count + " unsatisfied expectation(s).\n";
            throw new AssertionError((Object)(message + this.getRequestDetails()));
        }
    }

    protected String getRequestDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getRequests().size()).append(" request(s) executed");
        if (!this.getRequests().isEmpty()) {
            sb.append(":\n");
            for (ClientHttpRequest request : this.getRequests()) {
                sb.append(request.toString()).append("\n");
            }
        } else {
            sb.append(".\n");
        }
        return sb.toString();
    }

    protected AssertionError createUnexpectedRequestError(ClientHttpRequest request) {
        HttpMethod method = request.getMethod();
        URI uri = request.getURI();
        String message = "No further requests expected: HTTP " + (Object)((Object)method) + " " + uri + "\n";
        return new AssertionError((Object)(message + this.getRequestDetails()));
    }

    @Override
    public void reset() {
        this.expectations.clear();
        this.requests.clear();
    }

    protected static class RequestExpectationGroup {
        private final Set<RequestExpectation> expectations = new LinkedHashSet<RequestExpectation>();

        protected RequestExpectationGroup() {
        }

        public Set<RequestExpectation> getExpectations() {
            return this.expectations;
        }

        public void update(RequestExpectation expectation) {
            if (expectation.hasRemainingCount()) {
                this.getExpectations().add(expectation);
            } else {
                this.getExpectations().remove(expectation);
            }
        }

        public void updateAll(Collection<RequestExpectation> expectations) {
            for (RequestExpectation expectation : expectations) {
                this.update(expectation);
            }
        }

        public RequestExpectation findExpectation(ClientHttpRequest request) throws IOException {
            for (RequestExpectation expectation : this.getExpectations()) {
                try {
                    expectation.match(request);
                    return expectation;
                }
                catch (AssertionError assertionError) {
                }
            }
            return null;
        }

        public void reset() {
            this.expectations.clear();
        }
    }
}

