/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.servlet;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.Mergeable;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.DefaultMvcResult;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;
import org.springframework.test.web.servlet.SmartRequestBuilder;
import org.springframework.test.web.servlet.TestDispatcherServlet;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public final class MockMvc {
    static String MVC_RESULT_ATTRIBUTE = MockMvc.class.getName().concat(".MVC_RESULT_ATTRIBUTE");
    private final TestDispatcherServlet servlet;
    private final Filter[] filters;
    private final ServletContext servletContext;
    private RequestBuilder defaultRequestBuilder;
    private List<ResultMatcher> defaultResultMatchers = new ArrayList<ResultMatcher>();
    private List<ResultHandler> defaultResultHandlers = new ArrayList<ResultHandler>();

    MockMvc(TestDispatcherServlet servlet, Filter[] filters, ServletContext servletContext) {
        Assert.notNull((Object)servlet, "DispatcherServlet is required");
        Assert.notNull(filters, "filters cannot be null");
        Assert.noNullElements(filters, "filters cannot contain null values");
        Assert.notNull(servletContext, "A ServletContext is required");
        this.servlet = servlet;
        this.filters = filters;
        this.servletContext = servletContext;
    }

    void setDefaultRequest(RequestBuilder requestBuilder) {
        this.defaultRequestBuilder = requestBuilder;
    }

    void setGlobalResultMatchers(List<ResultMatcher> resultMatchers) {
        Assert.notNull(resultMatchers, "resultMatchers is required");
        this.defaultResultMatchers = resultMatchers;
    }

    void setGlobalResultHandlers(List<ResultHandler> resultHandlers) {
        Assert.notNull(resultHandlers, "resultHandlers is required");
        this.defaultResultHandlers = resultHandlers;
    }

    public ResultActions perform(RequestBuilder requestBuilder) throws Exception {
        if (this.defaultRequestBuilder != null && requestBuilder instanceof Mergeable) {
            requestBuilder = (RequestBuilder)((Mergeable)((Object)requestBuilder)).merge(this.defaultRequestBuilder);
        }
        MockHttpServletRequest request = requestBuilder.buildRequest(this.servletContext);
        MockHttpServletResponse response = new MockHttpServletResponse();
        if (requestBuilder instanceof SmartRequestBuilder) {
            request = ((SmartRequestBuilder)requestBuilder).postProcessRequest(request);
        }
        final DefaultMvcResult mvcResult = new DefaultMvcResult(request, response);
        request.setAttribute(MVC_RESULT_ATTRIBUTE, mvcResult);
        RequestAttributes previousAttributes = RequestContextHolder.getRequestAttributes();
        RequestContextHolder.setRequestAttributes(new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response));
        MockFilterChain filterChain = new MockFilterChain((Servlet)this.servlet, this.filters);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        if (DispatcherType.ASYNC.equals((Object)request.getDispatcherType()) && request.getAsyncContext() != null & !request.isAsyncStarted()) {
            request.getAsyncContext().complete();
        }
        this.applyDefaultResultActions(mvcResult);
        RequestContextHolder.setRequestAttributes(previousAttributes);
        return new ResultActions(){

            @Override
            public ResultActions andExpect(ResultMatcher matcher) throws Exception {
                matcher.match(mvcResult);
                return this;
            }

            @Override
            public ResultActions andDo(ResultHandler handler) throws Exception {
                handler.handle(mvcResult);
                return this;
            }

            @Override
            public MvcResult andReturn() {
                return mvcResult;
            }
        };
    }

    private void applyDefaultResultActions(MvcResult mvcResult) throws Exception {
        for (ResultMatcher matcher : this.defaultResultMatchers) {
            matcher.match(mvcResult);
        }
        for (ResultHandler handler : this.defaultResultHandlers) {
            handler.handle(mvcResult);
        }
    }
}

