/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessageConverterExtractor<T>
implements ResponseExtractor<T> {
    private final Class<T> responseType;
    private final List<HttpMessageConverter<?>> messageConverters;
    private final Log logger;

    public HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters) {
        this(responseType, messageConverters, LogFactory.getLog(HttpMessageConverterExtractor.class));
    }

    HttpMessageConverterExtractor(Class<T> responseType, List<HttpMessageConverter<?>> messageConverters, Log logger) {
        Assert.notNull(responseType, "'responseType' must not be null");
        Assert.notEmpty(messageConverters, "'messageConverters' must not be empty");
        this.responseType = responseType;
        this.messageConverters = messageConverters;
        this.logger = logger;
    }

    @Override
    public T extractData(ClientHttpResponse response) throws IOException {
        if (!this.hasMessageBody(response)) {
            return null;
        }
        MediaType contentType = response.getHeaders().getContentType();
        if (contentType == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("No Content-Type header found, defaulting to application/octet-stream");
            }
            contentType = MediaType.APPLICATION_OCTET_STREAM;
        }
        for (HttpMessageConverter<T> httpMessageConverter : this.messageConverters) {
            if (!httpMessageConverter.canRead(this.responseType, contentType)) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Reading [" + this.responseType.getName() + "] as \"" + contentType + "\" using [" + httpMessageConverter + "]");
            }
            return (T)httpMessageConverter.read(this.responseType, response);
        }
        throw new RestClientException("Could not extract response: no suitable HttpMessageConverter found for response type [" + this.responseType.getName() + "] and content type [" + contentType + "]");
    }

    protected boolean hasMessageBody(ClientHttpResponse response) throws IOException {
        HttpStatus responseStatus = response.getStatusCode();
        if (responseStatus == HttpStatus.NO_CONTENT || responseStatus == HttpStatus.NOT_MODIFIED) {
            return false;
        }
        long contentLength = response.getHeaders().getContentLength();
        return contentLength != 0L;
    }
}

