/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UriComponents {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String scheme;
    private final String fragment;

    protected UriComponents(String scheme, String fragment) {
        this.scheme = scheme;
        this.fragment = fragment;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public abstract String getSchemeSpecificPart();

    public abstract String getUserInfo();

    public abstract String getHost();

    public abstract int getPort();

    public abstract String getPath();

    public abstract List<String> getPathSegments();

    public abstract String getQuery();

    public abstract MultiValueMap<String, String> getQueryParams();

    public final String getFragment() {
        return this.fragment;
    }

    public final UriComponents encode() {
        try {
            return this.encode(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new InternalError("\"UTF-8\" not supported");
        }
    }

    public abstract UriComponents encode(String var1) throws UnsupportedEncodingException;

    public final UriComponents expand(Map<String, ?> uriVariables) {
        Assert.notNull(uriVariables, "'uriVariables' must not be null");
        return this.expandInternal(new MapTemplateVariables(uriVariables));
    }

    public final UriComponents expand(Object ... uriVariableValues) {
        Assert.notNull(uriVariableValues, "'uriVariableValues' must not be null");
        return this.expandInternal(new VarArgsTemplateVariables(uriVariableValues));
    }

    abstract UriComponents expandInternal(UriTemplateVariables var1);

    static String expandUriComponent(String source, UriTemplateVariables uriVariables) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(123) == -1) {
            return source;
        }
        Matcher matcher = NAMES_PATTERN.matcher(source);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String match2 = matcher.group(1);
            String variableName = UriComponents.getVariableName(match2);
            Object variableValue = uriVariables.getValue(variableName);
            String variableValueString = UriComponents.getVariableValueAsString(variableValue);
            String replacement = Matcher.quoteReplacement(variableValueString);
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    private static String getVariableName(String match2) {
        int colonIdx = match2.indexOf(58);
        return colonIdx == -1 ? match2 : match2.substring(0, colonIdx);
    }

    private static String getVariableValueAsString(Object variableValue) {
        return variableValue != null ? variableValue.toString() : "";
    }

    public abstract String toUriString();

    public abstract URI toUri();

    public final String toString() {
        return this.toUriString();
    }

    public abstract UriComponents normalize();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MapTemplateVariables
    implements UriTemplateVariables {
        private final Map<String, ?> uriVariables;

        public MapTemplateVariables(Map<String, ?> uriVariables) {
            this.uriVariables = uriVariables;
        }

        @Override
        public Object getValue(String name) {
            if (!this.uriVariables.containsKey(name)) {
                throw new IllegalArgumentException("Map has no value for '" + name + "'");
            }
            return this.uriVariables.get(name);
        }
    }

    static interface UriTemplateVariables {
        public Object getValue(String var1);
    }

    private static class VarArgsTemplateVariables
    implements UriTemplateVariables {
        private final Iterator<Object> valueIterator;

        public VarArgsTemplateVariables(Object ... uriVariableValues) {
            this.valueIterator = Arrays.asList(uriVariableValues).iterator();
        }

        public Object getValue(String name) {
            if (!this.valueIterator.hasNext()) {
                throw new IllegalArgumentException("Not enough variable values available to expand '" + name + "'");
            }
            return this.valueIterator.next();
        }
    }
}

