/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.HierarchicalUriComponents;
import org.springframework.web.util.OpaqueUriComponents;
import org.springframework.web.util.UriComponents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriComponentsBuilder {
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("([^&=]+)=?([^&]+)?");
    private static final String SCHEME_PATTERN = "([^:/?#]+):";
    private static final String HTTP_PATTERN = "(http|https):";
    private static final String USERINFO_PATTERN = "([^@/]*)";
    private static final String HOST_PATTERN = "([^/?#:]*)";
    private static final String PORT_PATTERN = "(\\d*)";
    private static final String PATH_PATTERN = "([^?#]*)";
    private static final String QUERY_PATTERN = "([^#]*)";
    private static final String LAST_PATTERN = "(.*)";
    private static final Pattern URI_PATTERN = Pattern.compile("^(([^:/?#]+):)?(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?([^#]*))?(#(.*))?");
    private static final Pattern HTTP_URL_PATTERN = Pattern.compile("^(http|https):(//(([^@/]*)@)?([^/?#:]*)(:(\\d*))?)?([^?#]*)(\\?(.*))?");
    private String scheme;
    private String ssp;
    private String userInfo;
    private String host;
    private int port = -1;
    private PathComponentBuilder pathBuilder = NULL_PATH_COMPONENT_BUILDER;
    private final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
    private String fragment;
    private static PathComponentBuilder NULL_PATH_COMPONENT_BUILDER = new PathComponentBuilder(){

        public HierarchicalUriComponents.PathComponent build() {
            return HierarchicalUriComponents.NULL_PATH_COMPONENT;
        }

        public PathComponentBuilder appendPath(String path) {
            return new FullPathComponentBuilder(path);
        }

        public PathComponentBuilder appendPathSegments(String ... pathSegments) {
            return new PathSegmentComponentBuilder(pathSegments);
        }
    };

    protected UriComponentsBuilder() {
    }

    public static UriComponentsBuilder newInstance() {
        return new UriComponentsBuilder();
    }

    public static UriComponentsBuilder fromPath(String path) {
        UriComponentsBuilder builder = new UriComponentsBuilder();
        builder.path(path);
        return builder;
    }

    public static UriComponentsBuilder fromUri(URI uri) {
        UriComponentsBuilder builder = new UriComponentsBuilder();
        builder.uri(uri);
        return builder;
    }

    public static UriComponentsBuilder fromUriString(String uri) {
        Assert.hasLength(uri, "'uri' must not be empty");
        Matcher m = URI_PATTERN.matcher(uri);
        if (m.matches()) {
            String s;
            UriComponentsBuilder builder = new UriComponentsBuilder();
            String scheme = m.group(2);
            String userInfo = m.group(5);
            String host = m.group(6);
            String port = m.group(8);
            String path = m.group(9);
            String query2 = m.group(11);
            String fragment = m.group(13);
            boolean opaque = false;
            if (StringUtils.hasLength(scheme) && !(s = uri.substring(scheme.length())).startsWith(":/")) {
                opaque = true;
            }
            builder.scheme(scheme);
            if (opaque) {
                String ssp = uri.substring(scheme.length()).substring(1);
                if (StringUtils.hasLength(fragment)) {
                    ssp = ssp.substring(0, ssp.length() - (fragment.length() + 1));
                }
                builder.schemeSpecificPart(ssp);
            } else {
                builder.userInfo(userInfo);
                builder.host(host);
                if (StringUtils.hasLength(port)) {
                    builder.port(Integer.parseInt(port));
                }
                builder.path(path);
                builder.query(query2);
            }
            builder.fragment(fragment);
            return builder;
        }
        throw new IllegalArgumentException("[" + uri + "] is not a valid URI");
    }

    public static UriComponentsBuilder fromHttpUrl(String httpUrl) {
        Assert.notNull(httpUrl, "'httpUrl' must not be null");
        Matcher m = HTTP_URL_PATTERN.matcher(httpUrl);
        if (m.matches()) {
            UriComponentsBuilder builder = new UriComponentsBuilder();
            builder.scheme(m.group(1));
            builder.userInfo(m.group(4));
            builder.host(m.group(5));
            String port = m.group(7);
            if (StringUtils.hasLength(port)) {
                builder.port(Integer.parseInt(port));
            }
            builder.path(m.group(8));
            builder.query(m.group(10));
            return builder;
        }
        throw new IllegalArgumentException("[" + httpUrl + "] is not a valid HTTP URL");
    }

    public UriComponents build() {
        return this.build(false);
    }

    public UriComponents build(boolean encoded) {
        if (this.ssp != null) {
            return new OpaqueUriComponents(this.scheme, this.ssp, this.fragment);
        }
        return new HierarchicalUriComponents(this.scheme, this.userInfo, this.host, this.port, this.pathBuilder.build(), this.queryParams, this.fragment, encoded, true);
    }

    public UriComponents buildAndExpand(Map<String, ?> uriVariables) {
        return this.build(false).expand(uriVariables);
    }

    public UriComponents buildAndExpand(Object ... uriVariableValues) {
        return this.build(false).expand(uriVariableValues);
    }

    public UriComponentsBuilder uri(URI uri) {
        Assert.notNull(uri, "'uri' must not be null");
        this.scheme = uri.getScheme();
        if (uri.isOpaque()) {
            this.ssp = uri.getRawSchemeSpecificPart();
            this.resetHierarchicalComponents();
        } else {
            if (uri.getRawUserInfo() != null) {
                this.userInfo = uri.getRawUserInfo();
            }
            if (uri.getHost() != null) {
                this.host = uri.getHost();
            }
            if (uri.getPort() != -1) {
                this.port = uri.getPort();
            }
            if (StringUtils.hasLength(uri.getRawPath())) {
                this.pathBuilder = new FullPathComponentBuilder(uri.getRawPath());
            }
            if (StringUtils.hasLength(uri.getRawQuery())) {
                this.queryParams.clear();
                this.query(uri.getRawQuery());
            }
            this.resetSchemeSpecificPart();
        }
        if (uri.getRawFragment() != null) {
            this.fragment = uri.getRawFragment();
        }
        return this;
    }

    private void resetHierarchicalComponents() {
        this.userInfo = null;
        this.host = null;
        this.port = -1;
        this.pathBuilder = NULL_PATH_COMPONENT_BUILDER;
        this.queryParams.clear();
    }

    private void resetSchemeSpecificPart() {
        this.ssp = null;
    }

    public UriComponentsBuilder scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public UriComponentsBuilder schemeSpecificPart(String ssp) {
        this.ssp = ssp;
        this.resetHierarchicalComponents();
        return this;
    }

    public UriComponentsBuilder userInfo(String userInfo) {
        this.userInfo = userInfo;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder host(String host) {
        this.host = host;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder port(int port) {
        Assert.isTrue(port >= -1, "'port' must not be < -1");
        this.port = port;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder path(String path) {
        this.pathBuilder = path != null ? this.pathBuilder.appendPath(path) : NULL_PATH_COMPONENT_BUILDER;
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder replacePath(String path) {
        this.pathBuilder = NULL_PATH_COMPONENT_BUILDER;
        this.path(path);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder pathSegment(String ... pathSegments) throws IllegalArgumentException {
        Assert.notNull(pathSegments, "'segments' must not be null");
        this.pathBuilder = this.pathBuilder.appendPathSegments(pathSegments);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder query(String query2) {
        if (query2 != null) {
            Matcher m = QUERY_PARAM_PATTERN.matcher(query2);
            while (m.find()) {
                String name = m.group(1);
                String value = m.group(2);
                this.queryParam(name, value);
            }
        } else {
            this.queryParams.clear();
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder replaceQuery(String query2) {
        this.queryParams.clear();
        this.query(query2);
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder queryParam(String name, Object ... values) {
        Assert.notNull(name, "'name' must not be null");
        if (!ObjectUtils.isEmpty(values)) {
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                String valueAsString = value != null ? value.toString() : null;
                this.queryParams.add(name, valueAsString);
                ++n2;
            }
        } else {
            this.queryParams.add(name, null);
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder replaceQueryParam(String name, Object ... values) {
        Assert.notNull(name, "'name' must not be null");
        this.queryParams.remove(name);
        if (!ObjectUtils.isEmpty(values)) {
            this.queryParam(name, values);
        }
        this.resetSchemeSpecificPart();
        return this;
    }

    public UriComponentsBuilder fragment(String fragment) {
        if (fragment != null) {
            Assert.hasLength(fragment, "'fragment' must not be empty");
            this.fragment = fragment;
        } else {
            this.fragment = null;
        }
        return this;
    }

    private static class FullPathComponentBuilder
    implements PathComponentBuilder {
        private final StringBuilder path;

        private FullPathComponentBuilder(String path) {
            this.path = new StringBuilder(path);
        }

        public HierarchicalUriComponents.PathComponent build() {
            return new HierarchicalUriComponents.FullPathComponent(this.path.toString());
        }

        public PathComponentBuilder appendPath(String path) {
            this.path.append(path);
            return this;
        }

        public PathComponentBuilder appendPathSegments(String ... pathSegments) {
            PathComponentCompositeBuilder builder = new PathComponentCompositeBuilder(this);
            builder.appendPathSegments(pathSegments);
            return builder;
        }
    }

    private static interface PathComponentBuilder {
        public HierarchicalUriComponents.PathComponent build();

        public PathComponentBuilder appendPath(String var1);

        public PathComponentBuilder appendPathSegments(String ... var1);
    }

    private static class PathComponentCompositeBuilder
    implements PathComponentBuilder {
        private final List<PathComponentBuilder> pathComponentBuilders = new ArrayList<PathComponentBuilder>();

        private PathComponentCompositeBuilder(PathComponentBuilder builder) {
            this.pathComponentBuilders.add(builder);
        }

        public HierarchicalUriComponents.PathComponent build() {
            ArrayList<HierarchicalUriComponents.PathComponent> pathComponents = new ArrayList<HierarchicalUriComponents.PathComponent>(this.pathComponentBuilders.size());
            for (PathComponentBuilder pathComponentBuilder : this.pathComponentBuilders) {
                pathComponents.add(pathComponentBuilder.build());
            }
            return new HierarchicalUriComponents.PathComponentComposite(pathComponents);
        }

        public PathComponentBuilder appendPath(String path) {
            this.pathComponentBuilders.add(new FullPathComponentBuilder(path));
            return this;
        }

        public PathComponentBuilder appendPathSegments(String ... pathSegments) {
            this.pathComponentBuilders.add(new PathSegmentComponentBuilder(pathSegments));
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathSegmentComponentBuilder
    implements PathComponentBuilder {
        private final List<String> pathSegments = new ArrayList<String>();

        private PathSegmentComponentBuilder(String ... pathSegments) {
            this.pathSegments.addAll(this.removeEmptyPathSegments(pathSegments));
        }

        private Collection<String> removeEmptyPathSegments(String ... pathSegments) {
            ArrayList<String> result = new ArrayList<String>();
            String[] stringArray = pathSegments;
            int n = pathSegments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (StringUtils.hasText(segment)) {
                    result.add(segment);
                }
                ++n2;
            }
            return result;
        }

        @Override
        public HierarchicalUriComponents.PathComponent build() {
            return new HierarchicalUriComponents.PathSegmentComponent(this.pathSegments);
        }

        @Override
        public PathComponentBuilder appendPath(String path) {
            PathComponentCompositeBuilder builder = new PathComponentCompositeBuilder(this);
            builder.appendPath(path);
            return builder;
        }

        @Override
        public PathComponentBuilder appendPathSegments(String ... pathSegments) {
            this.pathSegments.addAll(this.removeEmptyPathSegments(pathSegments));
            return this;
        }
    }
}

