/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.CompilationFailureException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.manager.CompilerManager;
import org.codehaus.plexus.compiler.manager.NoSuchCompilerException;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SingleTargetSourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCompilerMojo
extends AbstractMojo {
    private boolean failOnError = true;
    private boolean debug = true;
    private boolean verbose;
    private boolean showDeprecation;
    private boolean optimize;
    private boolean showWarnings;
    protected String source;
    protected String target;
    private String encoding;
    private int staleMillis;
    private String compilerId;
    private String compilerVersion;
    private boolean fork;
    private String meminitial;
    private String maxmem;
    private String executable;
    private String proc;
    private String[] annotationProcessors;
    protected Map<String, String> compilerArguments;
    protected String compilerArgument;
    private String outputFileName;
    private String debuglevel;
    private ToolchainManager toolchainManager;
    private File basedir;
    private File buildDirectory;
    private CompilerManager compilerManager;
    private MavenSession session;

    protected abstract SourceInclusionScanner getSourceInclusionScanner(int var1);

    protected abstract SourceInclusionScanner getSourceInclusionScanner(String var1);

    protected abstract List<String> getClasspathElements();

    protected abstract List<String> getCompileSourceRoots();

    protected abstract File getOutputDirectory();

    protected abstract String getSource();

    protected abstract String getTarget();

    protected abstract String getCompilerArgument();

    protected abstract Map<String, String> getCompilerArguments();

    protected abstract File getGeneratedSourcesDirectory();

    @Override
    public void execute() throws MojoExecutionException, CompilationFailureException {
        List messages;
        Set<File> staleSources;
        List<String> compileSourceRoots;
        Compiler compiler;
        this.getLog().debug("Using compiler '" + this.compilerId + "'.");
        try {
            compiler = this.compilerManager.getCompiler(this.compilerId);
        }
        catch (NoSuchCompilerException e) {
            throw new MojoExecutionException("No such compiler '" + e.getCompilerId() + "'.");
        }
        Toolchain tc = this.getToolchain();
        if (tc != null) {
            this.getLog().info("Toolchain in compiler-plugin: " + tc);
            if (this.executable != null) {
                this.getLog().warn("Toolchains are ignored, 'executable' parameter is set to " + this.executable);
            } else {
                this.fork = true;
                this.executable = tc.findTool(this.compilerId);
            }
        }
        if ((compileSourceRoots = AbstractCompilerMojo.removeEmptyCompileSourceRoots(this.getCompileSourceRoots())).isEmpty()) {
            this.getLog().info("No sources to compile");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Source directories: " + compileSourceRoots.toString().replace(',', '\n'));
            this.getLog().debug("Classpath: " + this.getClasspathElements().toString().replace(',', '\n'));
            this.getLog().debug("Output directory: " + this.getOutputDirectory());
        }
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.setOutputLocation(this.getOutputDirectory().getAbsolutePath());
        compilerConfiguration.setClasspathEntries(this.getClasspathElements());
        compilerConfiguration.setSourceLocations(compileSourceRoots);
        compilerConfiguration.setOptimize(this.optimize);
        compilerConfiguration.setDebug(this.debug);
        if (this.debug && StringUtils.isNotEmpty(this.debuglevel)) {
            String[] split = StringUtils.split(this.debuglevel, ",");
            for (int i = 0; i < split.length; ++i) {
                if (split[i].equalsIgnoreCase("none") || split[i].equalsIgnoreCase("lines") || split[i].equalsIgnoreCase("vars") || split[i].equalsIgnoreCase("source")) continue;
                throw new IllegalArgumentException("The specified debug level: '" + split[i] + "' is unsupported. " + "Legal values are 'none', 'lines', 'vars', and 'source'.");
            }
            compilerConfiguration.setDebugLevel(this.debuglevel);
        }
        compilerConfiguration.setVerbose(this.verbose);
        compilerConfiguration.setShowWarnings(this.showWarnings);
        compilerConfiguration.setShowDeprecation(this.showDeprecation);
        compilerConfiguration.setSourceVersion(this.getSource());
        compilerConfiguration.setTargetVersion(this.getTarget());
        compilerConfiguration.setProc(this.proc);
        compilerConfiguration.setGeneratedSourcesDirectory(this.getGeneratedSourcesDirectory());
        compilerConfiguration.setAnnotationProcessors(this.annotationProcessors);
        compilerConfiguration.setSourceEncoding(this.encoding);
        Map<String, String> effectiveCompilerArguments = this.getCompilerArguments();
        String effectiveCompilerArgument = this.getCompilerArgument();
        if (effectiveCompilerArguments != null || effectiveCompilerArgument != null) {
            LinkedHashMap<String, String> cplrArgsCopy = new LinkedHashMap<String, String>();
            if (effectiveCompilerArguments != null) {
                for (Map.Entry<String, String> me : effectiveCompilerArguments.entrySet()) {
                    String key = me.getKey();
                    String value = me.getValue();
                    if (!key.startsWith("-")) {
                        key = "-" + key;
                    }
                    cplrArgsCopy.put(key, value);
                }
            }
            if (!StringUtils.isEmpty(effectiveCompilerArgument)) {
                cplrArgsCopy.put(effectiveCompilerArgument, null);
            }
            compilerConfiguration.setCustomCompilerArguments(cplrArgsCopy);
        }
        compilerConfiguration.setFork(this.fork);
        if (this.fork) {
            String value;
            if (!StringUtils.isEmpty(this.meminitial)) {
                value = this.getMemoryValue(this.meminitial);
                if (value != null) {
                    compilerConfiguration.setMeminitial(value);
                } else {
                    this.getLog().info("Invalid value for meminitial '" + this.meminitial + "'. Ignoring this option.");
                }
            }
            if (!StringUtils.isEmpty(this.maxmem)) {
                value = this.getMemoryValue(this.maxmem);
                if (value != null) {
                    compilerConfiguration.setMaxmem(value);
                } else {
                    this.getLog().info("Invalid value for maxmem '" + this.maxmem + "'. Ignoring this option.");
                }
            }
        }
        compilerConfiguration.setExecutable(this.executable);
        compilerConfiguration.setWorkingDirectory(this.basedir);
        compilerConfiguration.setCompilerVersion(this.compilerVersion);
        compilerConfiguration.setBuildDirectory(this.buildDirectory);
        compilerConfiguration.setOutputFileName(this.outputFileName);
        try {
            staleSources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(this.staleMillis));
            boolean canUpdateTarget = compiler.canUpdateTarget(compilerConfiguration);
            if (compiler.getCompilerOutputStyle().equals(CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) && !canUpdateTarget) {
                this.getLog().info("RESCANNING!");
                String inputFileEnding = compiler.getInputFileEnding(compilerConfiguration);
                Set<File> sources = this.computeStaleSources(compilerConfiguration, compiler, this.getSourceInclusionScanner(inputFileEnding));
                compilerConfiguration.setSourceFiles(sources);
            } else {
                compilerConfiguration.setSourceFiles(staleSources);
            }
        }
        catch (CompilerException e) {
            throw new MojoExecutionException("Error while computing stale sources.", e);
        }
        if (staleSources.isEmpty()) {
            this.getLog().info("Nothing to compile - all classes are up to date");
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("Classpath:");
            for (String s : this.getClasspathElements()) {
                this.getLog().debug(" " + s);
            }
            this.getLog().debug("Source roots:");
            for (String root : this.getCompileSourceRoots()) {
                this.getLog().debug(" " + root);
            }
            try {
                String[] cl;
                if (this.fork && compilerConfiguration.getExecutable() != null) {
                    this.getLog().debug("Excutable: ");
                    this.getLog().debug(" " + compilerConfiguration.getExecutable());
                }
                if ((cl = compiler.createCommandLine(compilerConfiguration)) != null && cl.length > 0) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(cl[0]);
                    for (int i = 1; i < cl.length; ++i) {
                        sb.append(" ");
                        sb.append(cl[i]);
                    }
                    this.getLog().debug("Command line options:");
                    this.getLog().debug(sb);
                }
            }
            catch (CompilerException ce) {
                this.getLog().debug(ce);
            }
        }
        if (StringUtils.isEmpty(compilerConfiguration.getSourceEncoding())) {
            this.getLog().warn("File encoding has not been set, using platform encoding " + ReaderFactory.FILE_ENCODING + ", i.e. build is platform dependent!");
        }
        try {
            messages = compiler.compile(compilerConfiguration);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Fatal error compiling", e);
        }
        ArrayList<CompilerError> warnings = new ArrayList<CompilerError>();
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        if (messages != null) {
            for (CompilerError message : messages) {
                if (message.isError()) {
                    errors.add(message);
                    continue;
                }
                warnings.add(message);
            }
        }
        if (this.failOnError && !errors.isEmpty()) {
            if (!warnings.isEmpty()) {
                this.getLog().info("-------------------------------------------------------------");
                this.getLog().warn("COMPILATION WARNING : ");
                this.getLog().info("-------------------------------------------------------------");
                for (CompilerError warning : warnings) {
                    this.getLog().warn(warning.toString());
                }
                this.getLog().info(warnings.size() + (warnings.size() > 1 ? " warnings " : "warning"));
                this.getLog().info("-------------------------------------------------------------");
            }
            this.getLog().info("-------------------------------------------------------------");
            this.getLog().error("COMPILATION ERROR : ");
            this.getLog().info("-------------------------------------------------------------");
            for (CompilerError error : errors) {
                this.getLog().error(error.toString());
            }
            this.getLog().info(errors.size() + (errors.size() > 1 ? " errors " : "error"));
            this.getLog().info("-------------------------------------------------------------");
            throw new CompilationFailureException(errors);
        }
        for (CompilerError message : messages) {
            this.getLog().warn(message.toString());
        }
    }

    private String getMemoryValue(String setting) {
        String value = null;
        if (this.isDigits(setting)) {
            value = setting + "m";
        } else if (this.isDigits(setting.substring(0, setting.length() - 1)) && setting.toLowerCase().endsWith("m")) {
            value = setting;
        }
        return value;
    }

    private Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.toolchainManager != null) {
            tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        }
        return tc;
    }

    private boolean isDigits(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private Set<File> computeStaleSources(CompilerConfiguration compilerConfiguration, Compiler compiler, SourceInclusionScanner scanner) throws MojoExecutionException, CompilerException {
        File outputDirectory;
        SourceMapping mapping;
        CompilerOutputStyle outputStyle = compiler.getCompilerOutputStyle();
        if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE) {
            mapping = new SuffixMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFileEnding(compilerConfiguration));
            outputDirectory = this.getOutputDirectory();
        } else if (outputStyle == CompilerOutputStyle.ONE_OUTPUT_FILE_FOR_ALL_INPUT_FILES) {
            mapping = new SingleTargetSourceMapping(compiler.getInputFileEnding(compilerConfiguration), compiler.getOutputFile(compilerConfiguration));
            outputDirectory = this.buildDirectory;
        } else {
            throw new MojoExecutionException("Unknown compiler output style: '" + outputStyle + "'.");
        }
        scanner.addSourceMapping(mapping);
        HashSet<File> staleSources = new HashSet<File>();
        for (String sourceRoot : this.getCompileSourceRoots()) {
            File rootFile = new File(sourceRoot);
            if (!rootFile.isDirectory()) continue;
            try {
                staleSources.addAll(scanner.getIncludedSources(rootFile, outputDirectory));
            }
            catch (InclusionScanException e) {
                throw new MojoExecutionException("Error scanning source root: '" + sourceRoot + "' " + "for stale files to recompile.", e);
            }
        }
        return staleSources;
    }

    private static List<String> removeEmptyCompileSourceRoots(List<String> compileSourceRootsList) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                if (newCompileSourceRootsList.contains(srcDir) || !new File(srcDir).exists()) continue;
                newCompileSourceRootsList.add(srcDir);
            }
        }
        return newCompileSourceRootsList;
    }
}

