/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonsHttpSolrServer
extends SolrServer {
    public static final String AGENT = "Solr[" + CommonsHttpSolrServer.class.getName() + "] 1.0";
    private static Logger log = LoggerFactory.getLogger(CommonsHttpSolrServer.class);
    protected String _baseURL;
    protected ModifiableSolrParams _invariantParams;
    protected ResponseParser _parser;
    protected RequestWriter requestWriter = new RequestWriter();
    private final HttpClient _httpClient;
    private boolean _followRedirects = false;
    private boolean _allowCompression = false;
    private int _maxRetries = 0;
    private boolean useMultiPartPost;

    public CommonsHttpSolrServer(String solrServerUrl) throws MalformedURLException {
        this(new URL(solrServerUrl));
    }

    public CommonsHttpSolrServer(String solrServerUrl, HttpClient httpClient) throws MalformedURLException {
        this(new URL(solrServerUrl), httpClient, new BinaryResponseParser(), false);
    }

    public CommonsHttpSolrServer(String solrServerUrl, HttpClient httpClient, boolean useMultiPartPost) throws MalformedURLException {
        this(new URL(solrServerUrl), httpClient, new BinaryResponseParser(), useMultiPartPost);
    }

    public CommonsHttpSolrServer(String solrServerUrl, HttpClient httpClient, ResponseParser parser) throws MalformedURLException {
        this(new URL(solrServerUrl), httpClient, parser, false);
    }

    public CommonsHttpSolrServer(URL baseURL) {
        this(baseURL, null, new BinaryResponseParser(), false);
    }

    public CommonsHttpSolrServer(URL baseURL, HttpClient client) {
        this(baseURL, client, new BinaryResponseParser(), false);
    }

    public CommonsHttpSolrServer(URL baseURL, HttpClient client, boolean useMultiPartPost) {
        this(baseURL, client, new BinaryResponseParser(), useMultiPartPost);
    }

    public CommonsHttpSolrServer(URL baseURL, HttpClient client, ResponseParser parser, boolean useMultiPartPost) {
        this._baseURL = baseURL.toExternalForm();
        if (this._baseURL.endsWith("/")) {
            this._baseURL = this._baseURL.substring(0, this._baseURL.length() - 1);
        }
        if (this._baseURL.indexOf(63) >= 0) {
            throw new RuntimeException("Invalid base url for solrj.  The base URL must not contain parameters: " + this._baseURL);
        }
        if (client == null) {
            this._httpClient = new HttpClient(new MultiThreadedHttpConnectionManager());
            DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(0, false);
            this._httpClient.getParams().setParameter("http.method.retry-handler", retryhandler);
            this.setDefaultMaxConnectionsPerHost(32);
            this.setMaxTotalConnections(128);
        } else {
            this._httpClient = client;
        }
        this._parser = parser;
        this.useMultiPartPost = useMultiPartPost;
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = this._parser;
        }
        return this.request(request, responseParser);
    }

    /*
     * Exception decompiling
     */
    public NamedList<Object> request(SolrRequest request, ResponseParser processor) throws SolrServerException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[WHILELOOP], 1[TRYBLOCK]], but top level block is 43[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ModifiableSolrParams getInvariantParams() {
        return this._invariantParams;
    }

    public String getBaseURL() {
        return this._baseURL;
    }

    public void setBaseURL(String baseURL) {
        this._baseURL = baseURL;
    }

    public ResponseParser getParser() {
        return this._parser;
    }

    public void setParser(ResponseParser processor) {
        this._parser = processor;
    }

    public HttpClient getHttpClient() {
        return this._httpClient;
    }

    private HttpConnectionManager getConnectionManager() {
        return this._httpClient.getHttpConnectionManager();
    }

    public void setConnectionTimeout(int timeout) {
        this.getConnectionManager().getParams().setConnectionTimeout(timeout);
    }

    @Deprecated
    public void setConnectionManagerTimeout(int timeout) {
        this._httpClient.getParams().setConnectionManagerTimeout(timeout);
    }

    public void setConnectionManagerTimeout(long timeout) {
        this._httpClient.getParams().setConnectionManagerTimeout(timeout);
    }

    public void setSoTimeout(int timeout) {
        this.getConnectionManager().getParams().setSoTimeout(timeout);
    }

    public void setDefaultMaxConnectionsPerHost(int connections) {
        this.getConnectionManager().getParams().setDefaultMaxConnectionsPerHost(connections);
    }

    public void setMaxTotalConnections(int connections) {
        this.getConnectionManager().getParams().setMaxTotalConnections(connections);
    }

    public void setFollowRedirects(boolean followRedirects) {
        this._followRedirects = followRedirects;
    }

    public void setAllowCompression(boolean allowCompression) {
        this._allowCompression = allowCompression;
    }

    public void setMaxRetries(int maxRetries) {
        if (maxRetries > 1) {
            log.warn("CommonsHttpSolrServer: maximum Retries " + maxRetries + " > 1. Maximum recommended retries is 1.");
        }
        this._maxRetries = maxRetries;
    }

    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public UpdateResponse add(Iterator<SolrInputDocument> docIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(docIterator);
        return req.process(this);
    }

    public UpdateResponse addBeans(final Iterator<?> beanIterator) throws SolrServerException, IOException {
        UpdateRequest req = new UpdateRequest();
        req.setDocIterator(new Iterator<SolrInputDocument>(){

            @Override
            public boolean hasNext() {
                return beanIterator.hasNext();
            }

            @Override
            public SolrInputDocument next() {
                Object o = beanIterator.next();
                if (o == null) {
                    return null;
                }
                return CommonsHttpSolrServer.this.getBinder().toSolrInputDocument(o);
            }

            @Override
            public void remove() {
                beanIterator.remove();
            }
        });
        return req.process(this);
    }
}

