/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LBHttpSolrServer
extends SolrServer {
    private final CopyOnWriteArrayList<ServerWrapper> aliveServers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ServerWrapper> zombieServers = new CopyOnWriteArrayList();
    private ScheduledExecutorService aliveCheckExecutor;
    private HttpClient httpClient;
    private final AtomicInteger counter = new AtomicInteger(-1);
    private ReentrantLock checkLock = new ReentrantLock();
    private static final SolrQuery solrQuery = new SolrQuery("*:*");
    private int interval = 60000;
    private static final int CHECK_INTERVAL = 60000;

    public LBHttpSolrServer(String ... solrServerUrls) throws MalformedURLException {
        this(new HttpClient(new MultiThreadedHttpConnectionManager()), solrServerUrls);
    }

    public LBHttpSolrServer(HttpClient httpClient, String ... solrServerUrl) throws MalformedURLException {
        this(httpClient, new BinaryResponseParser(), solrServerUrl);
    }

    public LBHttpSolrServer(HttpClient httpClient, ResponseParser parser, String ... solrServerUrl) throws MalformedURLException {
        this.httpClient = httpClient;
        for (String s : solrServerUrl) {
            this.aliveServers.add(new ServerWrapper(new CommonsHttpSolrServer(s, httpClient, parser)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSolrServer(String server) throws MalformedURLException {
        CommonsHttpSolrServer solrServer = new CommonsHttpSolrServer(server, this.httpClient);
        this.checkLock.lock();
        try {
            this.aliveServers.add(new ServerWrapper(solrServer));
        }
        finally {
            this.checkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeSolrServer(String server) {
        try {
            server = new URL(server).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (server.endsWith("/")) {
            server = server.substring(0, server.length() - 1);
        }
        this.checkLock.lock();
        try {
            for (ServerWrapper serverWrapper : this.aliveServers) {
                if (!serverWrapper.solrServer.getBaseURL().equals(server)) continue;
                this.aliveServers.remove(serverWrapper);
                String string = serverWrapper.solrServer.getBaseURL();
                return string;
            }
            if (this.zombieServers.isEmpty()) {
                Iterator<ServerWrapper> i$ = null;
                return i$;
            }
            for (ServerWrapper serverWrapper : this.zombieServers) {
                if (!serverWrapper.solrServer.getBaseURL().equals(server)) continue;
                this.zombieServers.remove(serverWrapper);
                String string = serverWrapper.solrServer.getBaseURL();
                return string;
            }
        }
        finally {
            this.checkLock.unlock();
        }
        return null;
    }

    public void setConnectionTimeout(int timeout) {
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(timeout);
    }

    public void setConnectionManagerTimeout(int timeout) {
        this.httpClient.getParams().setConnectionManagerTimeout(timeout);
    }

    public void setSoTimeout(int timeout) {
        this.httpClient.getParams().setSoTimeout(timeout);
    }

    @Override
    public NamedList<Object> request(SolrRequest request) throws SolrServerException, IOException {
        SolrServerException ex;
        int count = this.counter.incrementAndGet();
        int attempts = 0;
        int startSize = this.aliveServers.size();
        while (true) {
            ServerWrapper solrServer;
            int size;
            if ((size = this.aliveServers.size()) < 1) {
                throw new SolrServerException("No live SolrServers available to handle this request");
            }
            try {
                solrServer = this.aliveServers.get(count % size);
            }
            catch (IndexOutOfBoundsException e) {
                continue;
            }
            try {
                return solrServer.solrServer.request(request);
            }
            catch (SolrException e) {
                throw e;
            }
            catch (SolrServerException e) {
                if (e.getRootCause() instanceof IOException) {
                    ex = e;
                    this.moveAliveToDead(solrServer);
                }
                throw e;
            }
            catch (Exception e) {
                throw new SolrServerException(e);
            }
            if (++attempts >= startSize) break;
        }
        throw new SolrServerException("No live SolrServers available to handle this request", ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAZombieServer(ServerWrapper zombieServer) {
        long currTime = System.currentTimeMillis();
        this.checkLock.lock();
        try {
            zombieServer.lastChecked = currTime;
            QueryResponse resp = zombieServer.solrServer.query(solrQuery);
            if (resp.getStatus() == 0) {
                zombieServer.lastUsed = currTime;
                this.zombieServers.remove(zombieServer);
                this.aliveServers.add(zombieServer);
                zombieServer.failedPings = 0;
            }
        }
        catch (Exception e) {
            ++zombieServer.failedPings;
        }
        finally {
            this.checkLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveAliveToDead(ServerWrapper solrServer) {
        this.checkLock.lock();
        try {
            boolean result = this.aliveServers.remove(solrServer);
            if (result && this.zombieServers.addIfAbsent(solrServer)) {
                this.startAliveCheckExecutor();
            }
        }
        finally {
            this.checkLock.unlock();
        }
    }

    public void setAliveCheckInterval(int interval) {
        if (interval <= 0) {
            throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + interval);
        }
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAliveCheckExecutor() {
        if (this.aliveCheckExecutor == null) {
            LBHttpSolrServer lBHttpSolrServer = this;
            synchronized (lBHttpSolrServer) {
                if (this.aliveCheckExecutor == null) {
                    this.aliveCheckExecutor = Executors.newSingleThreadScheduledExecutor();
                    this.aliveCheckExecutor.scheduleAtFixedRate(LBHttpSolrServer.getAliveCheckRunner(new WeakReference<LBHttpSolrServer>(this)), this.interval, this.interval, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private static Runnable getAliveCheckRunner(final WeakReference<LBHttpSolrServer> lbHttpSolrServer) {
        return new Runnable(){

            public void run() {
                LBHttpSolrServer solrServer = (LBHttpSolrServer)lbHttpSolrServer.get();
                if (solrServer != null && solrServer.zombieServers != null) {
                    for (ServerWrapper zombieServer : solrServer.zombieServers) {
                        solrServer.checkAZombieServer(zombieServer);
                    }
                }
            }
        };
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.aliveCheckExecutor != null) {
                this.aliveCheckExecutor.shutdownNow();
            }
        }
        finally {
            super.finalize();
        }
    }

    static {
        solrQuery.setRows(0);
    }

    private static class ServerWrapper {
        final CommonsHttpSolrServer solrServer;
        long lastUsed;
        long lastChecked;
        int failedPings = 0;

        public ServerWrapper(CommonsHttpSolrServer solrServer) {
            this.solrServer = solrServer;
        }

        public String toString() {
            return this.solrServer.getBaseURL();
        }
    }
}

