/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.Record;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.StatPersisted;
import org.apache.zookeeper.jmx.MBeanRegistry;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.DataTreeBean;
import org.apache.zookeeper.server.FinalRequestProcessor;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.PrepRequestProcessor;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.RequestProcessor;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.SessionTrackerImpl;
import org.apache.zookeeper.server.SyncRequestProcessor;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServerBean;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZooKeeperServer
implements SessionTracker.SessionExpirer,
ServerStats.Provider {
    protected static final Logger LOG = Logger.getLogger(ZooKeeperServer.class);
    protected ZooKeeperServerBean jmxServerBean;
    protected DataTreeBean jmxDataTreeBean;
    public static final int DEFAULT_TICK_TIME = 3000;
    protected int tickTime = 3000;
    protected int minSessionTimeout = -1;
    protected int maxSessionTimeout = -1;
    protected SessionTracker sessionTracker;
    private FileTxnSnapLog txnLogFactory = null;
    private ConcurrentHashMap<Long, Integer> sessionsWithTimeouts;
    private ZKDatabase zkDb;
    protected long hzxid = 0L;
    public static final Exception ok;
    protected RequestProcessor firstProcessor;
    protected volatile boolean running;
    private static final long superSecret = 3007405056L;
    int requestsInProcess;
    final List<ChangeRecord> outstandingChanges = new ArrayList<ChangeRecord>();
    final HashMap<String, ChangeRecord> outstandingChangesForPath = new HashMap();
    private NIOServerCnxn.Factory serverCnxnFactory;
    private final ServerStats serverStats = new ServerStats(this);

    void removeCnxn(ServerCnxn cnxn) {
        this.zkDb.removeCnxn(cnxn);
    }

    public ZooKeeperServer() {
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, int minSessionTimeout, int maxSessionTimeout, DataTreeBuilder treeBuilder, ZKDatabase zkDb) throws IOException {
        this.txnLogFactory = txnLogFactory;
        this.zkDb = zkDb;
        this.tickTime = tickTime;
        this.minSessionTimeout = minSessionTimeout;
        this.maxSessionTimeout = maxSessionTimeout;
        LOG.info("Created server with tickTime " + tickTime + " minSessionTimeout " + this.getMinSessionTimeout() + " maxSessionTimeout " + this.getMaxSessionTimeout() + " datadir " + txnLogFactory.getDataDir() + " snapdir " + txnLogFactory.getSnapDir());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, int tickTime, DataTreeBuilder treeBuilder) throws IOException {
        this(txnLogFactory, tickTime, -1, -1, treeBuilder, new ZKDatabase(txnLogFactory));
    }

    public ServerStats serverStats() {
        return this.serverStats;
    }

    public void dumpConf(PrintWriter pwriter) {
        pwriter.print("clientPort=");
        pwriter.println(this.getClientPort());
        pwriter.print("dataDir=");
        pwriter.println(this.zkDb.snapLog.getSnapDir().getAbsolutePath());
        pwriter.print("dataLogDir=");
        pwriter.println(this.zkDb.snapLog.getDataDir().getAbsolutePath());
        pwriter.print("tickTime=");
        pwriter.println(this.getTickTime());
        pwriter.print("maxClientCnxns=");
        pwriter.println(this.serverCnxnFactory.getMaxClientCnxns());
        pwriter.print("minSessionTimeout=");
        pwriter.println(this.getMinSessionTimeout());
        pwriter.print("maxSessionTimeout=");
        pwriter.println(this.getMaxSessionTimeout());
        pwriter.print("serverId=");
        pwriter.println(this.getServerId());
    }

    public ZooKeeperServer(File snapDir, File logDir, int tickTime) throws IOException {
        this(new FileTxnSnapLog(snapDir, logDir), tickTime, new BasicDataTreeBuilder());
    }

    public ZooKeeperServer(FileTxnSnapLog txnLogFactory, DataTreeBuilder treeBuilder) throws IOException {
        this(txnLogFactory, 3000, -1, -1, treeBuilder, new ZKDatabase(txnLogFactory));
    }

    public ZKDatabase getZKDatabase() {
        return this.zkDb;
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkDb = zkDb;
    }

    public void loadData() throws IOException, InterruptedException {
        this.zkDb.loadDataBase();
        this.setZxid(this.zkDb.loadDataBase());
        LinkedList<Long> deadSessions = new LinkedList<Long>();
        for (long session : this.zkDb.getSessions()) {
            this.sessionsWithTimeouts = this.zkDb.getSessionWithTimeOuts();
            if (this.sessionsWithTimeouts.get(session) != null) continue;
            deadSessions.add(session);
        }
        this.zkDb.setDataTreeInit(true);
        for (long session : deadSessions) {
            this.killSession(session, this.zkDb.getDataTreeLastProcessedZxid());
        }
        this.takeSnapshot();
    }

    public void takeSnapshot() {
        try {
            this.txnLogFactory.save(this.zkDb.getDataTree(), this.zkDb.getSessionWithTimeOuts());
        }
        catch (IOException e) {
            LOG.fatal("Severe unrecoverable error, exiting", e);
            System.exit(10);
        }
    }

    public synchronized long getZxid() {
        return this.hzxid;
    }

    synchronized long getNextZxid() {
        return ++this.hzxid;
    }

    public synchronized void setZxid(long zxid) {
        this.hzxid = zxid;
    }

    long getTime() {
        return System.currentTimeMillis();
    }

    private void close(long sessionId) {
        this.submitRequest(null, sessionId, -11, 0, null, null);
    }

    public void closeSession(long sessionId) {
        LOG.info("Closing session 0x" + Long.toHexString(sessionId));
        this.close(sessionId);
    }

    protected void killSession(long sessionId, long zxid) {
        this.zkDb.killSession(sessionId, zxid);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "ZooKeeperServer --- killSession: 0x" + Long.toHexString(sessionId));
        }
        if (this.sessionTracker != null) {
            this.sessionTracker.removeSession(sessionId);
        }
    }

    @Override
    public void expire(SessionTracker.Session session) {
        long sessionId = session.getSessionId();
        LOG.info("Expiring session 0x" + Long.toHexString(sessionId) + ", timeout of " + session.getTimeout() + "ms exceeded");
        this.close(sessionId);
    }

    void touch(ServerCnxn cnxn) throws MissingSessionException {
        int to;
        if (cnxn == null) {
            return;
        }
        long id = cnxn.getSessionId();
        if (!this.sessionTracker.touchSession(id, to = cnxn.getSessionTimeout())) {
            throw new MissingSessionException("No session with sessionid 0x" + Long.toHexString(id) + " exists, probably expired and removed");
        }
    }

    protected void registerJMX() {
        try {
            this.jmxServerBean = new ZooKeeperServerBean(this);
            MBeanRegistry.getInstance().register(this.jmxServerBean, null);
            try {
                this.jmxDataTreeBean = new DataTreeBean(this.zkDb.getDataTree());
                MBeanRegistry.getInstance().register(this.jmxDataTreeBean, this.jmxServerBean);
            }
            catch (Exception e) {
                LOG.warn("Failed to register with JMX", e);
                this.jmxDataTreeBean = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to register with JMX", e);
            this.jmxServerBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws IOException, InterruptedException {
        if (this.zkDb == null) {
            this.zkDb = new ZKDatabase(this.txnLogFactory);
        }
        if (!this.zkDb.isInitialized()) {
            this.loadData();
        }
        this.createSessionTracker();
        this.setupRequestProcessors();
        this.registerJMX();
        ZooKeeperServer zooKeeperServer = this;
        synchronized (zooKeeperServer) {
            this.running = true;
            this.notifyAll();
        }
    }

    protected void setupRequestProcessors() {
        FinalRequestProcessor finalProcessor = new FinalRequestProcessor(this);
        SyncRequestProcessor syncProcessor = new SyncRequestProcessor(this, finalProcessor);
        syncProcessor.start();
        this.firstProcessor = new PrepRequestProcessor(this, syncProcessor);
        ((PrepRequestProcessor)this.firstProcessor).start();
    }

    protected void createSessionTracker() {
        this.sessionTracker = new SessionTrackerImpl(this, this.zkDb.getSessionWithTimeOuts(), this.tickTime, 1L);
        ((SessionTrackerImpl)this.sessionTracker).start();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void shutdown() {
        this.running = false;
        if (this.sessionTracker != null) {
            this.sessionTracker.shutdown();
        }
        if (this.firstProcessor != null) {
            this.firstProcessor.shutdown();
        }
        if (this.zkDb != null) {
            this.zkDb.clear();
        }
        this.unregisterJMX();
    }

    protected void unregisterJMX() {
        try {
            if (this.jmxDataTreeBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxDataTreeBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        try {
            if (this.jmxServerBean != null) {
                MBeanRegistry.getInstance().unregister(this.jmxServerBean);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to unregister with JMX", e);
        }
        this.jmxServerBean = null;
        this.jmxDataTreeBean = null;
    }

    public synchronized void incInProcess() {
        ++this.requestsInProcess;
    }

    public synchronized void decInProcess() {
        --this.requestsInProcess;
    }

    public int getInProcess() {
        return this.requestsInProcess;
    }

    byte[] generatePasswd(long id) {
        Random r = new Random(id ^ 0xB3415C00L);
        byte[] p = new byte[16];
        r.nextBytes(p);
        return p;
    }

    protected boolean checkPasswd(long sessionId, byte[] passwd) {
        return sessionId != 0L && Arrays.equals(passwd, this.generatePasswd(sessionId));
    }

    long createSession(ServerCnxn cnxn, byte[] passwd, int timeout) throws InterruptedException {
        long sessionId = this.sessionTracker.createSession(timeout);
        Random r = new Random(sessionId ^ 0xB3415C00L);
        r.nextBytes(passwd);
        ByteBuffer to = ByteBuffer.allocate(4);
        to.putInt(timeout);
        cnxn.setSessionId(sessionId);
        this.submitRequest(cnxn, sessionId, -10, 0, to, null);
        return sessionId;
    }

    public void setOwner(long id, Object owner) throws KeeperException.SessionExpiredException {
        this.sessionTracker.setOwner(id, owner);
    }

    protected void revalidateSession(ServerCnxn cnxn, long sessionId, int sessionTimeout) throws IOException, InterruptedException {
        boolean rc = this.sessionTracker.touchSession(sessionId, sessionTimeout);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 32L, "Session 0x" + Long.toHexString(sessionId) + " is valid: " + rc);
        }
        cnxn.finishSessionInit(rc);
    }

    public void reopenSession(ServerCnxn cnxn, long sessionId, byte[] passwd, int sessionTimeout) throws IOException, InterruptedException {
        if (!this.checkPasswd(sessionId, passwd)) {
            cnxn.finishSessionInit(false);
        } else {
            this.revalidateSession(cnxn, sessionId, sessionTimeout);
        }
    }

    public void closeSession(ServerCnxn cnxn, RequestHeader requestHeader) {
        this.closeSession(cnxn.getSessionId());
    }

    @Override
    public long getServerId() {
        return 0L;
    }

    private void submitRequest(ServerCnxn cnxn, long sessionId, int type, int xid, ByteBuffer bb, List<Id> authInfo) {
        Request si = new Request(cnxn, sessionId, xid, type, bb, authInfo);
        this.submitRequest(si);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(Request si) {
        block13: {
            if (this.firstProcessor == null) {
                ZooKeeperServer zooKeeperServer = this;
                synchronized (zooKeeperServer) {
                    try {
                        while (!this.running) {
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Unexpected interruption", e);
                    }
                    if (this.firstProcessor == null) {
                        throw new RuntimeException("Not started");
                    }
                }
            }
            try {
                this.touch(si.cnxn);
                boolean validpacket = Request.isValid(si.type);
                if (validpacket) {
                    this.firstProcessor.processRequest(si);
                    if (si.cnxn != null) {
                        this.incInProcess();
                    }
                } else {
                    LOG.warn("Dropping packet at server of type " + si.type);
                }
            }
            catch (MissingSessionException e) {
                if (!LOG.isDebugEnabled()) break block13;
                LOG.debug("Dropping request: " + e.getMessage());
            }
        }
    }

    public static void byteBuffer2Record(ByteBuffer bb, Record record) throws IOException {
        BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteBufferInputStream(bb));
        record.deserialize(ia, "request");
    }

    public static int getSnapCount() {
        String sc = System.getProperty("zookeeper.snapCount");
        try {
            return Integer.parseInt(sc);
        }
        catch (Exception e) {
            return 100000;
        }
    }

    public int getGlobalOutstandingLimit() {
        int limit;
        String sc = System.getProperty("zookeeper.globalOutstandingLimit");
        try {
            limit = Integer.parseInt(sc);
        }
        catch (Exception e) {
            limit = 1000;
        }
        return limit;
    }

    public void setServerCnxnFactory(NIOServerCnxn.Factory factory) {
        this.serverCnxnFactory = factory;
    }

    public NIOServerCnxn.Factory getServerCnxnFactory() {
        return this.serverCnxnFactory;
    }

    @Override
    public long getLastProcessedZxid() {
        return this.zkDb.getDataTreeLastProcessedZxid();
    }

    @Override
    public long getOutstandingRequests() {
        return this.getInProcess();
    }

    public void truncateLog(long zxid) throws IOException {
        this.zkDb.truncateLog(zxid);
    }

    public int getTickTime() {
        return this.tickTime;
    }

    public void setTickTime(int tickTime) {
        LOG.info("tickTime set to " + tickTime);
        this.tickTime = tickTime;
    }

    public int getMinSessionTimeout() {
        return this.minSessionTimeout == -1 ? this.tickTime * 2 : this.minSessionTimeout;
    }

    public void setMinSessionTimeout(int min) {
        LOG.info("minSessionTimeout set to " + min);
        this.minSessionTimeout = min;
    }

    public int getMaxSessionTimeout() {
        return this.maxSessionTimeout == -1 ? this.tickTime * 20 : this.maxSessionTimeout;
    }

    public void setMaxSessionTimeout(int max) {
        LOG.info("maxSessionTimeout set to " + max);
        this.maxSessionTimeout = max;
    }

    public int getClientPort() {
        return this.serverCnxnFactory != null ? this.serverCnxnFactory.ss.socket().getLocalPort() : -1;
    }

    public void setTxnLogFactory(FileTxnSnapLog txnLog) {
        this.txnLogFactory = txnLog;
    }

    public FileTxnSnapLog getTxnLogFactory() {
        return this.txnLogFactory;
    }

    @Override
    public String getState() {
        return "standalone";
    }

    public void dumpEphemerals(PrintWriter pwriter) {
        this.zkDb.dumpEphemerals(pwriter);
    }

    static {
        Environment.logEnv("Server environment:", LOG);
        ok = new Exception("No prob");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ChangeRecord {
        long zxid;
        String path;
        StatPersisted stat;
        int childCount;
        List<ACL> acl;

        ChangeRecord(long zxid, String path, StatPersisted stat, int childCount, List<ACL> acl) {
            this.zxid = zxid;
            this.path = path;
            this.stat = stat;
            this.childCount = childCount;
            this.acl = acl;
        }

        ChangeRecord duplicate(long zxid) {
            StatPersisted stat = new StatPersisted();
            if (this.stat != null) {
                DataTree.copyStatPersisted(this.stat, stat);
            }
            return new ChangeRecord(zxid, this.path, stat, this.childCount, this.acl == null ? new ArrayList<ACL>() : new ArrayList<ACL>(this.acl));
        }
    }

    public static class MissingSessionException
    extends IOException {
        private static final long serialVersionUID = 7467414635467261007L;

        public MissingSessionException(String msg) {
            super(msg);
        }
    }

    public static class BasicDataTreeBuilder
    implements DataTreeBuilder {
        public DataTree build() {
            return new DataTree();
        }
    }

    public static interface DataTreeBuilder {
        public DataTree build();
    }

    public static interface Factory {
        public ZooKeeperServer createServer() throws IOException;

        public NIOServerCnxn.Factory createConnectionFactory() throws IOException;
    }
}

