/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.dao;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.configuration.Settings;

public class DataSourceFactory {
    private static final Log log = LogFactory.getLog(DataSourceFactory.class);
    private static BasicDataSource metacatDataSource;
    private static BasicDataSource postgresDataSource;
    private static final String metacatUrlProperty = "metacat.datasource.url";
    private static final String metacatDriverClassProperty = "metacat.datasource.driverClass";
    private static final String metacatUsernameProperty = "database.user";
    private static final String metacatPasswordProperty = "database.password";
    private static final String metacatInitialPoolSizeProperty = "metacat.datasource.initialSize";
    private static final String metacatMaxPoolSizeProperty = "metacat.datasource.maxSize";
    private static final String urlProp = "datasource.postgres.url";
    private static final String driverClassProp = "datasource.postgres.driverClass";
    private static final String usernameProp = "datasource.postgres.user";
    private static final String passwordProperty = "datasource.postgres.password";
    private static final String initialPoolSizeProperty = "datasource.postgres.initialSize";
    private static final String maxPoolSizeProperty = "datasource.postgres.maxSize";
    private static final String url;
    private static final String driverClass;
    private static final String username;
    private static final String password;
    private static final String initialPoolSize;
    private static final String maxPoolSize;
    private static final String metacatUrl;
    private static final String metacatDriverClass;
    private static final String metacatUsername;
    private static final String metacatPassword;
    private static final String metacatInitialPoolSize;
    private static final String metacatMaxPoolSize;

    private DataSourceFactory() {
    }

    public static BasicDataSource getMetacatDataSource() {
        if (metacatDataSource == null) {
            DataSourceFactory.initMetacatDataSource();
        }
        return metacatDataSource;
    }

    public static BasicDataSource getPostgresDataSource() {
        if (postgresDataSource == null) {
            DataSourceFactory.initPostgresDataSource();
        }
        return postgresDataSource;
    }

    private static void initMetacatDataSource() {
        if (log.isDebugEnabled()) {
            log.debug("Metacat Data Source JDBC settings:");
            log.debug("\tmetacat.datasource.url:" + metacatUrl);
            log.debug("\tmetacat.datasource.driverClass:" + metacatDriverClass);
            log.debug("\tdatabase.user:" + metacatUsername);
            log.debug("\tdatabase.password:" + metacatPassword);
            log.debug("\tmetacat.datasource.initialSize:" + metacatInitialPoolSize);
            log.debug("\tmetacat.datasource.maxSize:" + metacatMaxPoolSize);
        }
        metacatDataSource = new BasicDataSource();
        metacatDataSource.setUrl(metacatUrl);
        metacatDataSource.setDriverClassName(metacatDriverClass);
        metacatDataSource.setUsername(metacatUsername);
        metacatDataSource.setPassword(metacatPassword);
        metacatDataSource.setInitialSize(Integer.valueOf(metacatInitialPoolSize));
        metacatDataSource.setMaxActive(Integer.valueOf(metacatMaxPoolSize));
    }

    private static void initPostgresDataSource() {
        postgresDataSource = new BasicDataSource();
        postgresDataSource.setUrl(url);
        postgresDataSource.setDriverClassName(driverClass);
        postgresDataSource.setUsername(username);
        postgresDataSource.setPassword(password);
        postgresDataSource.setInitialSize(Integer.valueOf(initialPoolSize));
        postgresDataSource.setMaxActive(Integer.valueOf(maxPoolSize));
    }

    static {
        url = Settings.getConfiguration().getString(urlProp);
        driverClass = Settings.getConfiguration().getString(driverClassProp);
        username = Settings.getConfiguration().getString(usernameProp);
        password = Settings.getConfiguration().getString(passwordProperty);
        initialPoolSize = Settings.getConfiguration().getString(initialPoolSizeProperty);
        maxPoolSize = Settings.getConfiguration().getString(maxPoolSizeProperty);
        metacatUrl = Settings.getConfiguration().getString(metacatUrlProperty);
        metacatDriverClass = Settings.getConfiguration().getString(metacatDriverClassProperty);
        metacatUsername = Settings.getConfiguration().getString(metacatUsernameProperty);
        metacatPassword = Settings.getConfiguration().getString(metacatPasswordProperty);
        metacatInitialPoolSize = Settings.getConfiguration().getString(metacatInitialPoolSizeProperty);
        metacatMaxPoolSize = Settings.getConfiguration().getString(metacatMaxPoolSizeProperty);
    }
}

