/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.hazelcast.membership;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MembershipEvent;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.membership.BaseHazelcastMembershipListener;
import org.dataone.cn.hazelcast.membership.ClusterPartitionMonitor;

public class ClusterPartitionMembershipListener
extends BaseHazelcastMembershipListener {
    private static Logger log = Logger.getLogger(ClusterPartitionMembershipListener.class.getName());
    public static final String STORAGE = "storage";
    public static final String PROCESSING = "processing";
    public static final String SESSION = "session";
    private String cluster = "";

    public ClusterPartitionMembershipListener(HazelcastInstance instance, String configLocation, String clusterName) {
        super(instance, configLocation);
        this.cluster = clusterName;
    }

    public ClusterPartitionMembershipListener(HazelcastInstance instance, String clusterName) {
        super(instance);
        this.cluster = clusterName;
    }

    @Override
    public void handleMemberAddedEvent(MembershipEvent membershipEvent) {
        this.setPartitionStatus();
    }

    @Override
    public void handleMemberRemovedEvent(MembershipEvent membershipEvent) {
        this.setPartitionStatus();
    }

    private void setPartitionStatus() {
        if (this.clusterIsPartitioned()) {
            if (STORAGE.equals(this.cluster)) {
                ClusterPartitionMonitor.setStoragePartition(true);
            } else if (PROCESSING.equals(this.cluster)) {
                ClusterPartitionMonitor.setProcessingPartition(true);
            } else if (SESSION.equals(this.cluster)) {
                ClusterPartitionMonitor.setSessionPartition(true);
            }
        } else if (STORAGE.equals(this.cluster)) {
            ClusterPartitionMonitor.setStoragePartition(false);
        } else if (PROCESSING.equals(this.cluster)) {
            ClusterPartitionMonitor.setProcessingPartition(false);
        } else if (SESSION.equals(this.cluster)) {
            ClusterPartitionMonitor.setSessionPartition(false);
        }
    }
}

