/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.monitor;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.hazelcast.membership.BaseHazelcastMembershipListener;
import org.dataone.cn.monitor.IMonitor;
import org.dataone.cn.monitor.MonitorMembershipListener;
import org.dataone.cn.monitor.NagiosHeartbeatMembershipReporter;
import org.dataone.configuration.Settings;

public class HazelcastClusterMembershipMonitor
implements IMonitor {
    private static Logger log = Logger.getLogger(HazelcastClusterMembershipMonitor.class.getName());
    private static final String IPLIST_PROPERTY = "dataone.hazelcast.iplist";
    private static final String MONITOR_STORAGE_PROPERTY = "dataone.hazelcast.monitor.storageCluster";
    private static final String MONITOR_PROCESSING_PROPERTY = "dataone.hazelcast.monitor.processingCluster";
    private static final String MONITOR_SESSION_PROPERTY = "dataone.hazelcast.monitor.sessionCluster";
    private static final String NAGIOS_STORAGE_FILE_PROPERTY = "dataone.hazelcast.monitor.nagios.output.storage";
    private static final String NAGIOS_PROCESSING_FILE_PROPERTY = "dataone.hazelcast.monitor.nagios.output.processing";
    private static final String NAGIOS_SESSION_FILE_PROPERTY = "dataone.hazelcast.monitor.nagios.output.session";
    private BaseHazelcastMembershipListener storageMembershipListener = null;
    private BaseHazelcastMembershipListener processingMembershipListener = null;
    private BaseHazelcastMembershipListener sessionMembershipListener = null;
    private NagiosHeartbeatMembershipReporter storageHeartbeat = null;
    private NagiosHeartbeatMembershipReporter processingHeartbeat = null;
    private NagiosHeartbeatMembershipReporter sessionHeartbeat = null;
    private ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor();

    @Override
    public void start() {
        log.debug("starting hazelcast cluster monitor");
        this.startMembershipListeners();
        log.debug("hazelcast cluster monitor started.");
        log.debug("starting nagios hazelcast cluster heartbeat.");
        this.startNagiosHeartbeat();
        log.debug("nagios hazelcast cluster heartbeat started.");
    }

    @Override
    public void stop() {
        log.debug("stopping hazelcast cluster monitor.");
        this.stopMembershipListeners();
        log.debug("hazelcast cluster monitor stopped.");
        log.debug("stopping nagios hazelcast cluster heartbeat.");
        this.stopNagiosHeartbeat();
        log.debug("nagios hazelcast cluster heartbeat stopped.");
    }

    private void startMembershipListeners() {
        if (Settings.getConfiguration().getBoolean(MONITOR_STORAGE_PROPERTY, true) && HazelcastClientFactory.getStorageClient() != null) {
            this.storageMembershipListener = new MonitorMembershipListener(HazelcastClientFactory.getStorageClient(), "hzStorage");
            this.storageMembershipListener.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.storageMembershipListener.startListener();
        }
        if (Settings.getConfiguration().getBoolean(MONITOR_PROCESSING_PROPERTY, true) && HazelcastClientFactory.getProcessingClient() != null) {
            this.processingMembershipListener = new MonitorMembershipListener(HazelcastClientFactory.getProcessingClient(), "hzProcess");
            this.processingMembershipListener.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.processingMembershipListener.startListener();
        }
        if (Settings.getConfiguration().getBoolean(MONITOR_SESSION_PROPERTY, true) && HazelcastClientFactory.getSessionClient() != null) {
            this.sessionMembershipListener = new MonitorMembershipListener(HazelcastClientFactory.getSessionClient(), "hzSession");
            this.sessionMembershipListener.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.sessionMembershipListener.startListener();
        }
    }

    private void stopMembershipListeners() {
        this.storageMembershipListener.stopListener();
        this.processingMembershipListener.stopListener();
        this.sessionMembershipListener.stopListener();
    }

    private void startNagiosHeartbeat() {
        if (Settings.getConfiguration().getBoolean(MONITOR_STORAGE_PROPERTY, true) && HazelcastClientFactory.getStorageClient() != null) {
            this.storageHeartbeat = new NagiosHeartbeatMembershipReporter(HazelcastClientFactory.getStorageClient(), "hzStorage", Settings.getConfiguration().getString(NAGIOS_STORAGE_FILE_PROPERTY));
            this.storageHeartbeat.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.scheduledExecutor.scheduleAtFixedRate(this.storageHeartbeat, 0L, 60L, TimeUnit.SECONDS);
        }
        if (Settings.getConfiguration().getBoolean(MONITOR_PROCESSING_PROPERTY, true) && HazelcastClientFactory.getProcessingClient() != null) {
            this.processingHeartbeat = new NagiosHeartbeatMembershipReporter(HazelcastClientFactory.getProcessingClient(), "hzProcessing", Settings.getConfiguration().getString(NAGIOS_PROCESSING_FILE_PROPERTY));
            this.processingHeartbeat.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.scheduledExecutor.scheduleAtFixedRate(this.processingHeartbeat, 0L, 60L, TimeUnit.SECONDS);
        }
        if (Settings.getConfiguration().getBoolean(MONITOR_SESSION_PROPERTY, true) && HazelcastClientFactory.getSessionClient() != null) {
            this.sessionHeartbeat = new NagiosHeartbeatMembershipReporter(HazelcastClientFactory.getSessionClient(), "hzSession", Settings.getConfiguration().getString(NAGIOS_SESSION_FILE_PROPERTY));
            this.sessionHeartbeat.setExpectedIPList(Settings.getConfiguration().getString(IPLIST_PROPERTY));
            this.scheduledExecutor.scheduleAtFixedRate(this.sessionHeartbeat, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    private void stopNagiosHeartbeat() {
        this.scheduledExecutor.shutdownNow();
    }
}

