/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.monitor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class NagiosHeartbeatMembershipReporter
implements Runnable {
    private static Logger log = Logger.getLogger(NagiosHeartbeatMembershipReporter.class.getName());
    private static final int OK_CODE = 0;
    private static final int WARNING_CODE = 1;
    private static final int ERROR_CODE = 2;
    private static final int UKNOWN_CODE = 3;
    protected List<String> configAddresses = new ArrayList<String>();
    private String outputFilePath = "";
    private String clusterName = "";
    private HazelcastInstance hzInstance;

    public NagiosHeartbeatMembershipReporter(HazelcastInstance hzInstance, String clusterName, String outputFilePath) {
        this.clusterName = clusterName;
        this.hzInstance = hzInstance;
        this.outputFilePath = outputFilePath;
    }

    @Override
    public void run() {
        log.debug("Running nagios heartbeat: " + this.hzInstance.getName());
        this.reportMembership();
    }

    private void reportMembership() {
        int statusCode = 0;
        String info = this.clusterName + " cluster has: " + this.hzInstance.getCluster().getMembers().size() + " members.";
        String stats = "membership=" + this.hzInstance.getCluster().getMembers().size();
        Iterator<String> i$ = this.configAddresses.iterator();
        while (i$.hasNext()) {
            String address;
            String expectedIP = address = i$.next();
            boolean found = false;
            for (Member member : this.hzInstance.getCluster().getMembers()) {
                String memberIP = member.getInetSocketAddress().getAddress().getHostAddress();
                if (!expectedIP.equals(memberIP)) continue;
                found = true;
                break;
            }
            if (found) {
                info = info + " Address: " + expectedIP + " is present in cluster.";
                stats = stats + "|" + expectedIP + "=1";
                continue;
            }
            info = info + " Address: " + expectedIP + " is NOT present in cluster.";
            statusCode = 2;
            stats = stats + "|" + expectedIP + "=0";
        }
        String statusReport = statusCode + " HZ_Membership_" + this.clusterName + " " + stats + " " + info;
        try {
            FileWriter writer = null;
            writer = new FileWriter(this.outputFilePath);
            writer.write(statusReport + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("unable to write nagios output", e);
        }
    }

    public void setExpectedIPList(String ipString) {
        this.configAddresses.clear();
        if (ipString != null) {
            String[] ips = StringUtils.split(ipString, ",");
            for (int i = 0; i < ips.length; ++i) {
                String ip = ips[i].trim();
                this.configAddresses.add(ip);
            }
        }
    }
}

