/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.monitor;

import com.hazelcast.core.Cluster;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.timgroup.statsd.StatsDClient;
import com.timgroup.statsd.StatsDClientException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.configuration.Settings;

public class StatsdMembershipReporter {
    private static Logger log = Logger.getLogger(StatsdMembershipReporter.class.getName());
    private final String ENVIRONMENT;
    private final String STATSD_HOST;
    private int STATSD_PORT;
    private String DEFAULT_HOST;
    private StatsDClient membershipStats;
    private StatsDClient memberStats;
    private String membershipStatsDisplay;
    private String memberStatsDisplay;

    public StatsdMembershipReporter(String clusterName) {
        block4: {
            this.ENVIRONMENT = StringUtils.lowerCase(Settings.getConfiguration().getString("cn.context.label", "dev"));
            this.STATSD_HOST = Settings.getConfiguration().getString("dataone.cn.monitor.statsd.host", "129.237.201.114");
            this.STATSD_PORT = Settings.getConfiguration().getInt("dataone.cn.monitor.statsd.port", 8125);
            this.DEFAULT_HOST = "127.0.0.1";
            this.membershipStats = null;
            this.memberStats = null;
            this.membershipStatsDisplay = null;
            this.memberStatsDisplay = null;
            try {
                this.DEFAULT_HOST = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                log.error("Unable to obtain local host address.", e);
                e.printStackTrace();
            }
            try {
                String displayHostIP = this.formatAddressForDisplay(this.DEFAULT_HOST);
                this.membershipStatsDisplay = "environment." + this.ENVIRONMENT + ".from_" + displayHostIP + "." + clusterName + ".members.";
                this.membershipStats = new StatsDClient(this.membershipStatsDisplay, this.STATSD_HOST, this.STATSD_PORT);
                this.memberStatsDisplay = "environment." + this.ENVIRONMENT + ".from_" + displayHostIP + "." + clusterName + ".member.";
                this.memberStats = new StatsDClient(this.memberStatsDisplay, this.STATSD_HOST, this.STATSD_PORT);
            }
            catch (StatsDClientException sce) {
                log.warn("Trouble with the StatsDClient: " + sce.getMessage());
                if (!log.isDebugEnabled()) break block4;
                sce.printStackTrace();
            }
        }
    }

    public void initialReport(HazelcastInstance hzInstance, List<String> configAddresses) {
        String displayHostIP = this.formatAddressForDisplay(this.DEFAULT_HOST);
        log.debug(this.memberStatsDisplay + " member size: " + hzInstance.getCluster().getMembers().size());
        this.membershipStats.gauge(displayHostIP, hzInstance.getCluster().getMembers().size());
        Iterator<String> i$ = configAddresses.iterator();
        while (i$.hasNext()) {
            String address;
            String expectedIP = address = i$.next();
            boolean found = false;
            for (Member member : hzInstance.getCluster().getMembers()) {
                String memberIP = member.getInetSocketAddress().getAddress().getHostAddress();
                if (!expectedIP.equals(memberIP)) continue;
                found = true;
                break;
            }
            if (found) {
                log.debug(this.membershipStatsDisplay + " membership report is 1 for IP: " + expectedIP);
                this.memberStats.gauge(this.formatAddressForDisplay(expectedIP), 1);
                continue;
            }
            log.debug(this.membershipStatsDisplay + " membership report is 0 for IP: " + expectedIP);
            this.memberStats.gauge(this.formatAddressForDisplay(expectedIP), 0);
        }
    }

    public void reportMembershipEvent(MembershipEvent membershipEvent) {
        String displayHostIP = this.formatAddressForDisplay(this.DEFAULT_HOST);
        Cluster cluster = membershipEvent.getCluster();
        this.membershipStats.gauge(displayHostIP, cluster.getMembers().size());
        String displayMemberIP = membershipEvent.getMember().getInetSocketAddress().getAddress().getHostAddress();
        displayMemberIP = this.formatAddressForDisplay(displayMemberIP);
        int reportValue = 0;
        if (1 == membershipEvent.getEventType()) {
            reportValue = 1;
        }
        this.memberStats.gauge(displayMemberIP, reportValue);
    }

    private String formatAddressForDisplay(String ipAddress) {
        return ipAddress.replace(".", "_");
    }
}

