/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.mimemultipart;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.dataone.service.util.TypeMarshaller;
import org.jibx.runtime.JiBXException;

public class SimpleMultipartEntity
extends MultipartEntity {
    private static Log log = LogFactory.getLog(SimpleMultipartEntity.class);
    private Vector<File> tempFiles = new Vector();
    private String mmpDescription = "";

    public String getDescription() {
        return this.mmpDescription;
    }

    public void addFilePart(String name, File file) {
        FileBody fileBody = new FileBody(file);
        this.addPart(name, fileBody);
        this.mmpDescription = this.mmpDescription + String.format("FilePart:%s = %s (%d bytes); ", name, file.getAbsoluteFile(), file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilePart(String name, InputStream is) throws IOException {
        File outputFile = this.generateTempFile();
        OutputStream os = null;
        int total = 0;
        try {
            os = new FileOutputStream(outputFile);
            byte[] bytebuffer = new byte[4096];
            int num = is.read(bytebuffer);
            while (num != -1) {
                ((FileOutputStream)os).write(bytebuffer, 0, num);
                total += num;
                num = is.read(bytebuffer);
            }
        }
        finally {
            os.flush();
            ((FileOutputStream)os).close();
            log.debug("     bytes written: " + total);
        }
        FileBody fBody = new FileBody(outputFile);
        this.addPart(name, fBody);
        this.mmpDescription = this.mmpDescription + String.format("FilePart:%s = %s (%d bytes); ", name, outputFile.getAbsoluteFile(), outputFile.length());
    }

    public void addFilePart(String name, Object serializableD1Object) throws IOException, JiBXException {
        File outputFile = this.generateTempFile();
        FileOutputStream fileOut = new FileOutputStream(outputFile);
        TypeMarshaller.marshalTypeToOutputStream(serializableD1Object, fileOut);
        fileOut.flush();
        fileOut.close();
        FileBody fBody = new FileBody(outputFile);
        this.addPart(name, fBody);
        this.mmpDescription = this.mmpDescription + String.format("FilePart:%s = %s (%d bytes); ", name, outputFile.getAbsoluteFile(), outputFile.length());
    }

    @Deprecated
    public void addFilePart(String name, Object serializableD1Object, Class type) throws IOException, JiBXException {
        this.addFilePart(name, serializableD1Object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilePart(String name, String value) throws IOException {
        File outputFile = this.generateTempFile();
        OutputStreamWriter osw = null;
        try {
            FileOutputStream os = new FileOutputStream(outputFile);
            osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
            osw.write(value);
        }
        finally {
            osw.flush();
            osw.close();
        }
        FileBody fileBody = new FileBody(outputFile);
        this.addPart(name, fileBody);
        this.mmpDescription = this.mmpDescription + String.format("FilePart:%s = %s (%d bytes); ", name, outputFile.getAbsoluteFile(), outputFile.length());
    }

    public void addParamPart(String name, String value) {
        try {
            this.addPart(name, new StringBody(value, Charset.forName("UTF-8")));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("UTF-8 is not supported in SimpleMultipartEntity.addParamPart: " + uee.getMessage());
        }
        this.mmpDescription = this.mmpDescription + String.format("ParamPart:%s = %s; ", name, value);
    }

    protected String getLastTempfile() {
        return this.tempFiles.lastElement().getAbsolutePath();
    }

    private File generateTempFile() throws IOException {
        File outputFile = File.createTempFile("mmp.output.", null);
        this.tempFiles.add(outputFile);
        log.info("temp outputFile is: " + outputFile.getAbsolutePath());
        return outputFile;
    }

    public boolean cleanupTempFiles() {
        boolean areAllFilesGone = true;
        for (File file : this.tempFiles) {
            if (!file.exists() || file.delete()) continue;
            areAllFilesGone = false;
            log.warn("failed to delete temp file: " + file.getAbsolutePath());
        }
        return areAllFilesGone;
    }
}

