/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.ValueElement;
import org.jibx.binding.util.ObjectStack;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;

public class BindingGenerator {
    private static String CURRENT_VERSION = "0.4";
    private static HashSet s_objectPrimitiveSet = new HashSet();
    private boolean m_verbose;
    private boolean m_mixedCase;
    private String m_namespaceUri;
    private HashMap m_mappedNames = new HashMap();
    private HashMap m_beanNames;
    private HashMap m_enumerationNames;
    private ObjectStack m_structureStack = new ObjectStack();
    private HashSet m_structureNames = new HashSet();
    private HashSet m_ignoreNames = new HashSet();
    static /* synthetic */ Class class$org$jibx$binding$model$BindingElement;

    public BindingGenerator() {
    }

    public BindingGenerator(boolean verbose, boolean mixed, String uri) {
        this();
        this.m_verbose = verbose;
        this.m_mixedCase = mixed;
        this.m_namespaceUri = uri;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setCamelCase(boolean camel) {
        this.m_mixedCase = camel;
    }

    private void nestingIndent(PrintStream pw) {
        for (int i = 0; i < this.m_structureStack.size(); ++i) {
            pw.print(' ');
        }
    }

    private String convertName(String base) {
        StringBuffer name = new StringBuffer();
        name.append(Character.toLowerCase(base.charAt(0)));
        if (this.m_mixedCase) {
            name.append(base.substring(1));
        } else {
            boolean ignore = true;
            for (int i = 1; i < base.length(); ++i) {
                char chr = base.charAt(i);
                if (Character.isUpperCase(chr)) {
                    chr = Character.toLowerCase(chr);
                    if (ignore) {
                        int next = i + 1;
                        boolean bl = ignore = next >= base.length() || Character.isUpperCase(base.charAt(next));
                    }
                    if (ignore) {
                        name.append(chr);
                        continue;
                    }
                    name.append('-');
                    name.append(chr);
                    ignore = true;
                    continue;
                }
                name.append(chr);
                ignore = false;
            }
        }
        return name.toString();
    }

    public String elementName(String cname) {
        int split = cname.lastIndexOf(46);
        if (split >= 0) {
            cname = cname.substring(split + 1);
        }
        while ((split = cname.indexOf(36)) >= 0) {
            cname = cname.substring(0, split) + cname.substring(split + 1);
        }
        return this.convertName(cname);
    }

    private String valueName(String fname) {
        String base = fname;
        if (base.startsWith("m_")) {
            base = base.substring(2);
        } else if (base.startsWith("_")) {
            base = base.substring(1);
        } else if (base.startsWith("f") && base.length() > 1 && Character.isUpperCase(base.charAt(1))) {
            base = base.substring(1);
        }
        return this.convertName(base);
    }

    private void defineFields(ClassFile cf, ContainerElementBase contain) throws JiBXException {
        JavaClass clas = cf.getRawClass();
        Field[] fields = clas.getFields();
        for (int i = 0; i < fields.length; ++i) {
            StructureElementBase element;
            ClassFile pcf;
            ClassItem init;
            Field field = fields[i];
            if (field.isFinal() || field.isStatic() || field.isTransient()) continue;
            boolean simple = false;
            boolean object = true;
            boolean attribute = true;
            String fname = field.getName();
            String tname = field.getType().toString();
            if (ClassItem.isPrimitive(tname)) {
                simple = true;
                object = false;
            } else if (s_objectPrimitiveSet.contains(tname)) {
                simple = true;
            } else if (tname.equals("byte[]")) {
                simple = true;
                attribute = false;
            } else if (tname.startsWith("java.") && (init = (pcf = ClassCache.requireClassFile(tname)).getInitializerMethod("(Ljava/lang/String;)")) != null) {
                simple = pcf.getMethod("toString", "()Ljava/lang/String;") != null;
                attribute = false;
            }
            if (this.m_enumerationNames.get(tname) != null) {
                int split;
                String mname = (String)this.m_enumerationNames.get(tname);
                ClassFile dcf = ClassCache.requireClassFile(mname.substring(0, split = mname.lastIndexOf(46)));
                ClassItem dser = dcf.getStaticMethod(mname.substring(split + 1), "(Ljava/lang/String;)");
                if (dser == null || !tname.equals(dser.getTypeName())) {
                    throw new JiBXException("Deserializer method not found for enumeration class " + tname);
                }
                ValueElement value = new ValueElement();
                value.setFieldName(fname);
                value.setName(this.valueName(fname));
                value.setUsageName("optional");
                value.setStyleName("element");
                value.setDeserializerName(mname);
                contain.addChild(value);
                continue;
            }
            if (this.m_mappedNames.get(tname) != null) {
                StructureElement structure = new StructureElement();
                structure.setUsageName("optional");
                structure.setFieldName(fname);
                if (((String)this.m_mappedNames.get(tname)).length() == 0) {
                    structure.setName(this.elementName(tname));
                }
                contain.addChild(structure);
                if (!this.m_verbose) continue;
                this.nestingIndent(System.out);
                System.out.println("referenced existing binding for " + tname);
                continue;
            }
            if (simple) {
                ValueElement value = new ValueElement();
                value.setFieldName(fname);
                value.setName(this.valueName(fname));
                if (object) {
                    value.setUsageName("optional");
                }
                if (!attribute) {
                    value.setStyleName("element");
                }
                contain.addChild(value);
                continue;
            }
            if (tname.endsWith("[]")) {
                String bname = tname.substring(0, tname.length() - 2);
                if (this.m_mappedNames.get(bname) == null) {
                    throw new JiBXException("Base element type " + bname + " must be mapped");
                }
                CollectionElement collection = new CollectionElement();
                collection.setUsageName("optional");
                collection.setFieldName(fname);
                contain.addChild(collection);
                continue;
            }
            pcf = ClassCache.requireClassFile(tname);
            if (pcf.isImplements("Ljava/util/List;")) {
                System.err.println("Warning: field " + fname + " requires mapped implementation of item classes");
                element = new CollectionElement();
                element.setComment(" add details of collection items to complete binding definition ");
                element.setFieldName(fname);
                if ("java.util.List".equals(tname)) {
                    element.setFactoryName("org.jibx.runtime.Utility.arrayListFactory");
                }
            } else if (pcf.isInterface() || this.m_ignoreNames.contains(tname)) {
                this.nestingIndent(System.err);
                System.err.println("Warning: reference to interface or abstract class " + tname + " requires mapped implementation");
                element = new StructureElement();
                element.setFieldName(fname);
            } else {
                element = this.createStructure(pcf, fname);
            }
            element.setUsageName("optional");
            contain.addChild(element);
        }
    }

    private void defineProperties(ClassFile cf, ArrayList props, boolean internal, ContainerElementBase contain) throws JiBXException {
        for (int i = 0; i < props.size(); ++i) {
            StructureElementBase element;
            ClassFile pcf;
            String sig;
            String pname = (String)props.get(i);
            String base = Character.toUpperCase(pname.charAt(0)) + pname.substring(1);
            String gname = "get" + base;
            ClassItem gmeth = cf.getMethod(gname, "()");
            if (gmeth == null) {
                throw new JiBXException("No method " + gname + "() found for property " + base + " in class " + cf.getName());
            }
            String tname = gmeth.getTypeName();
            String sname = "set" + base;
            ClassItem smeth = cf.getMethod(sname, sig = "(" + gmeth.getSignature().substring(2) + ")V");
            if (smeth == null) {
                throw new JiBXException("No method " + sname + "(" + tname + ") found for property " + base + " in class " + cf.getName());
            }
            boolean simple = false;
            boolean object = true;
            boolean attribute = true;
            if (ClassItem.isPrimitive(tname)) {
                simple = true;
                object = false;
            } else if (s_objectPrimitiveSet.contains(tname)) {
                simple = true;
            } else if (tname.equals("byte[]")) {
                simple = true;
                attribute = false;
            } else if (tname.startsWith("java.") && (pcf = ClassCache.requireClassFile(tname)).getInitializerMethod("()") != null) {
                simple = pcf.getMethod("toString", "()Ljava/lang/String;") != null;
                attribute = false;
            }
            if (simple) {
                ValueElement value = new ValueElement();
                value.setGetName(gname);
                value.setSetName(sname);
                value.setName(this.valueName(pname));
                if (object) {
                    value.setUsageName("optional");
                }
                if (!attribute) {
                    value.setStyleName("element");
                }
                contain.addChild(value);
                continue;
            }
            if (this.m_enumerationNames.get(tname) != null) {
                int split;
                String mname = (String)this.m_enumerationNames.get(tname);
                ClassFile dcf = ClassCache.requireClassFile(mname.substring(0, split = mname.lastIndexOf(46)));
                ClassItem dser = dcf.getStaticMethod(mname.substring(split + 1), "(Ljava/lang/String;)");
                if (dser == null || !tname.equals(dser.getTypeName())) {
                    throw new JiBXException("Deserializer method not found for enumeration class " + tname);
                }
                ValueElement value = new ValueElement();
                value.setGetName(gname);
                value.setSetName(sname);
                value.setName(this.valueName(pname));
                value.setUsageName("optional");
                value.setStyleName("element");
                value.setDeserializerName(mname);
                contain.addChild(value);
                continue;
            }
            if (this.m_mappedNames.get(tname) != null) {
                StructureElement structure = new StructureElement();
                structure.setUsageName("optional");
                structure.setGetName(gname);
                structure.setSetName(sname);
                if (((String)this.m_mappedNames.get(tname)).length() == 0) {
                    structure.setName(this.elementName(tname));
                }
                contain.addChild(structure);
                if (!this.m_verbose) continue;
                this.nestingIndent(System.out);
                System.out.println("referenced existing binding for " + tname);
                continue;
            }
            if (tname.endsWith("[]")) {
                String bname = tname.substring(0, tname.length() - 2);
                if (this.m_mappedNames.get(bname) == null) {
                    throw new JiBXException("Base element type " + bname + " must be mapped");
                }
                StructureElement structure = new StructureElement();
                structure.setUsageName("optional");
                structure.setGetName(gname);
                structure.setSetName(sname);
                structure.setMarshallerName("org.jibx.extras.TypedArrayMapper");
                structure.setUnmarshallerName("org.jibx.extras.TypedArrayMapper");
                contain.addChild(structure);
                continue;
            }
            pcf = ClassCache.requireClassFile(tname);
            if (pcf.isImplements("Ljava/util/List;")) {
                System.err.println("Warning: property " + pname + " requires mapped implementation of item " + "classes");
                element = new CollectionElement();
                element.setComment(" add details of collection items to complete binding definition ");
                element.setGetName(gname);
                element.setSetName(sname);
                if ("java.util.List".equals(tname)) {
                    element.setFactoryName("org.jibx.runtime.Utility.arrayListFactory");
                }
            } else if (pcf.isInterface() || this.m_ignoreNames.contains(tname)) {
                this.nestingIndent(System.err);
                System.err.println("Warning: reference to interface or abstract class " + tname + " requires mapped implementation");
                element = new StructureElement();
                element.setGetName(gname);
                element.setSetName(sname);
            } else {
                element = this.createStructure(pcf, pname);
            }
            element.setUsageName("optional");
            contain.addChild(element);
        }
    }

    private void defineStructure(ClassFile cf, ContainerElementBase contain) throws JiBXException {
        Object props = this.m_beanNames.get(cf.getName());
        if (props == null) {
            this.defineFields(cf, contain);
        } else {
            this.defineProperties(cf, (ArrayList)props, true, contain);
        }
        ClassFile sf = cf.getSuperFile();
        String sname = sf.getName();
        if (!"java.lang.Object".equals(sname) && !this.m_ignoreNames.contains(sname)) {
            if (this.m_mappedNames.get(sname) != null) {
                StructureElement structure = new StructureElement();
                structure.setMapAsName(sname);
                structure.setName(this.elementName(sname));
                contain.addChild(structure);
            } else if (this.m_beanNames.get(sname) != null) {
                this.defineProperties(sf, (ArrayList)this.m_beanNames.get(sname), false, contain);
            } else if (sf.getRawClass().getFields().length > 0) {
                this.nestingIndent(System.err);
                System.err.println("Warning: fields from base class " + sname + " of class " + cf.getName() + " not handled by generated " + "binding; use mapping or specify property list");
                contain.setComment(" missing information for base class " + sname + " ");
            }
        }
    }

    private StructureElement createStructure(ClassFile cf, String fname) throws JiBXException {
        JavaClass clas = cf.getRawClass();
        if (this.m_verbose) {
            this.nestingIndent(System.out);
            System.out.println("creating nested structure definition for " + clas.getClassName());
        }
        String cname = clas.getClassName();
        for (int i = 0; i < this.m_structureStack.size(); ++i) {
            if (!cname.equals(this.m_structureStack.peek(i))) continue;
            StringBuffer buff = new StringBuffer("Error: recursive use of ");
            buff.append(cname);
            buff.append(" requires <mapping>:\n ");
            while (i >= 0) {
                buff.append(this.m_structureStack.peek(i--));
                buff.append(" -> ");
            }
            buff.append(cname);
            throw new JiBXException(buff.toString());
        }
        if (cname.startsWith("java.")) {
            this.nestingIndent(System.err);
            System.err.println("Warning: trying to create structure for " + cname);
        } else if (this.m_structureNames.contains(cname)) {
            this.nestingIndent(System.err);
            System.err.println("Warning: repeated usage of class " + cname + "; consider adding to mapping list");
        } else {
            this.m_structureNames.add(cname);
        }
        this.m_structureStack.push(cname);
        StructureElement element = new StructureElement();
        element.setFieldName(fname);
        element.setName(this.valueName(fname));
        this.defineStructure(cf, element);
        if (element.children().isEmpty()) {
            throw new JiBXException("No content found for class " + cname);
        }
        this.m_structureStack.pop();
        if (this.m_verbose) {
            this.nestingIndent(System.out);
            System.out.println("completed nested structure definition for " + clas.getClassName());
        }
        return element;
    }

    private MappingElementBase createMapping(ClassFile cf, boolean abstr) throws JiBXException {
        JavaClass clas = cf.getRawClass();
        if (this.m_verbose) {
            System.out.println("\nBuilding mapping definition for " + clas.getClassName());
        }
        MappingElement element = new MappingElement();
        element.setAbstract(abstr || clas.isAbstract() || clas.isInterface());
        String name = clas.getClassName();
        element.setClassName(name);
        if (abstr) {
            element.setAbstract(true);
        } else {
            element.setName((String)this.m_mappedNames.get(name));
        }
        this.m_structureStack.push(name);
        this.defineStructure(cf, element);
        this.m_structureStack.pop();
        return element;
    }

    private static boolean isMappable(String cname) {
        if ("java.lang.String".equals(cname)) {
            return false;
        }
        if ("java.lang.Object".equals(cname)) {
            return false;
        }
        if (ClassItem.isPrimitive(cname)) {
            return false;
        }
        return !s_objectPrimitiveSet.contains(cname);
    }

    public static void findClassesUsed(String cname, ArrayList mnames, HashSet dataset, HashSet exceptset) throws JiBXException {
        ClassFile cf = ClassCache.getClassFile(cname);
        if (cf != null) {
            for (int i = 0; i < mnames.size(); ++i) {
                String mname = (String)mnames.get(i);
                ClassItem mitem = cf.getMethod(mname, "");
                if (mitem == null) {
                    System.err.println("Method " + mname + " not found in class " + cname);
                    continue;
                }
                if (dataset != null) {
                    String type = mitem.getTypeName();
                    if (type != null && BindingGenerator.isMappable(type)) {
                        dataset.add(type);
                    }
                    String[] args = mitem.getArgumentTypes();
                    for (int j = 0; j < args.length; ++j) {
                        type = args[j];
                        if (!BindingGenerator.isMappable(type)) continue;
                        dataset.add(args[j]);
                    }
                }
                if (exceptset == null) continue;
                String[] excepts = mitem.getExceptions();
                for (int j = 0; j < excepts.length; ++j) {
                    exceptset.add(excepts[j]);
                }
            }
        }
    }

    public BindingElement generate(ArrayList names, HashSet abstracts, HashMap customs, HashMap beans, HashMap enums, ArrayList ignores) throws JiBXException {
        MappingElementBase mapping;
        String cname;
        ClassFile cf;
        System.out.println("Running binding generator version " + CURRENT_VERSION);
        this.m_mappedNames.clear();
        for (int i = 0; i < names.size(); ++i) {
            boolean drop = false;
            String name = (String)names.get(i);
            cf = ClassCache.requireClassFile(name);
            if (cf.isImplements("Ljava/util/List;") || cf.isImplements("Ljava/util/Map;")) {
                System.err.println("Warning: referenced class " + name + " is a collection class that cannot be mapped " + "automatically; dropped from mapped list in binding");
                drop = true;
            } else if (cf.isInterface()) {
                System.err.println("Warning: interface " + name + " is being handled as abstract mapping");
                abstracts.add(name);
                drop = true;
            } else if (cf.isAbstract()) {
                System.err.println("Warning: mapping abstract class " + name + "; make sure actual subclasses are mapped as extending " + "this abstract mapping");
                abstracts.add(name);
                drop = true;
            }
            if (drop) {
                names.remove(i--);
                continue;
            }
            this.m_mappedNames.put(name, this.elementName(name));
        }
        Iterator<Object> iter = abstracts.iterator();
        while (iter.hasNext()) {
            this.m_mappedNames.put((String)iter.next(), "");
        }
        iter = customs.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.m_mappedNames.put(name, this.elementName(name));
        }
        this.m_ignoreNames.clear();
        this.m_ignoreNames.addAll(ignores);
        BindingElement binding = new BindingElement();
        binding.setStyleName("attribute");
        if (this.m_namespaceUri != null) {
            NamespaceElement namespace = new NamespaceElement();
            namespace.setComment(" namespace for all elements of binding ");
            namespace.setDefaultName("elements");
            namespace.setUri(this.m_namespaceUri);
            binding.addTopChild(namespace);
        }
        this.m_structureStack.clear();
        this.m_structureNames.clear();
        this.m_beanNames = beans;
        this.m_enumerationNames = enums;
        for (int i = 0; i < names.size(); ++i) {
            cname = (String)names.get(i);
            if (abstracts.contains(cname)) continue;
            cf = ClassCache.requireClassFile(cname);
            mapping = this.createMapping(cf, false);
            mapping.setComment(" generated mapping for class " + cname);
            binding.addTopChild(mapping);
        }
        Iterator<Object> iter2 = abstracts.iterator();
        while (iter2.hasNext()) {
            cname = (String)iter2.next();
            cf = ClassCache.requireClassFile(cname);
            mapping = this.createMapping(cf, true);
            mapping.setComment(" generate abstract mapping for class " + cname);
            binding.addTopChild(mapping);
        }
        iter2 = customs.keySet().iterator();
        while (iter2.hasNext()) {
            cname = (String)iter2.next();
            String mname = (String)customs.get(cname);
            mapping = new MappingElement();
            mapping.setComment(" specified mapping for class " + cname);
            mapping.setClassName(cname);
            mapping.setName((String)this.m_mappedNames.get(cname));
            mapping.setMarshallerName(mname);
            mapping.setUnmarshallerName(mname);
            binding.addTopChild(mapping);
        }
        if (this.m_verbose) {
            for (int i = 0; i < names.size(); ++i) {
                this.m_structureNames.add(names.get(i));
            }
            this.m_structureNames.addAll(customs.keySet());
            Object[] classes = this.m_structureNames.toArray(new String[this.m_structureNames.size()]);
            Arrays.sort(classes);
            System.out.println("\nClasses included in binding:");
            for (int i = 0; i < classes.length; ++i) {
                System.out.println(" " + (String)classes[i]);
            }
        }
        return binding;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                int i;
                ArrayList props;
                boolean mixed = false;
                boolean verbose = false;
                String uri = null;
                String fname = "binding.xml";
                ArrayList<String> paths = new ArrayList<String>();
                HashMap<String, String> enums = new HashMap<String, String>();
                HashSet<String> abstracts = new HashSet<String>();
                ArrayList<String> ignores = new ArrayList<String>();
                HashMap<String, String> customs = new HashMap<String, String>();
                HashMap<String, ArrayList> beans = new HashMap<String, ArrayList>();
                for (int offset = 0; offset < args.length; ++offset) {
                    String arg = args[offset];
                    if ("-v".equalsIgnoreCase(arg)) {
                        verbose = true;
                        continue;
                    }
                    if ("-b".equalsIgnoreCase(arg)) {
                        String plist = args[++offset];
                        int split = plist.indexOf("=");
                        String bname = plist.substring(0, split);
                        props = new ArrayList();
                        int base = ++split;
                        while ((split = plist.indexOf(44, split)) >= 0) {
                            props.add(plist.substring(base, split));
                            base = ++split;
                        }
                        props.add(plist.substring(base));
                        beans.put(bname, props);
                        continue;
                    }
                    if ("-c".equalsIgnoreCase(arg)) {
                        String custom;
                        int split;
                        if ((split = (custom = args[++offset]).indexOf(61)) > 0) {
                            customs.put(custom.substring(0, split), custom.substring(split + 1));
                            continue;
                        }
                        System.err.println("Unable to interpret customization " + custom);
                        continue;
                    }
                    if ("-e".equalsIgnoreCase(arg)) {
                        String mname;
                        String cname;
                        String enumf;
                        int split;
                        if ((split = (enumf = args[++offset]).indexOf(61)) > 0) {
                            cname = enumf.substring(0, split);
                            mname = enumf.substring(split + 1);
                            if (mname.indexOf(46) < 0) {
                                mname = cname + '.' + mname;
                            }
                        } else {
                            cname = enumf;
                            split = cname.lastIndexOf(46);
                            mname = split >= 0 ? cname + '.' + "get" + cname.substring(split + 1) : cname + '.' + "get" + cname;
                        }
                        enums.put(cname, mname);
                        continue;
                    }
                    if ("-i".equalsIgnoreCase(arg)) {
                        ignores.add(args[++offset]);
                        continue;
                    }
                    if ("-m".equalsIgnoreCase(arg)) {
                        mixed = true;
                        continue;
                    }
                    if ("-f".equalsIgnoreCase(arg)) {
                        fname = args[++offset];
                        continue;
                    }
                    if ("-n".equalsIgnoreCase(arg)) {
                        uri = args[++offset];
                        continue;
                    }
                    if ("-p".equalsIgnoreCase(arg)) {
                        paths.add(args[++offset]);
                        continue;
                    }
                    if (!"-a".equalsIgnoreCase(arg)) break;
                    abstracts.add(args[++offset]);
                }
                String[] vmpaths = Utility.getClassPaths();
                for (int i2 = 0; i2 < vmpaths.length; ++i2) {
                    paths.add(vmpaths[i2]);
                }
                ArrayList<String> names = new ArrayList<String>();
                for (i = offset; i < args.length; ++i) {
                    if (abstracts.contains(args[i])) continue;
                    names.add(args[i]);
                }
                if (verbose) {
                    String key;
                    System.out.println("Using paths:");
                    for (i = 0; i < paths.size(); ++i) {
                        System.out.println(" " + paths.get(i));
                    }
                    System.out.println("Using class names:");
                    for (i = 0; i < names.size(); ++i) {
                        System.out.println(" " + names.get(i));
                    }
                    if (abstracts.size() > 0) {
                        System.out.println("Using abstract class names:");
                        Iterator iter = abstracts.iterator();
                        while (iter.hasNext()) {
                            System.out.println(" " + iter.next());
                        }
                    }
                    if (customs.size() > 0) {
                        System.out.println("Using custom marshaller/unmarshallers:");
                        Iterator iter = customs.keySet().iterator();
                        while (iter.hasNext()) {
                            key = (String)iter.next();
                            System.out.println(" " + customs.get(key) + " for " + key);
                        }
                    }
                    if (beans.size() > 0) {
                        System.out.println("Using bean property lists:");
                        Iterator iter = beans.keySet().iterator();
                        while (iter.hasNext()) {
                            key = (String)iter.next();
                            System.out.print(" " + key + " with properties:");
                            props = (ArrayList)beans.get(key);
                            for (int i3 = 0; i3 < props.size(); ++i3) {
                                System.out.print(i3 > 0 ? ", " : " ");
                                System.out.print(props.get(i3));
                            }
                        }
                    }
                    if (enums.size() > 0) {
                        System.out.println("Using enumeration classes:");
                        Iterator iter = enums.keySet().iterator();
                        while (iter.hasNext()) {
                            key = (String)iter.next();
                            System.out.println(" " + key + " with deserializer " + enums.get(key));
                        }
                    }
                }
                String[] parray = paths.toArray(new String[paths.size()]);
                ClassCache.setPaths(parray);
                ClassFile.setPaths(parray);
                BindingGenerator generate = new BindingGenerator(verbose, mixed, uri);
                BindingElement binding = generate.generate(names, abstracts, customs, beans, enums, ignores);
                IBindingFactory bfact = BindingDirectory.getFactory("normal", class$org$jibx$binding$model$BindingElement == null ? (class$org$jibx$binding$model$BindingElement = BindingGenerator.class$("org.jibx.binding.model.BindingElement")) : class$org$jibx$binding$model$BindingElement);
                IMarshallingContext mctx = bfact.createMarshallingContext();
                mctx.setIndent(2);
                mctx.marshalDocument((Object)binding, "UTF-8", null, new FileOutputStream(fname));
            }
            catch (JiBXException ex) {
                ex.printStackTrace(System.out);
                System.exit(1);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace(System.out);
                System.exit(2);
            }
        } else {
            System.out.println("\nUsage: java org.jibx.binding.BindingGenerator [options] class1 class2 ...\nwhere options are:\n -a  abstract class\n -b  bean property class,\n -c  custom mapped class,\n -e  enumeration class,\n -f  binding file name,\n -i  ignore class,\n -m  use mixed case XML names (instead of hyphenated),\n -n  namespace URI,\n -p  class loading path component,\n -v  turns on verbose output\nThe class# files are different classes to be included in binding (references from\nthese classes will also be included).\n");
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        s_objectPrimitiveSet.add("java.lang.Boolean");
        s_objectPrimitiveSet.add("java.lang.Byte");
        s_objectPrimitiveSet.add("java.lang.Character");
        s_objectPrimitiveSet.add("java.lang.Double");
        s_objectPrimitiveSet.add("java.lang.Float");
        s_objectPrimitiveSet.add("java.lang.Integer");
        s_objectPrimitiveSet.add("java.lang.Long");
        s_objectPrimitiveSet.add("java.lang.Short");
        s_objectPrimitiveSet.add("java.math.BigDecimal");
        s_objectPrimitiveSet.add("java.math.BigInteger");
        s_objectPrimitiveSet.add("java.sql.Date");
        s_objectPrimitiveSet.add("java.sql.Time");
        s_objectPrimitiveSet.add("java.sql.Timestamp");
        s_objectPrimitiveSet.add("java.util.Date");
    }
}

