/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingOrganizer;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.runtime.Utility;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.LazyList;

public class BindingHolder {
    private final BindingOrganizer m_organizer;
    private final String m_namespace;
    private final boolean m_elementDefault;
    private final InsertionOrderedSet m_referencedNamespaces;
    private final InsertionOrderedSet m_usedNamespaces;
    private String m_prefix;
    private BindingElement m_binding;
    private boolean m_pullUpNamespaces;
    private boolean m_namespaceUsed;
    private boolean m_finished;
    private String m_fileName;
    private final LazyList m_mappings;

    public BindingHolder(String uri, boolean dflt, BindingOrganizer dir) {
        this.m_organizer = dir;
        this.m_namespace = uri;
        this.m_elementDefault = dflt;
        this.m_referencedNamespaces = new InsertionOrderedSet();
        this.m_usedNamespaces = new InsertionOrderedSet();
        this.m_binding = new BindingElement();
        this.m_mappings = new LazyList();
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String getElementDefaultNamespace() {
        return this.m_elementDefault ? this.m_namespace : null;
    }

    public BindingElement getBinding() {
        return this.m_binding;
    }

    public void setBinding(BindingElement bind) {
        this.m_binding = bind;
    }

    public void addFormat(FormatElement format) {
        this.m_organizer.addFormat(format);
    }

    public void addNamespaceUsage(String uri) {
        if (Utility.safeEquals(uri, this.m_namespace)) {
            this.m_namespaceUsed = true;
        } else {
            this.m_organizer.addNamespaceUsage(this, uri);
            this.m_usedNamespaces.add(uri);
        }
    }

    public void addTypeNameReference(String uri, Object obj) {
        this.m_organizer.addTypeNameReference(this, uri, obj);
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify binding after finalized");
        }
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public void setFileName(String name) {
        this.m_fileName = name;
    }

    public void addMapping(MappingElementBase mapping) {
        this.checkModifiable();
        this.m_mappings.add(mapping);
    }

    public int getMappingCount() {
        return this.m_mappings.size();
    }

    public Iterator iterateMappings() {
        return this.m_mappings.iterator();
    }

    public BindingHolder getRequiredBinding(Object obj) {
        return this.m_organizer.getRequiredBinding(obj);
    }

    Set getReferencedNamespaces() {
        return this.m_referencedNamespaces;
    }

    Set getUsedNamespaces() {
        return this.m_usedNamespaces;
    }

    void forcePullUpNamespaces() {
        this.m_pullUpNamespaces = true;
    }

    boolean isPullUpNamespaces() {
        return this.m_pullUpNamespaces;
    }

    boolean isNamespaceElementDefault() {
        return this.m_elementDefault;
    }

    boolean isBindingNamespaceUsed() {
        return this.m_namespaceUsed;
    }

    void finish(Collection formats, Collection includes, Set outernss, Map nsdfltpref, Map nsfrcdpref) {
        String prefix;
        this.checkModifiable();
        ArrayList topchilds = this.m_binding.topChildren();
        Iterator iter = this.m_referencedNamespaces.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            if (uri == null) continue;
            prefix = (String)nsfrcdpref.get(uri);
            if (prefix == null || prefix.length() == 0) {
                throw new IllegalStateException("Internal error - no prefix for declaration of namespace " + uri);
            }
            this.m_binding.addNamespaceDecl(prefix, uri);
        }
        boolean elemdflt = this.m_elementDefault;
        String dfltprfx = (String)nsdfltpref.get(this.m_namespace);
        String string = prefix = this.m_prefix == null ? dfltprfx : this.m_prefix;
        if ("".equals(prefix)) {
            elemdflt = true;
        }
        if (this.m_namespace != null && this.m_namespaceUsed && (!outernss.contains(this.m_namespace) || elemdflt && !"".equals(dfltprfx))) {
            NamespaceElement ns = new NamespaceElement();
            ns.setUri(this.m_namespace);
            if (elemdflt) {
                ns.setDefaultName("elements");
            }
            if (!"".equals(prefix)) {
                ns.setPrefix(prefix);
            }
            topchilds.add(ns);
        }
        Iterator iter2 = this.m_usedNamespaces.iterator();
        while (iter2.hasNext()) {
            String uri = (String)iter2.next();
            if (uri == null) continue;
            NamespaceElement ns = new NamespaceElement();
            ns.setUri(uri);
            ns.setPrefix((String)nsdfltpref.get(uri));
            topchilds.add(ns);
        }
        iter2 = formats.iterator();
        while (iter2.hasNext()) {
            FormatElement format = (FormatElement)iter2.next();
            if (format.getDefaultText() == null && format.getDeserializerName() == null && format.getEnumValueName() == null && format.getSerializerName() == null && format.getQName() == null) continue;
            topchilds.add(format);
        }
        topchilds.addAll(includes);
        topchilds.addAll(this.m_mappings);
        this.m_finished = true;
    }
}

