/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.custom.classes;

import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.custom.classes.ClassSourceWrapper;
import org.jibx.custom.classes.IClassSourceLocator;
import org.jibx.runtime.JiBXException;
import org.jibx.util.IClass;

public class ClassSourceLocator
implements IClassSourceLocator {
    private final String[] m_sourcePaths;
    private final JavaDocBuilder m_builder;
    private final Set m_lookupSet;

    public ClassSourceLocator(String[] paths) {
        this.m_sourcePaths = paths;
        this.m_builder = new JavaDocBuilder();
        this.m_lookupSet = new HashSet();
    }

    public boolean isLookupSupported() {
        return true;
    }

    public JavaClass getSourceInfo(String name) {
        int split = name.lastIndexOf(36);
        if (split >= 0) {
            JavaClass outer = this.getSourceInfo(name.substring(0, split));
            if (outer == null) {
                return null;
            }
            return outer.getNestedClassByName(name.substring(split + 1));
        }
        if (this.m_lookupSet.contains(name)) {
            return this.m_builder.getClassByName(name);
        }
        for (int i = 0; i < this.m_sourcePaths.length; ++i) {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_sourcePaths[i]);
            int length = buff.length();
            if (File.separatorChar != '/') {
                for (int j = 0; j < length; ++j) {
                    if (buff.charAt(j) != '/') continue;
                    buff.setCharAt(j, File.separatorChar);
                }
            }
            if (length > 0 || buff.charAt(length - 1) != File.separatorChar) {
                buff.append(File.separatorChar);
            }
            buff.append(name.replace('.', File.separatorChar));
            buff.append(".java");
            File file = new File(buff.toString());
            if (!file.exists()) continue;
            try {
                this.m_builder.addSource(file);
                this.m_lookupSet.add(name);
                return this.m_builder.getClassByName(name);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to access source file " + buff.toString() + ": " + e.getMessage());
            }
        }
        return null;
    }

    public IClass getClassInfo(String name) {
        try {
            ClassFile clas = ClassCache.getClassFile(name);
            if (clas == null) {
                return null;
            }
            return new ClassSourceWrapper(this, clas);
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Error loading class " + name + ": " + e.getMessage());
        }
    }

    public IClass getRequiredClassInfo(String name) {
        IClass iclas = this.getClassInfo(name);
        if (iclas == null) {
            throw new IllegalStateException("Internal error: class " + name + " cannot be found");
        }
        return iclas;
    }

    public Class loadClass(String name) {
        return ClassFile.loadClass(name);
    }
}

