/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.custom.classes;

import java.util.Collection;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.custom.classes.SharedNestingBase;
import org.jibx.runtime.EnumSet;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.util.NameUtilities;
import org.jibx.util.StringArray;

public class CustomBase {
    public static final int CAMEL_CASE_NAMES = 0;
    public static final int UPPER_CAMEL_CASE_NAMES = 1;
    public static final int HYPHENATED_NAMES = 2;
    public static final int DOTTED_NAMES = 3;
    public static final int UNDERSCORED_NAMES = 4;
    public static final EnumSet s_nameStyleEnum = new EnumSet(0, new String[]{"camel-case", "upper-camel-case", "hyphenated", "dotted", "underscored"});
    public static final int REQUIRE_NONE = 0;
    public static final int REQUIRE_PRIMITIVES = 1;
    public static final int REQUIRE_OBJECTS = 2;
    public static final int REQUIRE_ALL = 3;
    public static final EnumSet s_requireEnum = new EnumSet(0, new String[]{"none", "primitives", "objects", "all"});
    public static final int DERIVE_NONE = 0;
    public static final int DERIVE_BY_PACKAGE = 1;
    public static final int DERIVE_FIXED = 2;
    public static final EnumSet s_namespaceStyleEnum = new EnumSet(0, new String[]{"none", "package", "fixed"});
    private SharedNestingBase m_parent;

    public CustomBase(SharedNestingBase parent) {
        this.m_parent = parent;
    }

    public SharedNestingBase getParent() {
        return this.m_parent;
    }

    public GlobalCustom getGlobal() {
        SharedNestingBase parent = this.m_parent;
        while (!(parent instanceof GlobalCustom)) {
            parent = parent.getParent();
        }
        return (GlobalCustom)parent;
    }

    public static String convertName(String base, int code) {
        while (base.endsWith("[]")) {
            base = base.substring(0, base.length() - 2);
        }
        int length = base.length();
        int offset = -1;
        char chr = '\u0000';
        while (++offset < length && ((chr = base.charAt(offset)) == '_' || chr == '$')) {
        }
        if (offset >= length) {
            return "_";
        }
        StringBuffer buff = new StringBuffer();
        if (Character.isDigit(chr)) {
            buff.append('_');
        }
        boolean split = true;
        boolean caps = false;
        while (offset < length) {
            boolean nextlower;
            chr = base.charAt(offset++);
            boolean bl = nextlower = offset < length && !Character.isUpperCase(base.charAt(offset));
            if (chr == '_') {
                split = true;
                continue;
            }
            if (Character.isUpperCase(chr)) {
                if (!caps || nextlower) {
                    split = true;
                }
                if (code != 0 && code != 1) {
                    chr = Character.toLowerCase(chr);
                }
            }
            if (split) {
                caps = !nextlower;
                boolean tolower = false;
                char separator = '\u0000';
                switch (code) {
                    case 0: {
                        if (buff.length() != 0) {
                            chr = Character.toUpperCase(chr);
                            tolower = false;
                            break;
                        }
                        tolower = nextlower || offset == length;
                        break;
                    }
                    case 1: {
                        tolower = false;
                        chr = Character.toUpperCase(chr);
                        break;
                    }
                    case 2: {
                        separator = '-';
                        break;
                    }
                    case 3: {
                        separator = '.';
                        break;
                    }
                    case 4: {
                        separator = '_';
                    }
                }
                if (separator > '\u0000' && buff.length() > 0) {
                    buff.append(separator);
                }
                if (tolower) {
                    chr = Character.toLowerCase(chr);
                }
                split = false;
            }
            if (chr == '$') continue;
            buff.append(chr);
        }
        return buff.toString();
    }

    public static String deriveItemName(String cname, String type, int code) {
        String name;
        if (cname != null && !(name = NameUtilities.depluralize(cname)).equals(cname)) {
            return name;
        }
        if (type != null && !"java.lang.Object".equals(type)) {
            return CustomBase.convertName(type.substring(type.lastIndexOf(46) + 1), code);
        }
        return "item";
    }

    public static String packageOfType(String type) {
        int split = type.lastIndexOf(46);
        if (split >= 0) {
            return type.substring(0, split);
        }
        return "";
    }

    public static String packageToNamespace(String pkgpth) {
        int mark = pkgpth.indexOf(46);
        if (mark >= 0) {
            StringBuffer buff = new StringBuffer();
            buff.append("http://");
            String comp = pkgpth.substring(0, mark);
            int base = mark + 1;
            int delim = 46;
            if ("com".equals(comp) || "net".equals(comp) || "org".equals(comp)) {
                mark = pkgpth.indexOf(46, base);
                if (mark > 0) {
                    buff.append(pkgpth.substring(base, mark));
                } else {
                    buff.append(pkgpth.substring(base));
                }
                buff.append('.');
                base = mark + 1;
                delim = 47;
            }
            buff.append(comp);
            while (mark > 0) {
                buff.append((char)delim);
                base = mark + 1;
                mark = pkgpth.indexOf(46, base);
                if (mark > 0) {
                    buff.append(pkgpth.substring(base, mark));
                    continue;
                }
                buff.append(pkgpth.substring(base));
            }
            return buff.toString();
        }
        return null;
    }

    public static String deriveNamespace(String uri, String pkgpth, int style) {
        switch (style) {
            case 0: {
                return null;
            }
            case 2: {
                return uri;
            }
            case 1: {
                if (uri == null) {
                    return CustomBase.packageToNamespace(pkgpth);
                }
                if (pkgpth == null) {
                    return uri;
                }
                int start = pkgpth.lastIndexOf(46);
                String pack = start >= 0 ? pkgpth.substring(start + 1) : pkgpth;
                if (uri.endsWith("/")) {
                    return uri + pack;
                }
                return uri + '/' + pack;
            }
        }
        throw new IllegalStateException("Invalid style code");
    }

    protected void validateAttributes(IUnmarshallingContext ictx, StringArray attrs) {
        ValidationContext vctx = (ValidationContext)ictx.getUserContext();
        UnmarshallingContext uctx = (UnmarshallingContext)ictx;
        for (int i = 0; i < uctx.getAttributeCount(); ++i) {
            String name = uctx.getAttributeName(i);
            if (uctx.getAttributeNamespace(i).length() != 0 || attrs.indexOf(name) >= 0) continue;
            vctx.addWarning("Undefined attribute " + name, this);
        }
    }

    protected static Object getContainingObject(IUnmarshallingContext ictx) {
        Object parent = ictx.getStackTop();
        if (parent instanceof Collection) {
            parent = ictx.getStackObject(1);
        }
        return parent;
    }
}

