/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import org.jibx.extras.DocumentComparator;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.xmlpull.v1.XmlPullParserException;

public class TestRoundtrip {
    static /* synthetic */ Class class$org$jibx$extras$TestMultRoundtrip;

    protected static boolean runTest(String mname, String bname, String fin, String fout) throws IOException, JiBXException, XmlPullParserException {
        Class<?> mclas;
        try {
            URL[] urls = new URL[]{new File(".").toURL()};
            ClassLoader parent = Thread.currentThread().getContextClassLoader();
            if (parent == null) {
                parent = (class$org$jibx$extras$TestMultRoundtrip == null ? (class$org$jibx$extras$TestMultRoundtrip = TestRoundtrip.class$("org.jibx.extras.TestMultRoundtrip")) : class$org$jibx$extras$TestMultRoundtrip).getClassLoader();
            }
            URLClassLoader loader = new URLClassLoader(urls, parent);
            Thread.currentThread().setContextClassLoader(loader);
            mclas = loader.loadClass(mname);
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Class " + mname + " not found");
            return false;
        }
        IBindingFactory bfact = bname == null ? BindingDirectory.getFactory(mclas) : BindingDirectory.getFactory(bname, mclas);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        Object obj = uctx.unmarshalDocument(new FileInputStream(fin), null);
        String encoding = ((UnmarshallingContext)uctx).getInputEncoding();
        if (!mclas.isInstance(obj)) {
            System.err.println("Unmarshalled result not expected type");
            return false;
        }
        IMarshallingContext mctx = bfact.createMarshallingContext();
        mctx.setIndent(2);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        mctx.marshalDocument(obj, "UTF-8", null, bos);
        InputStreamReader brdr = new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), "UTF-8");
        InputStreamReader frdr = new InputStreamReader((InputStream)new FileInputStream(fout), encoding);
        DocumentComparator comp = new DocumentComparator(System.err);
        if (comp.compare(frdr, brdr)) {
            return true;
        }
        try {
            FileOutputStream fos = new FileOutputStream("temp.xml");
            fos.write(bos.toByteArray());
            fos.close();
        }
        catch (IOException ex) {
            System.err.println("Error writing to temp.xml: " + ex.getMessage());
        }
        return false;
    }

    public static void main(String[] args) {
        if (args.length == 2 || args.length > 0 && args.length % 3 == 0) {
            File temp = new File("temp.xml");
            if (temp.exists()) {
                temp.delete();
            }
            boolean err = false;
            String fin = null;
            String fout = null;
            for (int base = 0; base < args.length; base += 3) {
                fin = args[base + 1];
                fout = args.length < base + 3 ? fin : args[base + 2];
                try {
                    if (!TestRoundtrip.runTest(args[base], null, fin, fout)) {
                        err = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    err = true;
                }
                if (!err) continue;
                System.err.println("Error round-tripping class: " + args[base] + "\n with input file " + fin + " and output compared to " + fout);
                System.err.println("Saved output document file path " + temp.getAbsolutePath());
                System.exit(1);
            }
        } else {
            System.err.println("Usage: java TestRoundtrip mapped-class in-file [out-file]\n where out-file is only required if the output document is different from\nthe input document. Leaves output as temp.xml in case of error");
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

