/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.maven;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jibx.maven.AbstractBindingMojo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCompileBindingMojo
extends AbstractBindingMojo {
    @Override
    protected Set<String> getProjectCompileClasspathElements(MavenProject project) throws MojoExecutionException {
        try {
            HashSet<String> set = new HashSet<String>(project.getTestClasspathElements());
            Set artifactsSet = project.getDependencyArtifacts();
            for (Artifact a : artifactsSet) {
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                set.add(file.getPath());
            }
            return set;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    protected String getDefaultSchemaBindingDirectory() {
        File bindingDir = new File(this.getFullPath("src/test/config"));
        if (!bindingDir.exists() && (bindingDir = new File(this.getFullPath("target/generated-test-sources"))).exists()) {
            return "target/generated-test-sources";
        }
        return "src/test/config";
    }
}

