/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import java.io.File;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.jibx.runtime.ITrackSource;
import org.jibx.schema.IArity;
import org.jibx.schema.INamed;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.FacetElement;
import org.jibx.schema.elements.FilteredSegmentList;
import org.jibx.schema.elements.OpenAttrBase;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.SimpleTypeElement;
import org.jibx.schema.types.Count;

public class SchemaUtils {
    public static final String XS_PREFIX_BINDING = "schema_xsprefix_binding";
    public static final String NO_PREFIX_BINDING = "schema_noprefix_binding";
    public static final Logger s_logger = Logger.getLogger((class$org$jibx$schema$SchemaUtils == null ? (class$org$jibx$schema$SchemaUtils = SchemaUtils.class$("org.jibx.schema.SchemaUtils")) : class$org$jibx$schema$SchemaUtils).getName());
    private static final String s_indentText = " . . . . . . . . . . . . . . . . . . . . ";
    private static final String[] s_indents = new String[" . . . . . . . . . . . . . . . . . . . . ".length()];
    static /* synthetic */ Class class$org$jibx$schema$SchemaUtils;

    public static boolean isRepeated(IArity part) {
        Count max = part.getMaxOccurs();
        return max != null && max.isGreaterThan(1);
    }

    public static boolean isProhibited(IArity part) {
        return Count.isCountEqual(0, part.getMaxOccurs());
    }

    public static boolean isOptional(IArity part) {
        return Count.isCountEqual(0, part.getMinOccurs());
    }

    public static boolean isOptionalElement(ElementElement elem) {
        return Count.isCountEqual(0, elem.getMinOccurs()) || elem.isNillable() && !SchemaUtils.isRepeated(elem);
    }

    public static boolean isOptionalAttribute(AttributeElement attr) {
        return attr.getUse() == 0;
    }

    public static boolean isSingleton(IArity part) {
        return Count.isCountEqual(1, part.getMinOccurs()) && Count.isCountEqual(1, part.getMaxOccurs());
    }

    public static boolean isSingletonElement(ElementElement elem) {
        return !elem.isNillable() && SchemaUtils.isSingleton(elem);
    }

    public static boolean isNillable(OpenAttrBase comp) {
        if (comp instanceof ElementElement) {
            return ((ElementElement)comp).isNillable();
        }
        return false;
    }

    public static boolean isNamed(OpenAttrBase comp) {
        if (comp instanceof INamed) {
            return ((INamed)((Object)comp)).getName() != null;
        }
        return false;
    }

    public static String getIndentation(int depth) {
        if (depth < s_indents.length) {
            return s_indents[depth];
        }
        return s_indentText;
    }

    public static String describeComponent(SchemaBase comp) {
        ITrackSource track;
        String path;
        String name;
        StringBuffer buff = new StringBuffer();
        buff.append(comp.name());
        if (comp instanceof INamed && (name = ((INamed)((Object)comp)).getName()) != null) {
            buff.append(' ');
            buff.append(name);
        }
        if (comp instanceof ITrackSource && (path = (track = (ITrackSource)((Object)comp)).jibx_getDocumentName()) != null) {
            buff.append(" (");
            int start = path.lastIndexOf(File.separatorChar) + 1;
            int end = path.length();
            if (path.endsWith(".xsd")) {
                end -= 4;
            }
            buff.append(path.substring(start, end));
            int line = track.jibx_getLineNumber();
            if (line > 0) {
                buff.append(':');
                buff.append(line);
            }
            buff.append(")");
        }
        return buff.toString();
    }

    public static String componentPath(OpenAttrBase comp) {
        ITrackSource track;
        String path;
        StringBuffer buff = new StringBuffer();
        StringBuffer segment = new StringBuffer();
        OpenAttrBase node = comp;
        while (node != null && node.type() != 33) {
            String name;
            segment.append(node.name());
            OpenAttrBase parent = node.getParent();
            if (node instanceof INamed && (name = ((INamed)((Object)node)).getName()) != null) {
                segment.append("[@name=");
                segment.append(name);
                segment.append(']');
            } else {
                int index = 1;
                if (parent != null) {
                    OpenAttrBase child;
                    Iterator iter = parent.getChildIterator();
                    while (iter.hasNext() && (child = (OpenAttrBase)iter.next()) != node) {
                        if (child.type() != node.type()) continue;
                        ++index;
                    }
                }
                if (index > 1) {
                    segment.append('[');
                    segment.append(index);
                    segment.append(']');
                }
            }
            if (buff.length() > 0) {
                segment.append('/');
            }
            buff.insert(0, segment.toString());
            segment.setLength(0);
            node = parent;
        }
        if (comp instanceof ITrackSource && (path = (track = (ITrackSource)((Object)comp)).jibx_getDocumentName()) != null) {
            buff.append(" (");
            int start = path.lastIndexOf(File.separatorChar) + 1;
            int end = path.length();
            if (path.endsWith(".xsd")) {
                end -= 4;
            }
            buff.append(path.substring(start, end));
            int line = track.jibx_getLineNumber();
            if (line > 0) {
                buff.append(':');
                buff.append(line);
            }
            buff.append(")");
        }
        return buff.toString();
    }

    public static boolean isEnumeration(AnnotatedBase comp) {
        SimpleTypeElement type;
        if (comp.type() == 37 && (type = (SimpleTypeElement)comp).getDerivation().type() == 32) {
            SimpleRestrictionElement restrict = (SimpleRestrictionElement)type.getDerivation();
            FilteredSegmentList facets = restrict.getFacetsList();
            for (int i = 0; i < facets.size(); ++i) {
                FacetElement facet = (FacetElement)facets.get(i);
                if (facet.type() != 12) continue;
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < s_indents.length; ++i) {
            SchemaUtils.s_indents[i] = s_indentText.substring(0, i);
        }
    }
}

