/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jibx.schema.ISchemaListener;
import org.jibx.schema.ISkipElements;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.SchemaVisitor;
import org.jibx.schema.elements.AllElement;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AnnotationElement;
import org.jibx.schema.elements.AnyAttributeElement;
import org.jibx.schema.elements.AnyElement;
import org.jibx.schema.elements.AppInfoElement;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupElement;
import org.jibx.schema.elements.AttributeGroupRefElement;
import org.jibx.schema.elements.ChoiceElement;
import org.jibx.schema.elements.ComplexContentElement;
import org.jibx.schema.elements.ComplexExtensionElement;
import org.jibx.schema.elements.ComplexRestrictionElement;
import org.jibx.schema.elements.ComplexTypeElement;
import org.jibx.schema.elements.DocumentationElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.FacetElement;
import org.jibx.schema.elements.GroupElement;
import org.jibx.schema.elements.GroupRefElement;
import org.jibx.schema.elements.ImportElement;
import org.jibx.schema.elements.IncludeElement;
import org.jibx.schema.elements.KeyBase;
import org.jibx.schema.elements.ListElement;
import org.jibx.schema.elements.NotationElement;
import org.jibx.schema.elements.OpenAttrBase;
import org.jibx.schema.elements.RedefineElement;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SchemaLocationBase;
import org.jibx.schema.elements.SelectionBase;
import org.jibx.schema.elements.SequenceElement;
import org.jibx.schema.elements.SimpleContentElement;
import org.jibx.schema.elements.SimpleExtensionElement;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.SimpleTypeElement;
import org.jibx.schema.elements.UnionElement;

public class TreeWalker {
    private static final Logger s_logger = Logger.getLogger((class$org$jibx$schema$TreeWalker == null ? (class$org$jibx$schema$TreeWalker = TreeWalker.class$("org.jibx.schema.TreeWalker")) : class$org$jibx$schema$TreeWalker).getName());
    private final ISkipElements m_skipSet;
    private final ISchemaListener m_schemaListener;
    static /* synthetic */ Class class$org$jibx$schema$TreeWalker;

    public TreeWalker(ISkipElements skip, ISchemaListener listen) {
        this.m_skipSet = skip;
        this.m_schemaListener = listen;
    }

    public static Level setLogging(Level level) {
        Level prior = s_logger.getLevel();
        s_logger.setLevel(level);
        return prior;
    }

    public void walkSchema(SchemaElement schema, SchemaVisitor visitor) {
        if (schema != null && (this.m_schemaListener == null || this.m_schemaListener.enterSchema(schema))) {
            this.walkElement(schema, visitor);
            if (this.m_schemaListener != null) {
                this.m_schemaListener.exitSchema();
            }
        }
    }

    public void walkElement(SchemaBase root, SchemaVisitor visitor) {
        if (this.m_skipSet != null && this.m_skipSet.isSkipped(root)) {
            if (s_logger.isDebugEnabled() && root instanceof OpenAttrBase) {
                s_logger.debug("Skipping node " + SchemaUtils.componentPath((OpenAttrBase)root));
            }
            return;
        }
        boolean expand = false;
        if (s_logger.isDebugEnabled() && root instanceof OpenAttrBase) {
            s_logger.debug("Entering node " + SchemaUtils.componentPath((OpenAttrBase)root));
        }
        switch (root.type()) {
            case 0: {
                expand = visitor.visit((AllElement)root);
                break;
            }
            case 1: {
                expand = visitor.visit((AnnotationElement)root);
                break;
            }
            case 2: {
                expand = visitor.visit((AnyElement)root);
                break;
            }
            case 3: {
                expand = visitor.visit((AnyAttributeElement)root);
                break;
            }
            case 4: {
                expand = visitor.visit((AppInfoElement)root);
                break;
            }
            case 5: {
                expand = visitor.visit((AttributeElement)root);
                break;
            }
            case 6: {
                if (root instanceof AttributeGroupElement) {
                    expand = visitor.visit((AttributeGroupElement)root);
                    break;
                }
                expand = visitor.visit((AttributeGroupRefElement)root);
                break;
            }
            case 7: {
                expand = visitor.visit((ChoiceElement)root);
                break;
            }
            case 8: {
                expand = visitor.visit((ComplexContentElement)root);
                break;
            }
            case 9: {
                expand = visitor.visit((ComplexTypeElement)root);
                break;
            }
            case 10: {
                expand = visitor.visit((DocumentationElement)root);
                break;
            }
            case 11: {
                expand = visitor.visit((ElementElement)root);
                break;
            }
            case 13: {
                if (root instanceof ComplexExtensionElement) {
                    expand = visitor.visit((ComplexExtensionElement)root);
                    break;
                }
                expand = visitor.visit((SimpleExtensionElement)root);
                break;
            }
            case 14: {
                expand = visitor.visit((SelectionBase.FieldElement)root);
                break;
            }
            case 16: {
                if (root instanceof GroupElement) {
                    expand = visitor.visit((GroupElement)root);
                    break;
                }
                expand = visitor.visit((GroupRefElement)root);
                break;
            }
            case 17: {
                expand = visitor.visit((ImportElement)root);
                break;
            }
            case 18: {
                expand = visitor.visit((IncludeElement)root);
                break;
            }
            case 19: {
                expand = visitor.visit((KeyBase.KeyElement)root);
                break;
            }
            case 20: {
                expand = visitor.visit((KeyBase.KeyrefElement)root);
                break;
            }
            case 22: {
                expand = visitor.visit((ListElement)root);
                break;
            }
            case 29: {
                expand = visitor.visit((NotationElement)root);
                break;
            }
            case 31: {
                expand = visitor.visit((RedefineElement)root);
                break;
            }
            case 32: {
                if (root instanceof SimpleRestrictionElement) {
                    expand = visitor.visit((SimpleRestrictionElement)root);
                    break;
                }
                expand = visitor.visit((ComplexRestrictionElement)root);
                break;
            }
            case 33: {
                expand = visitor.visit((SchemaElement)root);
                break;
            }
            case 34: {
                expand = visitor.visit((SelectionBase.SelectorElement)root);
                break;
            }
            case 35: {
                expand = visitor.visit((SequenceElement)root);
                break;
            }
            case 36: {
                expand = visitor.visit((SimpleContentElement)root);
                break;
            }
            case 37: {
                expand = visitor.visit((SimpleTypeElement)root);
                break;
            }
            case 39: {
                expand = visitor.visit((UnionElement)root);
                break;
            }
            case 40: {
                expand = visitor.visit((KeyBase.UniqueElement)root);
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 41: {
                expand = visitor.visit((FacetElement)root);
                break;
            }
            default: {
                throw new IllegalStateException("Internal error: unknown element type");
            }
        }
        if (expand && (this.m_skipSet == null || !this.m_skipSet.isSkipped(root))) {
            this.walkChildren(root, visitor);
        }
        switch (root.type()) {
            case 0: {
                visitor.exit((AllElement)root);
                break;
            }
            case 1: {
                visitor.exit((AnnotationElement)root);
                break;
            }
            case 2: {
                visitor.exit((AnyElement)root);
                break;
            }
            case 3: {
                visitor.exit((AnyAttributeElement)root);
                break;
            }
            case 4: {
                visitor.exit((AppInfoElement)root);
                break;
            }
            case 5: {
                visitor.exit((AttributeElement)root);
                break;
            }
            case 6: {
                if (root instanceof AttributeGroupElement) {
                    visitor.exit((AttributeGroupElement)root);
                    break;
                }
                visitor.exit((AttributeGroupRefElement)root);
                break;
            }
            case 7: {
                visitor.exit((ChoiceElement)root);
                break;
            }
            case 8: {
                visitor.exit((ComplexContentElement)root);
                break;
            }
            case 9: {
                visitor.exit((ComplexTypeElement)root);
                break;
            }
            case 10: {
                visitor.exit((DocumentationElement)root);
                break;
            }
            case 11: {
                visitor.exit((ElementElement)root);
                break;
            }
            case 13: {
                if (root instanceof ComplexExtensionElement) {
                    visitor.exit((ComplexExtensionElement)root);
                    break;
                }
                visitor.exit((SimpleExtensionElement)root);
                break;
            }
            case 14: {
                visitor.exit((SelectionBase.FieldElement)root);
                break;
            }
            case 16: {
                if (root instanceof GroupElement) {
                    visitor.exit((GroupElement)root);
                    break;
                }
                visitor.exit((GroupRefElement)root);
                break;
            }
            case 17: {
                visitor.exit((ImportElement)root);
                break;
            }
            case 18: {
                visitor.exit((IncludeElement)root);
                break;
            }
            case 19: {
                visitor.exit((KeyBase.KeyElement)root);
                break;
            }
            case 20: {
                visitor.exit((KeyBase.KeyrefElement)root);
                break;
            }
            case 22: {
                visitor.exit((ListElement)root);
                break;
            }
            case 29: {
                visitor.exit((NotationElement)root);
                break;
            }
            case 31: {
                visitor.exit((RedefineElement)root);
                break;
            }
            case 32: {
                if (root instanceof SimpleRestrictionElement) {
                    visitor.exit((SimpleRestrictionElement)root);
                    break;
                }
                visitor.exit((ComplexRestrictionElement)root);
                break;
            }
            case 33: {
                visitor.exit((SchemaElement)root);
                break;
            }
            case 34: {
                visitor.exit((SelectionBase.SelectorElement)root);
                break;
            }
            case 35: {
                visitor.exit((SequenceElement)root);
                break;
            }
            case 36: {
                visitor.exit((SimpleContentElement)root);
                break;
            }
            case 37: {
                visitor.exit((SimpleTypeElement)root);
                break;
            }
            case 39: {
                visitor.exit((UnionElement)root);
                break;
            }
            case 40: {
                visitor.exit((KeyBase.UniqueElement)root);
                break;
            }
            case 12: 
            case 15: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 38: 
            case 41: {
                visitor.exit((FacetElement)root);
                break;
            }
        }
        if (s_logger.isDebugEnabled() && root instanceof OpenAttrBase) {
            s_logger.debug("Left node " + SchemaUtils.componentPath((OpenAttrBase)root));
        }
    }

    public void walkChildren(SchemaBase root, SchemaVisitor visitor) {
        AnnotationElement anno;
        if (root instanceof AnnotatedBase && (anno = ((AnnotatedBase)root).getAnnotation()) != null) {
            this.walkElement(anno, visitor);
        }
        if (root instanceof SchemaLocationBase) {
            SchemaElement schema = ((SchemaLocationBase)root).getReferencedSchema();
            s_logger.debug(" checking referenced schema " + schema.getResolver().getName());
            if (schema != null && (this.m_schemaListener == null || this.m_schemaListener.enterSchema(schema))) {
                this.walkElement(schema, visitor);
                if (this.m_schemaListener != null) {
                    this.m_schemaListener.exitSchema();
                }
            }
        }
        if (root instanceof OpenAttrBase) {
            OpenAttrBase parent = (OpenAttrBase)root;
            int count = parent.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.walkElement(parent.getChild(i), visitor);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

