/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.jibx.schema.codegen.PackageHolder;
import org.jibx.schema.codegen.PackageOrganizer;
import org.jibx.schema.codegen.StringObjectPair;
import org.jibx.schema.codegen.StringPair;

public class DataModelUtils {
    public static StringObjectPair[] getImage(PackageOrganizer directory) {
        ArrayList packs = directory.getPackages();
        ArrayList<StringObjectPair> classdetails = new ArrayList<StringObjectPair>();
        for (int i = 0; i < packs.size(); ++i) {
            StringObjectPair[] classfields = ((PackageHolder)packs.get(i)).getClassFields();
            for (int j = 0; j < classfields.length; ++j) {
                classdetails.add(classfields[j]);
            }
        }
        return classdetails.toArray(new StringObjectPair[classdetails.size()]);
    }

    public static void writeImage(PackageOrganizer directory, BufferedWriter writer) throws IOException {
        ArrayList packs = directory.getPackages();
        for (int i = 0; i < packs.size(); ++i) {
            StringObjectPair[] claspairs = ((PackageHolder)packs.get(i)).getClassFields();
            for (int j = 0; j < claspairs.length; ++j) {
                StringObjectPair claspair = claspairs[j];
                writer.write(claspair.getKey());
                writer.newLine();
                StringPair[] fields = (StringPair[])claspair.getValue();
                for (int k = 0; k < fields.length; ++k) {
                    StringPair field = fields[k];
                    writer.write(32);
                    writer.write(field.getKey());
                    writer.write(" (");
                    writer.write(field.getValue());
                    writer.write(41);
                    writer.newLine();
                }
            }
        }
    }

    public static StringObjectPair[] readImage(BufferedReader reader) throws IOException {
        String line;
        ArrayList<StringObjectPair> clasdetails = new ArrayList<StringObjectPair>();
        ArrayList<StringPair> values = new ArrayList<StringPair>();
        String clasname = null;
        while ((line = reader.readLine()) != null) {
            if (line.charAt(0) == ' ') {
                int split = line.indexOf(32, 1);
                String name = line.substring(1, split);
                split = line.indexOf(40, split);
                String type = line.substring(split + 1, line.length() - 1);
                values.add(new StringPair(name, type));
                continue;
            }
            if (clasname != null) {
                StringPair[] valuepairs = values.toArray(new StringPair[values.size()]);
                clasdetails.add(new StringObjectPair(clasname, valuepairs));
            }
            values.clear();
            clasname = line;
        }
        return clasdetails.toArray(new StringObjectPair[clasdetails.size()]);
    }

    private static void listClass(StringPair[] values, StringBuffer buff) {
        for (int i = 0; i < values.length; ++i) {
            buff.append(' ');
            buff.append(values[i].getKey());
            buff.append(" of type ");
            buff.append(values[i].getValue());
            buff.append('\n');
        }
    }

    private static void classDiff(String name, StringPair[] pairs1, StringPair[] pairs2, StringBuffer buff) {
        int index1 = 0;
        int index2 = 0;
        boolean header = true;
        while (true) {
            StringPair pair1 = null;
            StringPair pair2 = null;
            boolean delta = false;
            int diff = -1;
            if (index1 < pairs1.length) {
                pair1 = pairs1[index1];
            }
            if (index2 < pairs2.length) {
                pair2 = pairs2[index2];
                if (pair1 == null) {
                    diff = 1;
                } else {
                    diff = pair1.getKey().compareTo(pair2.getKey());
                    if (diff == 0) {
                        delta = !pair1.getValue().equals(pair2.getValue());
                    }
                }
            } else if (pair1 == null) break;
            if (delta || diff != 0) {
                if (header) {
                    buff.append("Difference(s) for class ");
                    buff.append(name);
                    buff.append(":\n");
                    header = false;
                }
                if (diff < 0) {
                    buff.append(" Missing value '");
                    buff.append(pair1.getKey());
                    buff.append("' of type ");
                    buff.append(pair1.getValue());
                    ++index1;
                } else if (diff > 0) {
                    buff.append(" Added value '");
                    buff.append(pair2.getKey());
                    buff.append("' of type ");
                    buff.append(pair2.getValue());
                    ++index2;
                } else {
                    buff.append(" Value '");
                    buff.append(pair1.getKey());
                    buff.append("' type was ");
                    buff.append(pair1.getValue());
                    buff.append(", changed to ");
                    buff.append(pair2.getValue());
                }
                buff.append('\n');
            }
            if (diff != 0) continue;
            ++index1;
            ++index2;
        }
    }

    public static String imageDiff(StringObjectPair[] pairs1, StringObjectPair[] pairs2) {
        StringBuffer buff = new StringBuffer();
        int index1 = 0;
        int index2 = 0;
        while (true) {
            StringObjectPair pair1 = null;
            StringObjectPair pair2 = null;
            int diff = -1;
            if (index1 < pairs1.length) {
                pair1 = pairs1[index1];
            }
            if (index2 < pairs2.length) {
                pair2 = pairs2[index2];
                diff = pair1 == null ? 1 : pair1.getKey().compareTo(pair2.getKey());
            } else if (pair1 == null) break;
            if (diff == 0) {
                DataModelUtils.classDiff(pair1.getKey(), (StringPair[])pair1.getValue(), (StringPair[])pair2.getValue(), buff);
                ++index1;
                ++index2;
                continue;
            }
            if (diff < 0) {
                buff.append("Second image is missing class " + pair1.getKey() + ":\n");
                DataModelUtils.listClass((StringPair[])pair1.getValue(), buff);
                ++index1;
                continue;
            }
            buff.append("Second image has added class " + pair2.getKey() + ":\n");
            DataModelUtils.listClass((StringPair[])pair2.getValue(), buff);
            ++index2;
        }
        if (buff.length() == 0) {
            return null;
        }
        return buff.toString();
    }
}

