/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import org.jibx.schema.SchemaUtils;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.custom.ComponentExtension;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.CommonTypeDerivation;
import org.jibx.schema.elements.ElementElement;

public abstract class Item {
    private final ComponentExtension m_componentExtension;
    private final boolean m_topmost;
    private final boolean m_optional;
    private final boolean m_collection;
    private final boolean m_nillable;
    private boolean m_implicit;
    private GroupItem m_parent;
    protected Item m_next;
    protected Item m_last;
    private String m_name;

    protected Item(AnnotatedBase comp, GroupItem parent) {
        this.m_componentExtension = (ComponentExtension)comp.getExtension();
        this.m_parent = parent;
        if (parent == null || parent.getSchemaComponent() != comp) {
            this.m_topmost = true;
            this.m_optional = this.m_componentExtension.isOptional();
            this.m_collection = this.m_componentExtension.isRepeated();
            this.m_nillable = comp.type() == 11 && ((ElementElement)comp).isNillable();
        } else {
            this.m_nillable = false;
            this.m_collection = false;
            this.m_optional = false;
            this.m_topmost = false;
        }
        this.m_name = this.m_componentExtension.getBaseName();
    }

    protected Item(Item original, Item ref, ComponentExtension ext, GroupItem parent) {
        this.m_componentExtension = ext;
        this.m_parent = parent;
        if (parent == null || parent.getSchemaComponent() != this.m_componentExtension.getComponent()) {
            this.m_topmost = true;
            Item top = original.getTopmost();
            this.m_optional = top.m_optional;
            this.m_collection = top.m_collection;
            this.m_nillable = top.m_nillable;
        } else {
            this.m_nillable = false;
            this.m_collection = false;
            this.m_optional = false;
            this.m_topmost = false;
        }
        this.m_name = ref == null || original.isFixedName() ? original.m_name : ref.m_name;
    }

    protected void reparent(GroupItem parent) {
        this.m_parent = parent;
    }

    public AnnotatedBase getSchemaComponent() {
        return (AnnotatedBase)this.m_componentExtension.getComponent();
    }

    public ComponentExtension getComponentExtension() {
        return this.m_componentExtension;
    }

    public GroupItem getParent() {
        return this.m_parent;
    }

    public boolean isFixedName() {
        return this.m_componentExtension.getBaseName() != null;
    }

    public String getEffectiveName() {
        Item item = this;
        while (item.m_name == null) {
            item = item.m_parent;
            if (item != null) continue;
            throw new IllegalStateException("Inherited name with nothing to inherit");
        }
        return item.m_name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        if (this.isFixedName()) {
            throw new IllegalStateException("Internal error - attempt to change configured name");
        }
        this.m_name = name;
    }

    public Item getNext() {
        return this.m_next;
    }

    public boolean isTopmost() {
        return this.m_topmost;
    }

    public Item getTopmost() {
        Item top = this;
        while (!top.isTopmost()) {
            top = top.m_parent;
        }
        return top;
    }

    public boolean isOptional() {
        return this.m_optional;
    }

    public boolean isIgnored() {
        return this.getComponentExtension().isIgnored();
    }

    public boolean isCollection() {
        return this.m_collection;
    }

    public boolean isImplicit() {
        return this.m_implicit;
    }

    public void setImplicit(boolean implicit) {
        this.m_implicit = implicit;
    }

    protected abstract Item copy(Item var1, GroupItem var2);

    protected GroupItem findDisjointParent() {
        GroupItem parent;
        AnnotatedBase comp = this.getSchemaComponent();
        for (parent = this.getParent(); parent != null && parent.getSchemaComponent() == comp; parent = parent.getParent()) {
        }
        return parent;
    }

    protected void classifyContent() {
        GroupItem parent;
        if (this.m_topmost && (parent = this.findDisjointParent()) != null) {
            AnnotatedBase comp = this.getSchemaComponent();
            switch (comp.type()) {
                case 2: 
                case 11: {
                    if (!this.m_optional) {
                        parent.forceRequiredPresent();
                    }
                }
                case 16: {
                    parent.forceElementPresent();
                    break;
                }
                case 13: {
                    CommonTypeDerivation deriv = (CommonTypeDerivation)comp;
                    if (deriv.isComplexType()) break;
                    parent.forceContentPresent();
                    parent.forceRequiredPresent();
                    break;
                }
                case 3: 
                case 5: {
                    if (!this.m_optional) {
                        parent.forceRequiredPresent();
                    }
                }
                case 6: {
                    parent.forceAttributePresent();
                }
            }
        }
    }

    protected abstract String describe(int var1, boolean var2);

    protected String leadString(int depth) {
        StringBuffer buff = new StringBuffer(SchemaUtils.getIndentation(depth));
        if (this.isOptional()) {
            buff.append("optional ");
        }
        if (this.isCollection()) {
            buff.append("repeating ");
        }
        return buff.toString();
    }
}

