/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jibx.runtime.Utility;
import org.jibx.schema.codegen.PackageHolder;
import org.jibx.util.InsertionOrderedMap;

public class PackageOrganizer {
    private final File m_generateDirectory;
    private String[] m_namespaceLeadMatches;
    private String[] m_namespaceLeadReplaces;
    private Map m_namespacePackageMap;
    private Map m_packageDirectoryMap;
    private String[] m_authorityDiscards = new String[]{"www."};
    private Map m_uriPackageMap;
    private InsertionOrderedMap m_namePackageMap;
    private String m_noNamespacePackage;

    public PackageOrganizer(File basedir, String npkg) {
        this.m_generateDirectory = basedir;
        this.m_namespaceLeadMatches = Utility.EMPTY_STRING_ARRAY;
        this.m_namespaceLeadReplaces = Utility.EMPTY_STRING_ARRAY;
        this.m_namespacePackageMap = Collections.EMPTY_MAP;
        this.m_packageDirectoryMap = Collections.EMPTY_MAP;
        this.m_uriPackageMap = new HashMap();
        this.m_namePackageMap = new InsertionOrderedMap();
        this.m_noNamespacePackage = npkg;
        this.m_namePackageMap.put("", new PackageHolder("", basedir, null));
    }

    public void setNamespaceLeadReplaces(String[] leads, String[] repls) {
        this.m_namespaceLeadMatches = leads;
    }

    public void setNSPackageMap(Map map) {
        this.m_namespacePackageMap = map;
    }

    public void setPackageDirMap(Map map) {
        this.m_packageDirectoryMap = map;
    }

    private boolean isHexChar(char chr) {
        return chr >= '0' && chr <= '9' || chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z';
    }

    private int hexValue(char chr) {
        if (chr >= '0' && chr <= '9') {
            return chr - 48;
        }
        return Character.toLowerCase(chr) - 97 + 10;
    }

    private static boolean isAsciiAlpha(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z';
    }

    private static boolean isAsciiNum(char chr) {
        return chr >= '0' && chr <= '9';
    }

    private static boolean isAsciiAlphaNum(char chr) {
        return PackageOrganizer.isAsciiAlpha(chr) || PackageOrganizer.isAsciiNum(chr);
    }

    public String uriToPackage(String uri) {
        int end;
        int base;
        int i;
        int split;
        if (uri.length() == 0) {
            return this.m_noNamespacePackage;
        }
        String pname = uri.toLowerCase();
        for (int i2 = 0; i2 < this.m_namespaceLeadMatches.length; ++i2) {
            String lead = this.m_namespaceLeadMatches[i2];
            if (!pname.startsWith(lead)) continue;
            pname = this.m_namespaceLeadReplaces[i2] + pname.substring(lead.length());
            break;
        }
        if ((split = (pname = pname.replace('\\', '/')).indexOf(58)) > 0 && PackageOrganizer.isAsciiAlpha(pname.charAt(0))) {
            boolean scheme = true;
            for (i = 0; i < split; ++i) {
                char chr = pname.charAt(i);
                if (PackageOrganizer.isAsciiAlphaNum(chr) || chr == '-' || chr == '+' || chr == '.') continue;
                scheme = false;
                break;
            }
            if (scheme) {
                pname = pname.substring(split + 1);
            }
        }
        if ((base = pname.indexOf(58)) > 0) {
            int tail;
            for (tail = base + 1; tail < pname.length() && PackageOrganizer.isAsciiNum(pname.charAt(tail)); ++tail) {
            }
            pname = pname.substring(0, base) + pname.substring(tail);
        }
        if (pname.startsWith("//")) {
            pname = pname.substring(2);
            for (i = 0; i < this.m_authorityDiscards.length; ++i) {
                String match2 = this.m_authorityDiscards[i];
                if (!pname.startsWith(match2)) continue;
                pname = pname.substring(match2.length());
            }
        }
        if ((end = (pname = pname.replace('@', '.')).indexOf(47)) < 0) {
            end = pname.length();
        }
        StringBuffer buff = new StringBuffer(pname.length());
        int mark = end;
        while ((split = pname.lastIndexOf(46, --mark)) >= 0) {
            if (buff.length() > 0) {
                buff.append(pname.substring(split, mark + 1));
            } else {
                buff.append(pname.substring(split + 1, mark + 1));
            }
            mark = split;
        }
        if (mark >= 0) {
            if (buff.length() > 0) {
                buff.append('.');
            }
            buff.append(pname.substring(0, mark + 1));
        }
        pname = pname.substring(end);
        split = (pname = pname.replace(':', '/')).lastIndexOf(46);
        if (split > 0 && split > pname.lastIndexOf(47)) {
            pname = pname.substring(0, split);
        }
        buff.append(pname);
        int index = 0;
        boolean first = true;
        while (index < buff.length()) {
            char chr = buff.charAt(index);
            boolean delete = false;
            if (chr == '.') {
                if (first) {
                    delete = true;
                } else {
                    first = true;
                }
            } else if (chr == '/') {
                if (first) {
                    delete = true;
                } else {
                    buff.setCharAt(index, '.');
                    first = true;
                }
            } else if (chr == '+') {
                buff.setCharAt(index, '_');
                first = false;
            } else if (chr == '%') {
                if (index + 2 < buff.length()) {
                    char chr1 = buff.charAt(index + 1);
                    char chr2 = buff.charAt(index + 2);
                    if (this.isHexChar(chr1) && this.isHexChar(chr2)) {
                        buff.setCharAt(index, (char)(this.hexValue(chr1) * 16 + this.hexValue(chr2)));
                        buff.delete(index + 1, index + 3);
                        continue;
                    }
                } else {
                    delete = true;
                }
            } else if (PackageOrganizer.isAsciiAlpha(chr) || !first && PackageOrganizer.isAsciiNum(chr)) {
                first = false;
            } else {
                delete = true;
            }
            if (delete) {
                buff.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        if (first && buff.length() > 0) {
            buff.setLength(buff.length() - 1);
        }
        return buff.toString();
    }

    public PackageHolder getPackage(String pname) {
        PackageHolder pkg = (PackageHolder)this.m_namePackageMap.get(pname);
        if (pkg == null) {
            File pardir;
            PackageHolder parent;
            int split = pname.lastIndexOf(46);
            if (split >= 0) {
                parent = this.getPackage(pname.substring(0, split));
            } else if (pname.length() > 0) {
                parent = this.getPackage("");
            } else {
                return new PackageHolder("", this.m_generateDirectory, null);
            }
            File gendir = (File)this.m_packageDirectoryMap.get(pname);
            if (gendir == null && (pardir = parent.getGenerateDirectory()) != null) {
                gendir = new File(pardir, pname.substring(split + 1));
            }
            pkg = new PackageHolder(pname, gendir, parent);
            this.m_namePackageMap.put(pname, pkg);
        }
        return pkg;
    }

    public PackageHolder getPackageForUri(String uri) {
        PackageHolder pkg = (PackageHolder)this.m_uriPackageMap.get(uri);
        if (pkg == null) {
            String pname = null;
            if (this.m_namespacePackageMap != null) {
                pname = (String)this.m_namespacePackageMap.get(uri);
            }
            if (pname == null) {
                pname = this.uriToPackage(uri);
            }
            pkg = this.getPackage(pname);
            this.m_uriPackageMap.put(uri, pkg);
        }
        return pkg;
    }

    public ArrayList getPackages() {
        ArrayList keys = this.m_namePackageMap.keyList();
        ArrayList<Object> packs = new ArrayList<Object>();
        for (int i = 0; i < keys.size(); ++i) {
            packs.add(this.m_namePackageMap.get(keys.get(i)));
        }
        return packs;
    }
}

