/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jibx.binding.Utility;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.IComponent;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValueElement;
import org.jibx.custom.classes.ClassCustom;
import org.jibx.custom.classes.GlobalCustom;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.schema.MemoryResolver;
import org.jibx.schema.SchemaHolder;
import org.jibx.schema.elements.AllElement;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AnnotationElement;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.AttributeGroupElement;
import org.jibx.schema.elements.AttributeGroupRefElement;
import org.jibx.schema.elements.ChoiceElement;
import org.jibx.schema.elements.CommonCompositorDefinition;
import org.jibx.schema.elements.ComplexContentElement;
import org.jibx.schema.elements.ComplexExtensionElement;
import org.jibx.schema.elements.ComplexTypeElement;
import org.jibx.schema.elements.DocumentationElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.FacetElement;
import org.jibx.schema.elements.FilteredSegmentList;
import org.jibx.schema.elements.GroupElement;
import org.jibx.schema.elements.GroupRefElement;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.elements.SequenceElement;
import org.jibx.schema.elements.SimpleContentElement;
import org.jibx.schema.elements.SimpleExtensionElement;
import org.jibx.schema.elements.SimpleRestrictionElement;
import org.jibx.schema.elements.SimpleTypeElement;
import org.jibx.schema.generator.DetailDirectory;
import org.jibx.schema.generator.EnumDetail;
import org.jibx.schema.generator.FormatterCache;
import org.jibx.schema.generator.MappingDetail;
import org.jibx.schema.generator.SchemaGenCommandLine;
import org.jibx.schema.types.Count;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationProblem;
import org.jibx.schema.validation.ValidationUtils;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.jibx.util.IClassLocator;
import org.jibx.util.Types;
import org.w3c.dom.Node;

public class SchemaGen {
    private final IClassLocator m_locator;
    private final GlobalCustom m_custom;
    private final Map m_classSimpletypes;
    private final Map m_uriNames;
    private final Map m_uriSchemas;
    private final FormatterCache m_formatCache;
    private final org.jibx.binding.model.ValidationContext m_context;
    private final DetailDirectory m_detailDirectory;
    static /* synthetic */ Class class$org$jibx$schema$elements$SchemaElement;

    public SchemaGen(IClassLocator loc, GlobalCustom custom, Map urinames) {
        this.m_locator = loc;
        this.m_custom = custom;
        this.m_classSimpletypes = new HashMap();
        this.m_uriNames = urinames;
        this.m_uriSchemas = new HashMap();
        this.m_formatCache = new FormatterCache(loc);
        this.m_context = new org.jibx.binding.model.ValidationContext(loc);
        this.m_detailDirectory = new DetailDirectory(custom, this.m_context);
    }

    public SchemaHolder findSchema(String uri) {
        SchemaHolder hold = (SchemaHolder)this.m_uriSchemas.get(uri);
        if (hold == null) {
            String sname;
            hold = new SchemaHolder(uri);
            this.m_uriSchemas.put(uri, hold);
            if (uri == null) {
                sname = (String)this.m_uriNames.get("");
                if (sname == null) {
                    sname = "nonamespace.xsd";
                }
            } else {
                sname = (String)this.m_uriNames.get(uri);
                if (sname == null) {
                    sname = uri.substring(uri.lastIndexOf(47) + 1) + ".xsd";
                }
            }
            hold.setFileName(sname);
        }
        return hold;
    }

    private QName getSimpleTypeQName(IComponent comp) {
        IClass type = comp.getType();
        String tname = comp.getType().getName();
        QName qname = Types.schemaType(tname);
        if (qname == null && (qname = (QName)this.m_classSimpletypes.get(tname)) == null) {
            ClassCustom custom = this.m_custom.getClassCustomization(type.getName());
            if (custom != null && custom.isSimpleValue()) {
                qname = Types.STRING_QNAME;
            } else if (!type.isSuperclass("java.lang.Enum")) {
                this.m_context.addWarning("No schema equivalent known for type - treating as string", comp);
                qname = Types.STRING_QNAME;
            }
        }
        return qname;
    }

    private void addDocumentation(IClass info, AnnotatedBase root) {
        List nodes;
        ClassCustom custom = this.m_custom.getClassCustomization(info.getName());
        if (info != null && custom.isUseJavaDocs() && (nodes = this.m_formatCache.getFormatter(custom).getClassDocumentation(info)) != null) {
            AnnotationElement anno = new AnnotationElement();
            DocumentationElement doc = new DocumentationElement();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                doc.addContent(node);
            }
            anno.getItemsList().add(doc);
            root.setAnnotation(anno);
        }
    }

    private void setDocumentation(IClassItem item, AnnotatedBase elem) {
        List nodes;
        ClassCustom custom = this.m_custom.getClassCustomization(item.getOwningClass().getName());
        if (custom != null && custom.isUseJavaDocs() && (nodes = this.m_formatCache.getFormatter(custom).getItemDocumentation(item)) != null) {
            AnnotationElement anno = new AnnotationElement();
            DocumentationElement doc = new DocumentationElement();
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                doc.addContent(node);
            }
            anno.getItemsList().add(doc);
            elem.setAnnotation(anno);
        }
    }

    private void addItemDocumentation(StructureElementBase struct, AnnotatedBase elem) {
        IClassItem item = struct.getField();
        if (item == null && (item = struct.getGet()) == null) {
            item = struct.getSet();
        }
        if (item != null) {
            this.setDocumentation(item, elem);
        }
    }

    private void addItemDocumentation(ValueElement value, AnnotatedBase elem) {
        IClassItem item = value.getField();
        if (item == null && (item = value.getGet()) == null) {
            item = value.getSet();
        }
        if (item != null) {
            this.setDocumentation(item, elem);
        }
    }

    private SimpleTypeElement buildSimpleType(IClass type) {
        EnumDetail detail = this.m_detailDirectory.getSimpleDetail(type.getName());
        try {
            Class clas = type.loadClass();
            Method valsmeth = clas.getMethod("values", null);
            String totxtname = detail.getCustom().getEnumValueMethod();
            if (totxtname == null) {
                totxtname = "name";
            }
            Method namemeth = clas.getMethod(totxtname, null);
            try {
                valsmeth.setAccessible(true);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            try {
                namemeth.setAccessible(true);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            Object[] values = (Object[])valsmeth.invoke(null, (Object[])null);
            SimpleTypeElement simple = new SimpleTypeElement();
            SimpleRestrictionElement restr = new SimpleRestrictionElement();
            restr.setBase(Types.STRING_QNAME);
            for (int i = 0; i < values.length; ++i) {
                FacetElement.Enumeration enumel = new FacetElement.Enumeration();
                enumel.setValue(namemeth.invoke(values[i], (Object[])null).toString());
                restr.getFacetsList().add(enumel);
            }
            simple.setDerivation(restr);
            this.addDocumentation(detail.getCustom().getClassInformation(), simple);
            return simple;
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private SimpleTypeElement buildSimpleType(IComponent comp) {
        return this.buildSimpleType(comp.getType());
    }

    private static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private static boolean isDifferentSchema(QName qname, SchemaHolder hold) {
        return qname != null && !SchemaGen.isEqual(qname.getUri(), hold.getNamespace()) && !SchemaGen.isEqual(qname.getUri(), "http://www.w3.org/2001/XMLSchema");
    }

    private void checkDependency(QName qname, SchemaHolder hold) {
        if (SchemaGen.isDifferentSchema(qname, hold)) {
            String uri = qname.getUri();
            SchemaHolder tohold = this.findSchema(uri);
            hold.addReference(tohold);
            hold.getPrefix(uri);
        }
    }

    private ElementElement buildElement(IComponent comp, boolean repeat, SchemaHolder hold) {
        ElementElement elem = new ElementElement();
        if (repeat) {
            elem.setMinOccurs(Count.COUNT_ZERO);
            elem.setMaxOccurs(Count.COUNT_UNBOUNDED);
        } else if (comp.isOptional()) {
            elem.setMinOccurs(Count.COUNT_ZERO);
        }
        boolean isref = false;
        if (comp instanceof ValueElement) {
            QName qname = this.getSimpleTypeQName(comp);
            if (qname == null) {
                elem.setTypeDefinition(this.buildSimpleType(comp));
            } else {
                this.setElementType(qname, elem, hold);
            }
            this.addItemDocumentation((ValueElement)comp, (AnnotatedBase)elem);
        } else if (comp instanceof CollectionElement) {
            CollectionElement coll = (CollectionElement)comp;
            if (coll.children().size() > 0) {
                ComplexTypeElement type = new ComplexTypeElement();
                if (coll.isOrdered()) {
                    SequenceElement seq = new SequenceElement();
                    type.setContentDefinition(seq);
                } else {
                    ChoiceElement choice = new ChoiceElement();
                    type.setContentDefinition(choice);
                }
                type.setContentDefinition(this.buildCompositor(coll, 0, true, hold));
                elem.setTypeDefinition(type);
            } else {
                String itype = coll.getItemTypeName();
                TemplateElementBase ref = coll.getDefinitions().getSpecificTemplate(itype);
                if (ref instanceof MappingElement) {
                    MappingDetail detail = this.m_detailDirectory.getMappingDetail((MappingElementBase)ref);
                    ComplexTypeElement type = new ComplexTypeElement();
                    SequenceElement seq = new SequenceElement();
                    type.setContentDefinition(seq);
                    ElementElement item = new ElementElement();
                    this.setElementRef(detail.getOtherName(), item, hold);
                    item.setMinOccurs(Count.COUNT_ZERO);
                    item.setMaxOccurs(Count.COUNT_UNBOUNDED);
                    seq.getParticleList().add(item);
                    elem.setTypeDefinition(type);
                    this.addItemDocumentation(coll, (AnnotatedBase)item);
                } else {
                    this.m_context.addWarning("Handling not implemented for unspecified mapping", coll);
                }
            }
        } else {
            StructureElement struct = (StructureElement)comp;
            if (struct.children().size() > 0) {
                ComplexTypeElement type = new ComplexTypeElement();
                if (struct.isOrdered()) {
                    SequenceElement seq = new SequenceElement();
                    type.setContentDefinition(seq);
                } else {
                    ChoiceElement choice = new ChoiceElement();
                    type.setContentDefinition(choice);
                }
                type.setContentDefinition(this.buildCompositor(struct, 0, false, hold));
                this.fillAttributes(struct, 0, type.getAttributeList(), hold);
                elem.setTypeDefinition(type);
            } else {
                MappingElementBase ref = (MappingElementBase)struct.getEffectiveMapping();
                if (ref == null) {
                    this.m_context.addWarning("Handling not implemented for unspecified mapping", struct);
                } else {
                    MappingDetail detail = this.m_detailDirectory.getMappingDetail(ref);
                    if (detail.isElement()) {
                        this.setElementRef(detail.getOtherName(), elem, hold);
                        isref = true;
                    } else {
                        this.setElementType(detail.getTypeName(), elem, hold);
                    }
                }
            }
            this.addItemDocumentation(struct, (AnnotatedBase)elem);
        }
        if (!isref) {
            elem.setName(comp.getName());
        }
        return elem;
    }

    private static void addCompositorPart(CommonCompositorDefinition part, CommonCompositorDefinition comp) {
        FilteredSegmentList parts = part.getParticleList();
        Count maxo = part.getMaxOccurs();
        Count mino = part.getMinOccurs();
        if (parts.size() == 1 && (maxo == null || maxo.isEqual(1)) && (mino == null || mino.isEqual(1))) {
            comp.getParticleList().add(parts.get(0));
        } else if (parts.size() > 1) {
            comp.getParticleList().add(part);
        }
    }

    private CommonCompositorDefinition buildCompositor(ContainerElementBase cont, int offset, boolean repeat, SchemaHolder hold) {
        Object child;
        CommonCompositorDefinition cdef;
        if (cont.isChoice()) {
            cdef = new ChoiceElement();
        } else if (cont.isOrdered()) {
            cdef = new SequenceElement();
        } else if (repeat) {
            cdef = new ChoiceElement();
            cdef.setMaxOccurs(Count.COUNT_UNBOUNDED);
        } else {
            cdef = new AllElement();
        }
        ArrayList comps = cont.getContentComponents();
        for (int i = offset; i < comps.size(); ++i) {
            IComponent comp = (IComponent)comps.get(i);
            if (comp.hasName()) {
                ElementElement element = this.buildElement(comp, repeat, hold);
                if (comp instanceof StructureElementBase) {
                    this.addItemDocumentation((StructureElementBase)comp, (AnnotatedBase)element);
                }
                cdef.getParticleList().add(element);
                continue;
            }
            if (comp instanceof ContainerElementBase) {
                ContainerElementBase contain = (ContainerElementBase)((Object)comp);
                boolean iscoll = comp instanceof CollectionElement;
                if (contain.children().size() > 0) {
                    CommonCompositorDefinition part = this.buildCompositor(contain, 0, iscoll, hold);
                    SchemaGen.addCompositorPart(part, cdef);
                    continue;
                }
                if (iscoll) {
                    CollectionElement coll = (CollectionElement)comp;
                    String itype = coll.getItemTypeName();
                    TemplateElementBase ref = coll.getDefinitions().getSpecificTemplate(itype);
                    if (ref instanceof MappingElement) {
                        MappingDetail detail = this.m_detailDirectory.getMappingDetail((MappingElementBase)ref);
                        ElementElement item = new ElementElement();
                        QName oname = detail.getOtherName();
                        this.setElementRef(oname, item, hold);
                        item.setMinOccurs(Count.COUNT_ZERO);
                        item.setMaxOccurs(Count.COUNT_UNBOUNDED);
                        this.addItemDocumentation(coll, (AnnotatedBase)item);
                        cdef.getParticleList().add(item);
                        continue;
                    }
                    this.m_context.addWarning("Handling not implemented for unspecified mapping", coll);
                    continue;
                }
                if (comp instanceof StructureElement) {
                    StructureElement struct = (StructureElement)comp;
                    MappingElementBase ref = (MappingElementBase)struct.getEffectiveMapping();
                    if (ref == null) {
                        this.m_context.addWarning("Handling not implemented for unspecified mapping", struct);
                        continue;
                    }
                    MappingDetail detail = this.m_detailDirectory.getMappingDetail(ref);
                    if (ref.isAbstract()) {
                        GroupRefElement group = new GroupRefElement();
                        this.setGroupRef(detail.getOtherName(), group, hold);
                        if (comp.isOptional()) {
                            group.setMinOccurs(Count.COUNT_ZERO);
                        }
                        cdef.getParticleList().add(group);
                        continue;
                    }
                    ElementElement elem = new ElementElement();
                    this.setElementRef(detail.getOtherName(), elem, hold);
                    if (comp.isOptional()) {
                        elem.setMinOccurs(Count.COUNT_ZERO);
                    }
                    this.addItemDocumentation(struct, (AnnotatedBase)elem);
                    cdef.getParticleList().add(elem);
                    continue;
                }
                this.m_context.addError("Unsupported binding construct", comp);
                continue;
            }
            this.m_context.addError("Unsupported component", comp);
        }
        if ((cont.isOrdered() || cont.isChoice()) && cdef.getParticleList().size() == 1 && (child = cdef.getParticleList().get(0)) instanceof CommonCompositorDefinition) {
            cdef = (CommonCompositorDefinition)child;
        }
        return cdef;
    }

    private void setGroupRef(QName qname, AttributeGroupRefElement group, SchemaHolder hold) {
        this.checkDependency(qname, hold);
        group.setRef(qname);
    }

    private void setGroupRef(QName qname, GroupRefElement group, SchemaHolder hold) {
        this.checkDependency(qname, hold);
        group.setRef(qname);
    }

    private void setElementRef(QName qname, ElementElement elem, SchemaHolder hold) {
        this.checkDependency(qname, hold);
        elem.setRef(qname);
    }

    private void setAttributeType(QName qname, AttributeElement elem, SchemaHolder hold) {
        elem.setType(qname);
        this.checkDependency(qname, hold);
    }

    public void setElementType(QName qname, ElementElement elem, SchemaHolder hold) {
        elem.setType(qname);
        this.checkDependency(qname, hold);
    }

    private void setSubstitutionGroup(QName qname, ElementElement elem, SchemaHolder hold) {
        elem.setSubstitutionGroup(qname);
        this.checkDependency(qname, hold);
    }

    private void fillAttributes(ContainerElementBase cont, int offset, AbstractList attrs, SchemaHolder hold) {
        ArrayList comps = cont.getAttributeComponents();
        for (int i = 0; i < comps.size(); ++i) {
            IComponent comp = (IComponent)comps.get(i);
            if (comp instanceof ValueElement) {
                AttributeElement attr = new AttributeElement();
                attr.setName(comp.getName());
                QName qname = this.getSimpleTypeQName(comp);
                if (qname == null) {
                    attr.setTypeDefinition(this.buildSimpleType(comp));
                } else {
                    this.setAttributeType(qname, attr, hold);
                }
                if (!comp.isOptional()) {
                    attr.setUse(2);
                }
                this.addItemDocumentation((ValueElement)comp, (AnnotatedBase)attr);
                attrs.add(attr);
                continue;
            }
            if (comp instanceof ContainerElementBase) {
                ContainerElementBase contain = (ContainerElementBase)((Object)comp);
                if (contain.children().size() > 0) {
                    this.fillAttributes(contain, 0, attrs, hold);
                    continue;
                }
                if (comp instanceof StructureElement) {
                    StructureElement struct = (StructureElement)comp;
                    if (struct.isOptional()) {
                        this.m_context.addError("No schema equivalent for optional abstract mapping with attributes", comp);
                        continue;
                    }
                    MappingElementBase ref = (MappingElementBase)struct.getEffectiveMapping();
                    if (ref != null && ref.isAbstract()) {
                        MappingDetail detail = this.m_detailDirectory.getMappingDetail(ref);
                        AttributeGroupRefElement group = new AttributeGroupRefElement();
                        this.setGroupRef(detail.getOtherName(), group, hold);
                        attrs.add(group);
                        continue;
                    }
                    throw new IllegalStateException("Unsupported binding construct " + comp);
                }
                this.m_context.addError("Unsupported binding construct", comp);
                continue;
            }
            this.m_context.addError("Unsupported component", comp);
        }
    }

    private static boolean isComplexContent(ContainerElementBase cont) {
        ArrayList contents = cont.getContentComponents();
        for (int i = 0; i < contents.size(); ++i) {
            Object item = contents.get(i);
            if (item instanceof IComponent && ((IComponent)item).hasName()) {
                return true;
            }
            if (!(item instanceof ContainerElementBase) || !SchemaGen.isComplexContent((ContainerElementBase)item)) continue;
            return true;
        }
        return false;
    }

    private ComplexTypeElement buildComplexType(MappingDetail detail, SchemaHolder hold) {
        ComplexTypeElement type = new ComplexTypeElement();
        MappingElementBase mapping = detail.getMapping();
        MappingElement base = detail.getExtensionBase();
        if (base == null) {
            if (detail.isGroup()) {
                AnnotatedBase gref;
                SequenceElement seq = new SequenceElement();
                if (detail.hasChild()) {
                    gref = new GroupRefElement();
                    this.setGroupRef(detail.getOtherName(), (GroupRefElement)gref, hold);
                    seq.getParticleList().add(gref);
                }
                type.setContentDefinition(seq);
                if (detail.hasAttribute()) {
                    gref = new AttributeGroupRefElement();
                    this.setGroupRef(detail.getOtherName(), (AttributeGroupRefElement)gref, hold);
                    type.getAttributeList().add(gref);
                }
            } else {
                type.setContentDefinition(this.buildCompositor(mapping, 0, false, hold));
                this.fillAttributes(mapping, 0, type.getAttributeList(), hold);
            }
        } else {
            MappingDetail basedet = this.m_detailDirectory.getMappingDetail(base);
            if (SchemaGen.isComplexContent(base) || SchemaGen.isComplexContent(mapping)) {
                ComplexExtensionElement ext = new ComplexExtensionElement();
                this.setComplexExtensionBase(basedet.getTypeName(), ext, hold);
                CommonCompositorDefinition comp = this.buildCompositor(mapping, 1, false, hold);
                if (comp.getParticleList().size() > 0) {
                    ext.setContentDefinition(comp);
                }
                this.fillAttributes(mapping, 0, ext.getAttributeList(), hold);
                ComplexContentElement cont = new ComplexContentElement();
                cont.setDerivation(ext);
                type.setContentType(cont);
            } else {
                SimpleExtensionElement ext = new SimpleExtensionElement();
                this.setSimpleExtensionBase(basedet.getTypeName(), ext, hold);
                this.fillAttributes(mapping, 0, ext.getAttributeList(), hold);
                SimpleContentElement cont = new SimpleContentElement();
                cont.setDerivation(ext);
                type.setContentType(cont);
            }
        }
        return type;
    }

    private void setComplexExtensionBase(QName qname, ComplexExtensionElement ext, SchemaHolder hold) {
        ext.setBase(qname);
        this.checkDependency(qname, hold);
    }

    private void setSimpleExtensionBase(QName qname, SimpleExtensionElement ext, SchemaHolder hold) {
        ext.setBase(qname);
        this.checkDependency(qname, hold);
    }

    private void addMapping(MappingDetail detail) {
        SchemaHolder hold;
        QName qname;
        IClass info = null;
        if (this.m_locator != null) {
            info = this.m_locator.getClassInfo(detail.getMapping().getClassName());
        }
        MappingElementBase mapping = detail.getMapping();
        if (detail.isGroup()) {
            qname = detail.getOtherName();
            hold = this.findSchema(qname.getUri());
            if (detail.hasChild()) {
                GroupElement group = new GroupElement();
                group.setName(qname.getName());
                group.setDefinition(this.buildCompositor(mapping, 0, false, hold));
                this.addDocumentation(info, group);
                hold.getSchema().getTopLevelChildren().add(group);
            }
            if (detail.hasAttribute()) {
                AttributeGroupElement attgrp = new AttributeGroupElement();
                attgrp.setName(qname.getName());
                this.fillAttributes(mapping, 0, attgrp.getAttributeList(), hold);
                this.addDocumentation(info, attgrp);
                hold.getSchema().getTopLevelChildren().add(attgrp);
            }
        }
        if (detail.isType()) {
            qname = detail.getTypeName();
            hold = this.findSchema(qname.getUri());
            ComplexTypeElement type = this.buildComplexType(detail, hold);
            type.setName(qname.getName());
            this.addDocumentation(info, type);
            hold.getSchema().getTopLevelChildren().add(type);
        }
        if (detail.isElement()) {
            qname = detail.getOtherName();
            hold = this.findSchema(qname.getUri());
            ElementElement elem = new ElementElement();
            elem.setName(qname.getName());
            this.setSubstitutionGroup(detail.getSubstitution(), elem, hold);
            if (detail.isType()) {
                this.setElementType(detail.getTypeName(), elem, hold);
            } else {
                MappingElement ext = detail.getExtensionBase();
                if (ext != null && !detail.hasAttribute() && mapping.getContentComponents().size() == 1) {
                    this.setElementType(ext.getTypeQName(), elem, hold);
                } else {
                    this.addDocumentation(info, elem);
                    elem.setTypeDefinition(this.buildComplexType(detail, hold));
                }
            }
            hold.getSchema().getTopLevelChildren().add(elem);
        }
    }

    public ArrayList buildSchemas(List bindings) {
        boolean error;
        this.m_detailDirectory.populate(bindings);
        Collection simples = this.m_detailDirectory.getSimpleDetails();
        Iterator iter = simples.iterator();
        while (iter.hasNext()) {
            EnumDetail detail = (EnumDetail)iter.next();
            if (!detail.isGlobal()) continue;
            ClassCustom custom = detail.getCustom();
            SimpleTypeElement type = this.buildSimpleType(custom.getClassInformation());
            type.setName(custom.getTypeName());
            SchemaHolder hold = this.findSchema(custom.getNamespace());
            hold.getSchema().getTopLevelChildren().add(type);
            this.m_classSimpletypes.put(custom.getName(), custom.getTypeQName());
        }
        Collection mappings = this.m_detailDirectory.getComplexDetails();
        Iterator iter2 = mappings.iterator();
        while (iter2.hasNext()) {
            MappingDetail detail = (MappingDetail)iter2.next();
            this.addMapping(detail);
        }
        ArrayList probs = this.m_context.getProblems();
        boolean bl = error = this.m_context.getErrorCount() > 0 || this.m_context.getFatalCount() > 0;
        if (probs.size() > 0) {
            System.out.print(error ? "Errors" : "Warnings");
            System.out.println(" in binding:");
            for (int j = 0; j < probs.size(); ++j) {
                org.jibx.binding.model.ValidationProblem prob = (org.jibx.binding.model.ValidationProblem)probs.get(j);
                System.out.print(prob.getSeverity() >= 1 ? "Error: " : "Warning: ");
                System.out.println(prob.getDescription());
            }
            if (error) {
                throw new RuntimeException("Errors found in bindings");
            }
        }
        return new ArrayList(this.m_uriSchemas.values());
    }

    public ArrayList finishSchemas(Collection exists) {
        ArrayList holders = new ArrayList(this.m_uriSchemas.values());
        SchemaElement[] schemas = new SchemaElement[holders.size()];
        for (int i = 0; i < holders.size(); ++i) {
            SchemaHolder hold = (SchemaHolder)holders.get(i);
            hold.finish();
            schemas[i] = hold.getSchema();
        }
        ValidationContext vctx = new ValidationContext();
        for (int i = 0; i < holders.size(); ++i) {
            SchemaHolder holder = (SchemaHolder)holders.get(i);
            String id = holder.getFileName();
            SchemaElement schema = holder.getSchema();
            schema.setResolver(new MemoryResolver(id));
            vctx.setSchema(id, schema);
        }
        Iterator iter = exists.iterator();
        while (iter.hasNext()) {
            SchemaElement schema = (SchemaElement)iter.next();
            vctx.setSchema(schema.getResolver().getName(), schema);
        }
        ValidationUtils.validateSchemas(schemas, vctx);
        ArrayList probs = vctx.getProblems();
        if (probs.size() > 0) {
            for (int j = 0; j < probs.size(); ++j) {
                ValidationProblem prob = (ValidationProblem)probs.get(j);
                System.out.print(prob.getSeverity() >= 2 ? "Error: " : "Warning: ");
                System.out.println(prob.getDescription());
            }
            if (vctx.getErrorCount() > 0 || vctx.getFatalCount() > 0) {
                throw new RuntimeException("Errors found in generated schemas");
            }
        }
        return holders;
    }

    public List generate(List bindings) {
        this.buildSchemas(bindings);
        return this.finishSchemas(Collections.EMPTY_LIST);
    }

    public MappingDetail getMappingDetail(MappingElement map) {
        return this.m_detailDirectory.forceMappingDetail(map);
    }

    public static void writeSchemas(File dir, Collection schemas) throws JiBXException, IOException {
        IBindingFactory fact = BindingDirectory.getFactory("schema_xsprefix_binding", class$org$jibx$schema$elements$SchemaElement == null ? (class$org$jibx$schema$elements$SchemaElement = SchemaGen.class$("org.jibx.schema.elements.SchemaElement")) : class$org$jibx$schema$elements$SchemaElement);
        Iterator iter = schemas.iterator();
        while (iter.hasNext()) {
            SchemaHolder holder = (SchemaHolder)iter.next();
            if (holder.isExistingFile()) continue;
            IMarshallingContext ictx = fact.createMarshallingContext();
            File file = new File(dir, holder.getFileName());
            ictx.setOutput(new FileOutputStream(file), null);
            ictx.setIndent(2);
            holder.getSchema().marshal(ictx);
            ictx.getXmlWriter().flush();
        }
    }

    public static void main(String[] args) throws JiBXException, IOException {
        SchemaGenCommandLine parms = new SchemaGenCommandLine();
        if (args.length > 0 && parms.processArgs(args)) {
            boolean valid = true;
            List binddefs = parms.getExtraArgs();
            ArrayList<BindingElement> bindings = new ArrayList<BindingElement>(binddefs.size());
            Iterator iter = binddefs.iterator();
            while (iter.hasNext()) {
                String bpath = (String)iter.next();
                String name = Utility.fileName(bpath);
                File file = new File(bpath);
                try {
                    URL url = new URL("file://" + file.getAbsolutePath());
                    FileInputStream is = new FileInputStream(file);
                    try {
                        org.jibx.binding.model.ValidationContext vctx = new org.jibx.binding.model.ValidationContext(parms.getLocator());
                        BindingElement binding = BindingElement.validateBinding(name, url, is, vctx);
                        if (vctx.getErrorCount() == 0 && vctx.getFatalCount() == 0) {
                            bindings.add(binding);
                            continue;
                        }
                        valid = false;
                    }
                    catch (JiBXException e) {
                        System.err.println("Unable to process binding " + name);
                        e.printStackTrace();
                        valid = false;
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    valid = false;
                }
            }
            if (valid) {
                SchemaGen gen = new SchemaGen(parms.getLocator(), parms.getGlobal(), parms.getUriNames());
                List schemas = gen.generate(bindings);
                SchemaGen.writeSchemas(parms.getGeneratePath(), schemas);
            }
        } else {
            if (args.length > 0) {
                System.err.println("Terminating due to command line errors");
            } else {
                parms.printUsage();
            }
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

