/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.types;

import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;

public class Count {
    public static final Count COUNT_ZERO = new Count(0, false);
    public static final Count COUNT_ONE = new Count(1, false);
    public static final Count COUNT_UNBOUNDED = new Count(0, true);
    private final int m_count;
    private final boolean m_unbounded;

    private Count(int count, boolean unbounded) {
        this.m_count = count;
        this.m_unbounded = unbounded;
    }

    public int getCount() {
        if (this.m_unbounded) {
            throw new IllegalStateException("Cannot get count for unbounded value");
        }
        return this.m_count;
    }

    public boolean isUnbounded() {
        return this.m_unbounded;
    }

    public boolean isEqual(int value) {
        return !this.m_unbounded && this.m_count == value;
    }

    public boolean isGreaterThan(int value) {
        return this.m_unbounded || this.m_count > value;
    }

    public static Count getBoundedCount(String value) throws JiBXException {
        if (value == null) {
            return null;
        }
        if ("0".equals(value = value.trim())) {
            return COUNT_ZERO;
        }
        if ("1".equals(value)) {
            return COUNT_ONE;
        }
        return new Count(Utility.parseInt(value), false);
    }

    public static Count getCount(String value) throws JiBXException {
        if ("unbounded".equals(value)) {
            return COUNT_UNBOUNDED;
        }
        return Count.getBoundedCount(value);
    }

    public static boolean isCountEqual(int value, Count count) {
        if (count == null) {
            return value == 1;
        }
        return count.isEqual(value);
    }

    public String toString() {
        if (this.m_unbounded) {
            return "unbounded";
        }
        return Utility.serializeInt(this.m_count);
    }
}

