/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.validation;

import org.jibx.runtime.ITrackSource;
import org.jibx.runtime.ValidationException;
import org.jibx.schema.INamed;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.schema.validation.ProblemLocation;

public class ValidationProblem {
    public static final int UNIMPLEMENTED_LEVEL = 0;
    public static final int WARNING_LEVEL = 1;
    public static final int ERROR_LEVEL = 2;
    public static final int FATAL_LEVEL = 3;
    private final int m_severity;
    private final String m_description;
    private final Object m_component;

    ValidationProblem(int level, String msg, Object obj) {
        this.m_severity = level;
        this.m_description = obj == null ? msg : msg + " for " + ValidationProblem.componentDescription(obj);
        this.m_component = obj;
    }

    public static String componentDescription(Object obj) {
        StringBuffer buff = new StringBuffer();
        if (obj instanceof SchemaBase) {
            String name;
            buff.append(((SchemaBase)obj).name());
            if (obj instanceof INamed && (name = ((INamed)obj).getName()) != null) {
                buff.append(" '");
                buff.append(name);
                buff.append('\'');
            }
        } else if (obj instanceof ProblemLocation) {
            buff.append(((ProblemLocation)obj).getName());
            buff.append(" element");
        } else {
            String cname = obj.getClass().getName();
            int split = cname.lastIndexOf(46);
            if (split >= 0) {
                cname = cname.substring(split + 1);
            }
            buff.append(cname);
        }
        if (obj instanceof ITrackSource) {
            buff.append(" at ");
            buff.append(ValidationException.describe(obj));
        } else {
            buff.append(" at unknown location");
        }
        return buff.toString();
    }

    ValidationProblem(String msg, Object obj) {
        this(2, msg, obj);
    }

    public Object getComponent() {
        return this.m_component;
    }

    public String getDescription() {
        return this.m_description;
    }

    public int getSeverity() {
        return this.m_severity;
    }
}

