/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.validation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jibx.extras.DocumentComparator;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.schema.ISchemaResolver;
import org.jibx.schema.TreeWalker;
import org.jibx.schema.elements.IncludeElement;
import org.jibx.schema.elements.SchemaElement;
import org.jibx.schema.validation.NameMergeVisitor;
import org.jibx.schema.validation.NameRegistrationVisitor;
import org.jibx.schema.validation.PrevalidationVisitor;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.schema.validation.ValidationVisitor;
import org.xmlpull.v1.XmlPullParserException;

public class ValidationUtils {
    private static final Logger s_logger = Logger.getLogger((class$org$jibx$schema$validation$ValidationUtils == null ? (class$org$jibx$schema$validation$ValidationUtils = ValidationUtils.class$("org.jibx.schema.validation.ValidationUtils")) : class$org$jibx$schema$validation$ValidationUtils).getName());
    static /* synthetic */ Class class$org$jibx$schema$validation$ValidationUtils;
    static /* synthetic */ Class class$org$jibx$schema$elements$SchemaElement;

    public static void validateSchemas(SchemaElement[] schemas, ValidationContext vctx) {
        int i;
        Iterator iter = vctx.iterateSchemas();
        while (iter.hasNext()) {
            ((SchemaElement)iter.next()).getRegister().reset();
        }
        TreeWalker wlkr = new TreeWalker(vctx, vctx);
        s_logger.debug("Beginning schema prevalidation pass");
        vctx.clearTraversed();
        s_logger.debug("Beginning schema prevalidation pass");
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], new PrevalidationVisitor(vctx));
            s_logger.debug("After prevalidation schema " + schemas[i].getResolver().getName() + " has effective namespace " + schemas[i].getEffectiveNamespace());
        }
        s_logger.debug("Beginning name registration pass");
        vctx.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], new NameRegistrationVisitor(vctx));
        }
        s_logger.debug("Beginning name merge pass");
        vctx.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], new NameMergeVisitor(vctx));
        }
        s_logger.debug("Beginning validation pass");
        vctx.clearTraversed();
        for (i = 0; i < schemas.length; ++i) {
            wlkr.walkSchema(schemas[i], new ValidationVisitor(vctx));
            s_logger.debug("After validation schema " + schemas[i].getResolver().getName() + " has effective namespace " + schemas[i].getEffectiveNamespace());
        }
    }

    public static SchemaElement[] load(Collection resolves, String uri, ValidationContext vctx) throws JiBXException, IOException {
        SchemaElement schema;
        IBindingFactory factory = BindingDirectory.getFactory("schema_xsprefix_binding", class$org$jibx$schema$elements$SchemaElement == null ? (class$org$jibx$schema$elements$SchemaElement = ValidationUtils.class$("org.jibx.schema.elements.SchemaElement")) : class$org$jibx$schema$elements$SchemaElement);
        IUnmarshallingContext ictx = factory.createUnmarshallingContext();
        int count = resolves.size();
        int offset = 0;
        SchemaElement[] schemas = new SchemaElement[count];
        Iterator iter = resolves.iterator();
        while (iter.hasNext()) {
            ISchemaResolver resolver = (ISchemaResolver)iter.next();
            ictx.setDocument(resolver.getContent(), resolver.getName(), null);
            ictx.setUserContext(vctx);
            schema = new SchemaElement();
            ((IUnmarshallable)schema).unmarshal(ictx);
            schemas[offset++] = schema;
            schema.setResolver(resolver);
            String id = resolver.getId();
            vctx.setSchema(id, schema);
            if (!s_logger.isDebugEnabled()) continue;
            try {
                String enc = ((UnmarshallingContext)ictx).getInputEncoding();
                if (enc == null) {
                    enc = "UTF-8";
                }
                IMarshallingContext mctx = factory.createMarshallingContext();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                mctx.setIndent(2);
                mctx.marshalDocument((Object)schema, "UTF-8", null, bos);
                InputStreamReader brdr = new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), "UTF-8");
                InputStreamReader frdr = new InputStreamReader(resolver.getContent(), enc);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintStream pstream = new PrintStream(baos);
                DocumentComparator comp = new DocumentComparator(pstream);
                if (comp.compare(frdr, brdr)) {
                    s_logger.debug("Successfully roundtripped schema " + id);
                    continue;
                }
                s_logger.debug("Errors in roundtripping schema " + id);
                pstream.flush();
                s_logger.debug(baos.toString());
            }
            catch (XmlPullParserException e) {
                s_logger.debug("Error during schema roundtripping", e);
            }
        }
        ArrayList<SchemaElement> ordereds = new ArrayList<SchemaElement>();
        vctx.clearTraversed();
        for (int i = 0; i < count; ++i) {
            schema = schemas[i];
            if (schema.getTargetNamespace() == null) continue;
            ordereds.add(schema);
        }
        if (ordereds.size() == 0 && uri != null) {
            SchemaElement schema2 = new SchemaElement();
            schema2.setTargetNamespace(uri);
            SyntheticSchemaResolver resolver = new SyntheticSchemaResolver();
            for (int i = 0; i < count; ++i) {
                SchemaElement inclschema = schemas[i];
                inclschema.setEffectiveNamespace(uri);
                IncludeElement include = new IncludeElement();
                ISchemaResolver inclresolver = inclschema.getResolver();
                include.setLocation(inclresolver.getId());
                resolver.addResolver(inclresolver);
                schema2.getSchemaChildren().add(include);
            }
            schema2.setResolver(resolver);
            ordereds.add(schema2);
        }
        for (int i = 0; i < count; ++i) {
            schema = schemas[i];
            if (schema.getTargetNamespace() != null) continue;
            ordereds.add(schema);
        }
        SchemaElement[] ordschemas = ordereds.toArray(new SchemaElement[ordereds.size()]);
        ValidationUtils.validateSchemas(ordschemas, vctx);
        return ordschemas;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SyntheticSchemaResolver
    implements ISchemaResolver {
        private final Map m_locResolver = new HashMap();

        private SyntheticSchemaResolver() {
        }

        public void addResolver(ISchemaResolver resolver) {
            this.m_locResolver.put(resolver.getId(), resolver);
        }

        public InputStream getContent() throws IOException {
            throw new IOException("Source not available");
        }

        public String getName() {
            return "synthetic";
        }

        public String getId() {
            return "synthetic";
        }

        public ISchemaResolver resolve(String loc, String tns) throws IOException {
            return (ISchemaResolver)this.m_locResolver.get(loc);
        }
    }
}

