/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jibx.binding.model.EmptyArrayList;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.IXMLWriter;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.impl.GrowableIntArray;
import org.jibx.runtime.impl.GrowableStringArray;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.schema.validation.ValidationContext;
import org.jibx.util.StringArray;
import org.jibx.util.StringIntSizedMap;
import org.jibx.util.StringSizedSet;

public abstract class WsdlBase {
    public static final String WSDL_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/";
    public static final String SOAP_NAMESPACE_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    private Object m_extension;
    private List m_namespaces;
    private List m_documentation;

    public Object getExtension() {
        return this.m_extension;
    }

    public void setExtension(Object extension) {
        this.m_extension = extension;
    }

    public final List getNamespaceDeclarations() {
        if (this.m_namespaces == null || this.m_namespaces.size() == 0) {
            return EmptyArrayList.INSTANCE;
        }
        return this.m_namespaces;
    }

    public final void clearNamespaceDeclarations() {
        if (this.m_namespaces != null) {
            this.m_namespaces.clear();
        }
    }

    public final void addNamespaceDeclaration(String prefix, String uri) {
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
        }
        this.m_namespaces.add(prefix);
        this.m_namespaces.add(uri);
    }

    public List getDocumentation() {
        return this.m_documentation;
    }

    public void setDocumentation(List documentation) {
        this.m_documentation = documentation;
    }

    protected void preget(IMarshallingContext ictx) throws JiBXException {
        this.writeNamespaces(ictx);
    }

    protected void preset(IUnmarshallingContext ictx) throws JiBXException {
        this.readNamespaces(ictx);
    }

    protected void validateAttributes(IUnmarshallingContext ictx, boolean other, StringArray attrs) {
        UnmarshallingContext uctx = (UnmarshallingContext)ictx;
        for (int i = 0; i < uctx.getAttributeCount(); ++i) {
            ValidationContext vctx;
            String name = uctx.getAttributeName(i);
            String ns = uctx.getAttributeNamespace(i);
            if (ns == null || ns.length() == 0) {
                if (attrs.indexOf(name) >= 0) continue;
                vctx = (ValidationContext)ictx.getUserContext();
                vctx.addError("Undefined attribute " + name, ictx.getStackTop());
                continue;
            }
            if (WSDL_NAMESPACE_URI.equals(ns)) {
                vctx = (ValidationContext)ictx.getUserContext();
                vctx.addError("Undefined attribute " + name, ictx.getStackTop());
                continue;
            }
            if (other) continue;
            vctx = (ValidationContext)ictx.getUserContext();
            String qname = UnmarshallingContext.buildNameString(ns, name);
            vctx.addWarning("Non-WSDL attribute not allowed " + qname, ictx.getStackTop());
        }
    }

    protected void readNamespaces(IUnmarshallingContext ictx) {
        UnmarshallingContext ctx = (UnmarshallingContext)ictx;
        int count = ctx.getNamespaceCount();
        if (count > 0) {
            this.m_namespaces = new ArrayList();
            for (int i = 0; i < count; ++i) {
                String pref = ctx.getNamespacePrefix(i);
                if (pref == null) {
                    pref = "";
                }
                this.m_namespaces.add(pref);
                this.m_namespaces.add(ctx.getNamespaceUri(i));
            }
        } else {
            this.m_namespaces = null;
        }
    }

    private String makeUniquePrefix(String pref, StringSizedSet prefixes) {
        int loop = 0;
        while (prefixes.contains(pref)) {
            pref = pref + loop;
        }
        prefixes.add(pref);
        return pref;
    }

    protected void writeNamespaces(IMarshallingContext ictx) throws JiBXException {
        if (this.m_namespaces != null) {
            try {
                int i;
                IXMLWriter writer = ictx.getXmlWriter();
                int curcnt = writer.getNamespaceCount();
                StringIntSizedMap uriindexes = new StringIntSizedMap(curcnt);
                int defcnt = this.m_namespaces.size() / 2;
                StringSizedSet prefixes = new StringSizedSet(curcnt + defcnt);
                for (int i2 = 0; i2 < curcnt; ++i2) {
                    uriindexes.add(writer.getNamespaceUri(i2), i2);
                    String prefix = writer.getNamespacePrefix(i2);
                    if (prefix == null || prefix.length() <= 0) continue;
                    prefixes.add(prefix);
                }
                ArrayList<String> uris = new ArrayList<String>();
                GrowableIntArray indexes = new GrowableIntArray();
                GrowableStringArray prefs = new GrowableStringArray();
                int base = writer.getNamespaceCount();
                for (i = 0; i < defcnt; ++i) {
                    String pref = (String)this.m_namespaces.get(i * 2);
                    String uri = (String)this.m_namespaces.get(i * 2 + 1);
                    int index = uriindexes.get(uri);
                    if (index >= 0) {
                        if (writer.getNamespacePrefix(index) != null) continue;
                        indexes.add(index);
                        prefs.add(this.makeUniquePrefix(pref, prefixes));
                        continue;
                    }
                    indexes.add(base + uris.size());
                    prefs.add(this.makeUniquePrefix(pref, prefixes));
                    uris.add(uri);
                }
                writer.pushExtensionNamespaces(uris.toArray(new String[uris.size()]));
                writer.openNamespaces(indexes.toArray(), prefs.toArray());
                for (i = 0; i < prefs.size(); ++i) {
                    String prefix = prefs.get(i);
                    String name = prefix.length() > 0 ? "xmlns:" + prefix : "xmlns";
                    writer.addAttribute(0, name, writer.getNamespaceUri(indexes.get(i)));
                }
            }
            catch (IOException e) {
                throw new JiBXException("Error writing output document", e);
            }
        }
    }

    public void prevalidate(ValidationContext vctx) {
    }

    public void validate(ValidationContext vctx) {
    }
}

