/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.ws.wsdl.tools.custom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jibx.custom.CustomUtils;
import org.jibx.custom.classes.CustomBase;
import org.jibx.custom.classes.IDocumentFormatter;
import org.jibx.custom.classes.JiBX_class_customs_bindingMungeAdapter;
import org.jibx.custom.classes.SharedNestingBase;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.UnmarshallingContext;
import org.jibx.util.IClass;
import org.jibx.util.IClassItem;
import org.jibx.util.IClassLocator;
import org.jibx.util.StringArray;
import org.jibx.ws.wsdl.tools.SignatureParser;
import org.jibx.ws.wsdl.tools.custom.NestingBase;
import org.jibx.ws.wsdl.tools.custom.ThrowsCustom;
import org.jibx.ws.wsdl.tools.custom.ValueCustom;

public class OperationCustom
extends NestingBase
implements ITrackSourceImpl {
    private static final Logger s_logger = Logger.getLogger((class$org$jibx$ws$wsdl$tools$custom$OperationCustom == null ? (class$org$jibx$ws$wsdl$tools$custom$OperationCustom = OperationCustom.class$("org.jibx.ws.wsdl.tools.custom.OperationCustom")) : class$org$jibx$ws$wsdl$tools$custom$OperationCustom).getName());
    public static final StringArray s_allowedAttributes = new StringArray(new String[]{"method-name", "operation-name", "optionals", "request-message", "request-wrapper", "requireds", "response-message", "response-wrapper", "soap-action"}, SharedNestingBase.s_allowedAttributes);
    private String m_methodName;
    private String m_operationName;
    private String m_requestMessageName;
    private String m_requestWrapperName;
    private String m_responseMessageName;
    private String m_responseWrapperName;
    private String m_soapAction;
    private List m_documentation;
    private String[] m_requireds;
    private String[] m_optionals;
    private final ArrayList m_parameters;
    private ValueCustom m_return;
    private final ArrayList m_throws;
    static /* synthetic */ Class class$org$jibx$ws$wsdl$tools$custom$OperationCustom;
    private /* synthetic */ String jibx_sourceDocument;
    private /* synthetic */ int jibx_sourceLine;
    private /* synthetic */ int jibx_sourceColumn;

    OperationCustom(NestingBase parent, String name) {
        super(parent);
        this.m_methodName = name;
        this.m_parameters = new ArrayList();
        this.m_throws = new ArrayList();
    }

    public String getWsdlNamespace() {
        return ((NestingBase)this.getParent()).getWsdlNamespace();
    }

    public String getMethodName() {
        return this.m_methodName;
    }

    public String getOperationName() {
        return this.m_operationName;
    }

    public String getRequestMessageName() {
        return this.m_requestMessageName;
    }

    public String getRequestWrapperName() {
        return this.m_requestWrapperName;
    }

    public String getResponseMessageName() {
        return this.m_responseMessageName;
    }

    public String getResponseWrapperName() {
        return this.m_responseWrapperName;
    }

    public ValueCustom getReturn() {
        return this.m_return;
    }

    public String getSoapAction() {
        return this.m_soapAction;
    }

    public List getDocumentation() {
        return this.m_documentation;
    }

    public ArrayList getParameters() {
        return this.m_parameters;
    }

    public ArrayList getThrows() {
        return this.m_throws;
    }

    protected void addChild(CustomBase child) {
        if (child.getParent() != this) {
            throw new IllegalStateException("Internal error: child not linked");
        }
        this.m_parameters.add(child);
    }

    static OperationCustom factory(IUnmarshallingContext ictx) throws JiBXException {
        String mname = ((UnmarshallingContext)ictx).attributeText(null, "method-name");
        s_logger.debug("Creating operation for operation name " + mname);
        return new OperationCustom((NestingBase)OperationCustom.getContainingObject(ictx), mname);
    }

    private boolean isCollection(String type, IClassLocator icl) {
        IClass info = icl.getRequiredClassInfo(type);
        return info.isImplements("Ljava/util/Collection;");
    }

    private String parameterType(SignatureParser parse) {
        String itype = null;
        while (parse.next() != 5) {
            if (itype != null || parse.getEvent() != 1) continue;
            itype = parse.getType();
        }
        return itype;
    }

    private static Boolean checkRequired(String name, Set reqset, Set optset) {
        if (reqset != null && reqset.contains(name)) {
            return Boolean.TRUE;
        }
        if (optset != null && optset.contains(name)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public void apply(IClassItem method, IClassLocator icl, IDocumentFormatter fmt) {
        List docs;
        s_logger.debug("Applying operation from method " + this.m_methodName);
        if (this.m_operationName == null) {
            String name = OperationCustom.convertName(this.m_methodName, 0);
            this.m_operationName = this.registerName(name, this);
            s_logger.debug("Set operation name " + this.m_operationName);
        } else if (!this.m_operationName.equals(this.registerName(this.m_operationName, this))) {
            throw new IllegalStateException("Operation name conflict for '" + this.m_operationName + '\'');
        }
        if (this.m_requestMessageName == null) {
            this.m_requestMessageName = this.m_operationName + "Message";
        }
        if (this.m_requestWrapperName == null) {
            this.m_requestWrapperName = this.m_operationName;
        }
        if (this.m_responseMessageName == null) {
            this.m_responseMessageName = this.m_operationName + "ResponseMessage";
        }
        if (this.m_responseWrapperName == null) {
            this.m_responseWrapperName = this.m_operationName + "Response";
        }
        if (this.m_soapAction == null && this.isSoapAction()) {
            this.m_soapAction = "urn:" + this.m_operationName;
        }
        if (this.m_documentation == null) {
            this.m_documentation = fmt.docToNodes(method.getJavaDoc());
        }
        int count = method.getArgumentCount();
        String[] ptypes = new String[count];
        String[] pitypes = new String[count];
        String rtype = null;
        String ritype = null;
        String sig = method.getGenericsSignature();
        if (sig == null) {
            for (int i = 0; i < count; ++i) {
                String type;
                ptypes[i] = type = method.getArgumentType(i);
                if (!this.isCollection(type, icl)) continue;
                pitypes[i] = "java.lang.Object";
            }
            rtype = method.getTypeName();
            if (this.isCollection(rtype, icl)) {
                ritype = "java.lang.Object";
            }
        } else {
            SignatureParser parse = new SignatureParser(sig);
            int index = 0;
            boolean inparms = false;
            while (parse.next() != 0) {
                switch (parse.getEvent()) {
                    case 2: {
                        inparms = true;
                        index = 0;
                        break;
                    }
                    case 3: {
                        inparms = false;
                        break;
                    }
                    case 1: {
                        String type = parse.getType();
                        String itype = null;
                        if (parse.isParameterized()) {
                            String ptype = this.parameterType(parse);
                            IClass info = icl.getRequiredClassInfo(type);
                            if (info.isImplements("Ljava/util/Collection;")) {
                                itype = ptype;
                            }
                        }
                        if (inparms) {
                            ptypes[index] = type;
                            pitypes[index++] = itype;
                            break;
                        }
                        rtype = type;
                        ritype = itype;
                    }
                }
            }
        }
        HashMap<String, ValueCustom> namevalue = new HashMap<String, ValueCustom>();
        for (int i = 0; i < this.m_parameters.size(); ++i) {
            ValueCustom value = (ValueCustom)this.m_parameters.get(i);
            namevalue.put(value.getBaseName(), value);
        }
        this.m_parameters.clear();
        Set reqset = CustomUtils.noCaseNameSet(this.m_requireds);
        Set optset = CustomUtils.noCaseNameSet(this.m_optionals);
        for (int i = 0; i < count; ++i) {
            ValueCustom value;
            String name = method.getParameterName(i);
            if (name == null) {
                name = "arg" + (i + 1);
            }
            if ((value = (ValueCustom)namevalue.get(name)) == null) {
                value = new ValueCustom(this, name);
                s_logger.debug("Added customization for parameter " + name + " with type " + pitypes[i]);
            } else {
                s_logger.debug("Found customization for parameter " + name + " with type " + pitypes[i]);
            }
            this.m_parameters.add(value);
            Boolean req = OperationCustom.checkRequired(name, reqset, optset);
            docs = fmt.docToNodes(method.getParameterJavaDoc(i));
            value.complete(icl.getRequiredClassInfo(ptypes[i]), docs, req, pitypes[i]);
        }
        Boolean req = OperationCustom.checkRequired("return", reqset, optset);
        String text = method.getReturnJavaDoc();
        boolean isname = false;
        if (text != null && Character.isJavaIdentifierStart(text.charAt(0))) {
            isname = true;
            for (int i = 1; i < text.length(); ++i) {
                if (Character.isJavaIdentifierPart(text.charAt(i))) continue;
                isname = false;
                break;
            }
        }
        String name = "return";
        if (isname) {
            name = text;
            text = null;
        }
        docs = fmt.docToNodes(text);
        if (this.m_return == null) {
            this.m_return = new ValueCustom(this, name);
        }
        this.m_return.complete(icl.getRequiredClassInfo(rtype), docs, req, ritype);
        count = method.getExceptions().length;
        if (this.m_throws.size() == 0) {
            for (int i = 0; i < count; ++i) {
                name = method.getExceptions()[i];
                ThrowsCustom thrw = new ThrowsCustom(this, name);
                thrw.complete(fmt.docToNodes(method.getExceptionJavaDoc(i)));
                this.m_throws.add(thrw);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public /* synthetic */ void jibx_setSource(String arg1, int arg2, int arg3) {
        this.jibx_sourceDocument = arg1;
        this.jibx_sourceLine = arg2;
        this.jibx_sourceColumn = arg3;
    }

    public /* synthetic */ String jibx_getDocumentName() {
        return this.jibx_sourceDocument;
    }

    public /* synthetic */ int jibx_getLineNumber() {
        return this.jibx_sourceLine;
    }

    public /* synthetic */ int jibx_getColumnNumber() {
        return this.jibx_sourceColumn;
    }

    public static /* synthetic */ OperationCustom JiBX_wsdlgen_customs_binding_newinstance_4_0(OperationCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        if (arg1 == null) {
            arg1 = OperationCustom.factory(arg2);
        }
        return arg1;
    }

    public static /* synthetic */ OperationCustom JiBX_wsdlgen_customs_binding_unmarshalAttr_4_0(OperationCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushTrackedObject(arg1);
        OperationCustom operationCustom = arg1;
        arg1.m_methodName = arg2.attributeText(null, "method-name");
        arg1.m_operationName = arg2.attributeText(null, "operation-name", null);
        String string = arg2.attributeText(null, "optionals", null);
        arg1.m_optionals = string == null ? null : Utility.deserializeTokenList(string);
        arg1.m_requestMessageName = arg2.attributeText(null, "request-message", null);
        arg1.m_requestWrapperName = arg2.attributeText(null, "request-wrapper", null);
        String string2 = arg2.attributeText(null, "requireds", null);
        arg1.m_requireds = string2 == null ? null : Utility.deserializeTokenList(string2);
        arg1.m_responseMessageName = arg2.attributeText(null, "response-message", null);
        arg1.m_responseWrapperName = arg2.attributeText(null, "response-wrapper", null);
        arg1.m_soapAction = arg2.attributeText(null, "soap-action", null);
        arg2.popObject();
        return arg1;
    }

    public static /* synthetic */ OperationCustom JiBX_wsdlgen_customs_binding_unmarshal_4_0(OperationCustom arg1, UnmarshallingContext arg2) throws JiBXException {
        arg2.pushObject(arg1);
        OperationCustom operationCustom = arg1;
        arg1.m_parameters = JiBX_class_customs_bindingMungeAdapter.JiBX_wsdlgen_customs_binding_unmarshal_1_70(JiBX_class_customs_bindingMungeAdapter.JiBX_class_customs_binding_newinstance_1_0(arg1.m_parameters, arg2), arg2);
        if (arg2.isAt(null, "return")) {
            arg2.parseToStartTag(null, "return");
            arg1.m_return = ValueCustom.JiBX_wsdlgen_customs_binding_unmarshalAttr_3_0(ValueCustom.JiBX_wsdlgen_customs_binding_newinstance_3_1(arg1.m_return, arg2), arg2);
            arg2.parsePastStartTag(null, "return");
            arg2.parsePastCurrentEndTag(null, "return");
        } else {
            arg1.m_return = null;
        }
        arg1.m_throws = JiBX_class_customs_bindingMungeAdapter.JiBX_wsdlgen_customs_binding_unmarshal_1_71(JiBX_class_customs_bindingMungeAdapter.JiBX_class_customs_binding_newinstance_1_0(arg1.m_throws, arg2), arg2);
        arg2.popObject();
        return arg1;
    }
}

