/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.util.Assert;

class ContextCache {
    private final Map<MergedContextConfiguration, ApplicationContext> contextMap = new ConcurrentHashMap<MergedContextConfiguration, ApplicationContext>();
    private int hitCount;
    private int missCount;

    ContextCache() {
    }

    void clear() {
        this.contextMap.clear();
    }

    void clearStatistics() {
        this.hitCount = 0;
        this.missCount = 0;
    }

    boolean contains(MergedContextConfiguration key) {
        Assert.notNull(key, "Key must not be null");
        return this.contextMap.containsKey(key);
    }

    ApplicationContext get(MergedContextConfiguration key) {
        Assert.notNull(key, "Key must not be null");
        ApplicationContext context = this.contextMap.get(key);
        if (context == null) {
            this.incrementMissCount();
        } else {
            this.incrementHitCount();
        }
        return context;
    }

    private void incrementHitCount() {
        ++this.hitCount;
    }

    private void incrementMissCount() {
        ++this.missCount;
    }

    int getHitCount() {
        return this.hitCount;
    }

    int getMissCount() {
        return this.missCount;
    }

    void put(MergedContextConfiguration key, ApplicationContext context) {
        Assert.notNull(key, "Key must not be null");
        Assert.notNull(context, "ApplicationContext must not be null");
        this.contextMap.put(key, context);
    }

    ApplicationContext remove(MergedContextConfiguration key) {
        return this.contextMap.remove(key);
    }

    void setDirty(MergedContextConfiguration key) {
        Assert.notNull(key, "Key must not be null");
        ApplicationContext context = this.remove(key);
        if (context instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)context).close();
        }
    }

    int size() {
        return this.contextMap.size();
    }

    public String toString() {
        return new ToStringCreator(this).append("size", this.size()).append("hitCount", this.getHitCount()).append("missCount", this.getMissCount()).toString();
    }
}

