/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextLoader;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.SmartContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ContextLoaderUtils {
    private static final Log logger = LogFactory.getLog(ContextLoaderUtils.class);
    private static final String DEFAULT_CONTEXT_LOADER_CLASS_NAME = "org.springframework.test.context.support.DelegatingSmartContextLoader";

    private ContextLoaderUtils() {
    }

    static ContextLoader resolveContextLoader(Class<?> testClass, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, "Test class must not be null");
        if (!StringUtils.hasText(defaultContextLoaderClassName)) {
            defaultContextLoaderClassName = DEFAULT_CONTEXT_LOADER_CLASS_NAME;
        }
        Class<? extends ContextLoader> contextLoaderClass = ContextLoaderUtils.resolveContextLoaderClass(testClass, defaultContextLoaderClassName);
        return BeanUtils.instantiateClass(contextLoaderClass, ContextLoader.class);
    }

    static Class<? extends ContextLoader> resolveContextLoaderClass(Class<?> testClass, String defaultContextLoaderClassName) {
        Assert.notNull(testClass, "Class must not be null");
        Assert.hasText(defaultContextLoaderClassName, "Default ContextLoader class name must not be null or empty");
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class<?> declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, testClass);
        Assert.notNull(declaringClass, String.format("Could not find an 'annotation declaring class' for annotation type [%s] and test class [%s]", annotationType, testClass));
        while (declaringClass != null) {
            Class<? extends ContextLoader> contextLoaderClass;
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing ContextLoader for @ContextConfiguration [%s] and declaring class [%s]", contextConfiguration, declaringClass));
            }
            if (!ContextLoader.class.equals(contextLoaderClass = contextConfiguration.loader())) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Found explicit ContextLoader class [%s] for @ContextConfiguration [%s] and declaring class [%s]", contextLoaderClass, contextConfiguration, declaringClass));
                }
                return contextLoaderClass;
            }
            declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass());
        }
        try {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Using default ContextLoader class [%s] for test class [%s]", defaultContextLoaderClassName, testClass));
            }
            return ContextLoaderUtils.class.getClassLoader().loadClass(defaultContextLoaderClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Could not load default ContextLoader class [" + defaultContextLoaderClassName + "]. Specify @ContextConfiguration's 'loader' " + "attribute or make the default loader class available.");
        }
    }

    static List<ContextConfigurationAttributes> resolveContextConfigurationAttributes(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        ArrayList<ContextConfigurationAttributes> attributesList = new ArrayList<ContextConfigurationAttributes>();
        Class<ContextConfiguration> annotationType = ContextConfiguration.class;
        Class<?> declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        Assert.notNull(declaringClass, String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        while (declaringClass != null) {
            ContextConfiguration contextConfiguration = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ContextConfiguration [%s] for declaring class [%s].", contextConfiguration, declaringClass));
            }
            ContextConfigurationAttributes attributes = new ContextConfigurationAttributes(declaringClass, contextConfiguration);
            if (logger.isTraceEnabled()) {
                logger.trace("Resolved context configuration attributes: " + attributes);
            }
            attributesList.add(0, attributes);
            Class<?> clazz2 = declaringClass = contextConfiguration.inheritLocations() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return attributesList;
    }

    static String[] resolveActiveProfiles(Class<?> clazz) {
        Assert.notNull(clazz, "Class must not be null");
        Class<ActiveProfiles> annotationType = ActiveProfiles.class;
        Class<?> declaringClass = AnnotationUtils.findAnnotationDeclaringClass(annotationType, clazz);
        if (declaringClass == null && logger.isDebugEnabled()) {
            logger.debug(String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType, clazz));
        }
        HashSet<String> activeProfiles = new HashSet<String>();
        while (declaringClass != null) {
            ActiveProfiles annotation = declaringClass.getAnnotation(annotationType);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Retrieved @ActiveProfiles [%s] for declaring class [%s].", annotation, declaringClass));
            }
            Object[] profiles = annotation.profiles();
            Object[] valueProfiles = annotation.value();
            if (!ObjectUtils.isEmpty(valueProfiles) && !ObjectUtils.isEmpty(profiles)) {
                String msg = String.format("Test class [%s] has been configured with @ActiveProfiles' 'value' [%s] and 'profiles' [%s] attributes. Only one declaration of active bean definition profiles is permitted per @ActiveProfiles annotation.", declaringClass, ObjectUtils.nullSafeToString(valueProfiles), ObjectUtils.nullSafeToString(profiles));
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            if (!ObjectUtils.isEmpty(valueProfiles)) {
                profiles = valueProfiles;
            }
            Object[] objectArray = profiles;
            int n = profiles.length;
            int n2 = 0;
            while (n2 < n) {
                Object profile = objectArray[n2];
                if (StringUtils.hasText((String)profile)) {
                    activeProfiles.add(((String)profile).trim());
                }
                ++n2;
            }
            Class<?> clazz2 = declaringClass = annotation.inheritProfiles() ? AnnotationUtils.findAnnotationDeclaringClass(annotationType, declaringClass.getSuperclass()) : null;
        }
        return StringUtils.toStringArray(activeProfiles);
    }

    static MergedContextConfiguration buildMergedContextConfiguration(Class<?> testClass, String defaultContextLoaderClassName) {
        ContextLoader contextLoader = ContextLoaderUtils.resolveContextLoader(testClass, defaultContextLoaderClassName);
        List<ContextConfigurationAttributes> configAttributesList = ContextLoaderUtils.resolveContextConfigurationAttributes(testClass);
        ArrayList<String> locationsList = new ArrayList<String>();
        ArrayList classesList = new ArrayList();
        for (ContextConfigurationAttributes configAttributes : configAttributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Processing locations and classes for context configuration attributes [%s]", configAttributes));
            }
            if (contextLoader instanceof SmartContextLoader) {
                SmartContextLoader smartContextLoader = (SmartContextLoader)contextLoader;
                smartContextLoader.processContextConfiguration(configAttributes);
                locationsList.addAll((Collection<String>)Arrays.asList(configAttributes.getLocations()));
                classesList.addAll((Collection)Arrays.asList(configAttributes.getClasses()));
                continue;
            }
            String[] processedLocations = contextLoader.processLocations(configAttributes.getDeclaringClass(), configAttributes.getLocations());
            locationsList.addAll((Collection<String>)Arrays.asList(processedLocations));
        }
        String[] locations = StringUtils.toStringArray(locationsList);
        Class<?>[] classes = ClassUtils.toClassArray(classesList);
        String[] activeProfiles = ContextLoaderUtils.resolveActiveProfiles(testClass);
        return new MergedContextConfiguration(testClass, locations, classes, activeProfiles, contextLoader);
    }
}

