/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.TerminationException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ_SSE;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemWriter;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.List;

public class sse
extends CmdARQ_SSE {
    protected final ArgDecl numberDecl = new ArgDecl(true, "num", "number");
    protected final ArgDecl noPrintDecl = new ArgDecl(false, "n");
    protected final ArgDecl noResolveDecl = new ArgDecl(false, "raw");
    private boolean print = true;
    private boolean structural = true;
    private boolean lineNumbers = false;
    private List filenames;
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new sse(argv).main();
    }

    public sse(String[] argv) {
        super(argv);
        super.add(this.noPrintDecl, "-n", "Don't print the expression");
        super.add(this.numberDecl, "--num [on|off]", "Numbers");
        super.add(this.noResolveDecl, "--raw", "Don't handle base or prefix names specially");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.filenames == null) {
            this.filenames = new ArrayList();
        }
        boolean bl = this.print = !this.contains(this.noPrintDecl);
        if (this.contains(this.numberDecl)) {
            this.lineNumbers = this.getValue(this.numberDecl).equalsIgnoreCase("on");
        }
        if (this.contains(this.noResolveDecl)) {
            SSE.setUseResolver(false);
        }
    }

    protected String getCommandName() {
        return Utils.className(this);
    }

    protected String getSummary() {
        return this.getCommandName();
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec(Item item) {
        if (!this.print) {
            return;
        }
        if (item == null) {
            System.err.println("No expression");
            throw new TerminationException(9);
        }
        this.divider();
        IndentedWriter out = new IndentedWriter(System.out, this.lineNumbers);
        PrefixMapping pmap = null;
        SerializationContext sCxt = new SerializationContext(pmap);
        ItemWriter.write(out, item, sCxt);
        out.ensureStartOfLine();
        out.flush();
    }
}

