/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.ConcurrentMapManager;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.impl.executor.ParallelExecutor;
import com.hazelcast.logging.ILogger;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class LifecycleServiceImpl
implements LifecycleService {
    final FactoryImpl factory;
    final AtomicBoolean paused = new AtomicBoolean(false);
    final CopyOnWriteArrayList<LifecycleListener> lsLifecycleListeners = new CopyOnWriteArrayList();
    final Object lifecycleLock = new Object();

    public LifecycleServiceImpl(FactoryImpl factory) {
        this.factory = factory;
    }

    private ILogger getLogger() {
        return this.factory.node.getLogger(LifecycleServiceImpl.class.getName());
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.add(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lsLifecycleListeners.remove(lifecycleListener);
    }

    public void fireLifecycleEvent(LifecycleEvent.LifecycleState lifecycleState) {
        this.fireLifecycleEvent(new LifecycleEvent(lifecycleState));
    }

    public void fireLifecycleEvent(LifecycleEvent lifecycleEvent) {
        this.getLogger().log(Level.INFO, this.factory.node.getThisAddress() + " is " + (Object)((Object)lifecycleEvent.getState()));
        for (LifecycleListener lifecycleListener : this.lsLifecycleListeners) {
            lifecycleListener.stateChanged(lifecycleEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pause() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (this.paused.get()) {
                return false;
            }
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.PAUSING);
            this.paused.set(true);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.PAUSED);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            if (!this.paused.get()) {
                return false;
            }
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESUMING);
            this.paused.set(false);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESUMED);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            return this.factory.node.isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            FactoryImpl.shutdown(this.factory);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
            FactoryImpl.kill(this.factory);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.SHUTDOWN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        Object object = this.lifecycleLock;
        synchronized (object) {
            ThreadContext.get().setCurrentFactory(this.factory);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESTARTING);
            this.paused.set(true);
            final Node node = this.factory.node;
            final ILogger logger = this.getLogger();
            ArrayList<Record> lsOwnedRecords = new ArrayList<Record>();
            for (CMap cmap : node.concurrentMapManager.getCMaps().values()) {
                if (!cmap.isUserMap()) continue;
                lsOwnedRecords.addAll(cmap.getMapIndexService().getOwnedRecords());
            }
            node.onRestart();
            node.clientHandlerService.restart();
            node.connectionManager.onRestart();
            node.clusterManager.onRestart();
            node.concurrentMapManager.onRestart();
            node.rejoin();
            final CountDownLatch latch = new CountDownLatch(lsOwnedRecords.size());
            ParallelExecutor executor = node.executorManager.newParallelExecutor(16);
            for (final Record ownedRecord : lsOwnedRecords) {
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            ConcurrentMapManager.MPut mput = node.concurrentMapManager.new ConcurrentMapManager.MPut();
                            mput.merge(ownedRecord);
                            ownedRecord.invalidate();
                            latch.countDown();
                        }
                        catch (Exception e2) {
                            logger.log(Level.WARNING, e2.getMessage(), e2);
                        }
                    }
                });
            }
            try {
                latch.await(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            this.paused.set(false);
            this.fireLifecycleEvent(LifecycleEvent.LifecycleState.RESTARTED);
        }
    }
}

