/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.query.EntryObject;
import com.hazelcast.query.Expression;
import com.hazelcast.query.Index;
import com.hazelcast.query.IndexAwarePredicate;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.Predicates;
import com.hazelcast.query.QueryContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateBuilder
implements Predicate,
IndexAwarePredicate {
    Expression exp = null;
    List<Predicate> lsPredicates = new ArrayList<Predicate>();

    public boolean apply(MapEntry mapEntry) {
        return this.lsPredicates.get(0).apply(mapEntry);
    }

    @Override
    public boolean collectIndexAwarePredicates(List<IndexAwarePredicate> lsIndexPredicates, Map<Expression, Index> mapIndexes) {
        boolean strong = true;
        Predicate predicate = this.lsPredicates.get(0);
        if (predicate instanceof IndexAwarePredicate) {
            IndexAwarePredicate p = (IndexAwarePredicate)predicate;
            if (!p.collectIndexAwarePredicates(lsIndexPredicates, mapIndexes)) {
                strong = false;
            }
        } else {
            strong = false;
        }
        return strong;
    }

    @Override
    public boolean isIndexed(QueryContext queryContext) {
        return false;
    }

    @Override
    public Set<MapEntry> filter(QueryContext queryContext) {
        return null;
    }

    @Override
    public void collectAppliedIndexes(Set<Index> setAppliedIndexes, Map<Expression, Index> mapIndexes) {
        Predicate predicate = this.lsPredicates.get(0);
        if (predicate instanceof IndexAwarePredicate) {
            IndexAwarePredicate p = (IndexAwarePredicate)predicate;
            p.collectAppliedIndexes(setAppliedIndexes, mapIndexes);
        }
    }

    public EntryObject getEntryObject() {
        return new EntryObject(this);
    }

    public PredicateBuilder and(Predicate predicate) {
        if (predicate != this) {
            throw new RuntimeException("Illegal and statement expected: " + PredicateBuilder.class.getSimpleName() + ", found: " + (predicate == null ? "null" : predicate.getClass().getSimpleName()));
        }
        int index = this.lsPredicates.size() - 2;
        Predicate first = this.lsPredicates.remove(index);
        Predicate second = this.lsPredicates.remove(index);
        this.lsPredicates.add(Predicates.and(first, second));
        return this;
    }

    public PredicateBuilder or(Predicate predicate) {
        if (predicate != this) {
            throw new RuntimeException("Illegal or statement expected: " + PredicateBuilder.class.getSimpleName() + ", found: " + (predicate == null ? "null" : predicate.getClass().getSimpleName()));
        }
        int index = this.lsPredicates.size() - 2;
        Predicate first = this.lsPredicates.remove(index);
        Predicate second = this.lsPredicates.remove(index);
        this.lsPredicates.add(Predicates.or(first, second));
        return this;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("PredicateBuilder");
        sb.append("{\n");
        sb.append(this.lsPredicates.size() == 0 ? "" : (Serializable)this.lsPredicates.get(0));
        sb.append("\n}");
        return sb.toString();
    }
}

