/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.GraphRDB;
import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.impl.IRDBDriver;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestBasicOperations
extends TestCase {
    ModelRDB model = null;
    IRDBDriver dbDriver = null;
    IDBConnection conn = null;

    public TestBasicOperations(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestBasicOperations.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.model = ModelRDB.createModel(this.conn);
        this.dbDriver = this.conn.getDriver();
    }

    protected void tearDown() throws Exception {
        if (this.model != null) {
            this.model.close();
        }
        this.model = null;
        if (this.conn != null) {
            this.conn.cleanDB();
            this.conn.close();
        }
        this.conn = null;
    }

    private void addRemove(Statement stmt) {
        this.model.add(stmt);
        TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
        this.model.remove(stmt);
        TestBasicOperations.assertTrue((!this.model.contains(stmt) ? (byte)1 : 0) != 0);
        this.model.add(stmt);
        TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
        this.model.remove(stmt);
        TestBasicOperations.assertTrue((!this.model.contains(stmt) ? (byte)1 : 0) != 0);
        this.model.add(stmt);
        this.model.add(stmt);
        TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
        this.model.remove(stmt);
        TestBasicOperations.assertTrue((!this.model.contains(stmt) ? (byte)1 : 0) != 0);
        this.model.add(stmt);
        this.model.add(stmt);
        this.model.add(stmt);
        this.model.add(stmt);
        this.model.add(stmt);
        this.model.add(stmt);
        TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
        this.model.remove(stmt);
        TestBasicOperations.assertTrue((!this.model.contains(stmt) ? (byte)1 : 0) != 0);
    }

    private Statement crAssertedStmt(String subj, String pred, String obj) {
        Resource s = this.model.createResource(subj);
        Property p = this.model.createProperty(pred);
        Resource o = this.model.createResource(obj);
        return this.crAssertedStmt(s, p, o);
    }

    private Statement crAssertedStmt(Resource s, Property p, RDFNode o) {
        Statement stmt = this.model.createStatement(s, p, o);
        this.model.add(stmt);
        return stmt;
    }

    private Resource crReifiedStmt(String node, Statement stmt) {
        Resource n = this.model.createResource(node);
        Resource s = stmt.getSubject();
        Property p = stmt.getPredicate();
        RDFNode o = stmt.getObject();
        this.crAssertedStmt(n, RDF.subject, s);
        this.crAssertedStmt(n, RDF.predicate, p);
        this.crAssertedStmt(n, RDF.object, o);
        this.crAssertedStmt(n, RDF.type, RDF.Statement);
        return n;
    }

    public void testAddRemoveURI() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testAddRemoveLiteral() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral("testLiteral");
        this.addRemove(this.model.createStatement(s, p, l));
    }

    public void testSetLongObjectLenFailure() {
        try {
            int len = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(len / 2);
            TestBasicOperations.assertTrue((boolean)false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testLongObjectLen() {
        Statement stmt;
        Literal l;
        long longLen = this.dbDriver.getLongObjectLength();
        TestBasicOperations.assertTrue((longLen > 0L && longLen < 100000L ? (byte)1 : 0) != 0);
        String base = ".";
        StringBuffer buffer = new StringBuffer(1024 + (int)longLen);
        long minLongLen = longLen - 32L;
        long maxLongLen = longLen + 32L;
        TestBasicOperations.assertTrue((minLongLen > 0L ? (byte)1 : 0) != 0);
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        while ((long)buffer.length() < minLongLen) {
            buffer.append(base);
        }
        long modelSizeBeg = this.model.size();
        while ((long)buffer.length() < maxLongLen) {
            l = this.model.createLiteral(buffer.toString());
            stmt = this.model.createStatement(s, p, l);
            this.model.add(stmt);
            TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
            TestBasicOperations.assertTrue((boolean)stmt.getObject().equals(l));
            buffer.append(base);
        }
        TestBasicOperations.assertTrue((this.model.size() == modelSizeBeg + maxLongLen - minLongLen ? (byte)1 : 0) != 0);
        while ((long)buffer.length() > minLongLen) {
            buffer.deleteCharAt(0);
            l = this.model.createLiteral(buffer.toString());
            stmt = this.model.createStatement(s, p, l);
            TestBasicOperations.assertTrue((boolean)this.model.contains(stmt));
            this.model.remove(stmt);
            TestBasicOperations.assertTrue((!this.model.contains(stmt) ? (byte)1 : 0) != 0);
        }
        TestBasicOperations.assertTrue((this.model.size() == modelSizeBeg ? (byte)1 : 0) != 0);
    }

    public void testSetLongObjectLen() {
        int len = this.dbDriver.getLongObjectLength();
        int len2 = len - 2;
        try {
            this.tearDown();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            len = this.dbDriver.getLongObjectLength();
            this.dbDriver.setLongObjectLength(len2);
            this.model = ModelRDB.createModel(this.conn);
        }
        catch (Exception e2) {
            TestBasicOperations.assertTrue((boolean)false);
        }
        this.testLongObjectLen();
        this.model.close();
        try {
            this.conn.close();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            TestBasicOperations.assertTrue((len == this.dbDriver.getLongObjectLength() ? (byte)1 : 0) != 0);
            this.model = ModelRDB.open(this.conn);
            TestBasicOperations.assertTrue((len2 == this.dbDriver.getLongObjectLength() ? (byte)1 : 0) != 0);
        }
        catch (Exception e3) {
            TestBasicOperations.assertTrue((boolean)false);
        }
    }

    public void testSetLongObjectLenMax() {
        int len;
        int newLen = len = this.dbDriver.getLongObjectLength();
        int lenMax = this.dbDriver.getLongObjectLengthMax();
        int hdrLen = 32;
        try {
            this.tearDown();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            len = this.dbDriver.getLongObjectLength();
            lenMax = this.dbDriver.getLongObjectLengthMax();
            if (len == lenMax) {
                return;
            }
            newLen = lenMax - hdrLen;
            this.dbDriver.setLongObjectLength(newLen);
            this.model = ModelRDB.createModel(this.conn);
        }
        catch (Exception e2) {
            TestBasicOperations.assertTrue((boolean)false);
        }
        this.testLongObjectLen();
        this.model.close();
        try {
            this.conn.close();
            this.conn = TestConnection.makeTestConnection();
            this.dbDriver = this.conn.getDriver();
            TestBasicOperations.assertTrue((len == this.dbDriver.getLongObjectLength() ? (byte)1 : 0) != 0);
            this.model = ModelRDB.open(this.conn);
            TestBasicOperations.assertTrue((newLen == this.dbDriver.getLongObjectLength() ? (byte)1 : 0) != 0);
        }
        catch (Exception e3) {
            TestBasicOperations.assertTrue((boolean)false);
        }
    }

    public void testAddRemoveUTFLiteral() {
        String str2 = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(str2);
        this.addRemove(this.model.createStatement(s, p, l));
    }

    public void testAddRemoveLiteralSpecials() {
        String str2 = "'\"%?*";
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(str2);
        this.addRemove(this.model.createStatement(s, p, l));
    }

    public void testAddRemoveHugeLiteral() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createLiteral(buffer.toString());
        this.addRemove(this.model.createStatement(s, p, l));
    }

    public void testCompressHugeURI() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(true);
        this.model = ModelRDB.createModel(conn);
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        String URI2 = longPfx + ":/www.foo/#bar";
        Resource s = this.model.createResource(URI2);
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testCompressHugeURI1() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(true);
        this.model = ModelRDB.createModel(conn);
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        String URI2 = longPfx + ":/www.foo/#bar" + longPfx;
        Resource s = this.model.createResource(URI2);
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testNoCompressHugeURI() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(false);
        this.model = ModelRDB.createModel(conn);
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        String URI2 = longPfx + ":/www.foo/#bar";
        Resource s = this.model.createResource(URI2);
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testNoCompressHugeURI1() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(false);
        this.model = ModelRDB.createModel(conn);
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        String URI2 = longPfx + ":/www.foo/#bar" + longPfx;
        Resource s = this.model.createResource(URI2);
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testAddRemoveHugeURI() throws Exception {
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        String URI2 = longPfx + ":/www.foo/#bar" + longPfx;
        Resource s = this.model.createResource(URI2);
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource("test#object");
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testPrefixCache() throws Exception {
        Resource o;
        Property p;
        Resource s;
        String URI2;
        int i;
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(true);
        this.model = ModelRDB.createModel(conn);
        int cacheSize = d.getCompressCacheSize();
        cacheSize = 10;
        d.setCompressCacheSize(cacheSize);
        String pfx = "a123456789";
        String longPfx = "";
        long longLen = this.dbDriver.getLongObjectLength();
        while ((long)longPfx.length() < longLen) {
            longPfx = longPfx + pfx;
        }
        for (i = 0; i < cacheSize * 2; ++i) {
            URI2 = longPfx + i + ":/www.foo/#bar";
            s = this.model.createResource(URI2);
            p = this.model.createProperty("test#predicate");
            o = this.model.createResource("test#object");
            this.model.add(s, p, o);
        }
        for (i = 0; i < cacheSize * 2; ++i) {
            URI2 = longPfx + i + ":/www.foo/#bar";
            s = this.model.createResource(URI2);
            p = this.model.createProperty("test#predicate");
            o = this.model.createResource("test#object");
            TestBasicOperations.assertTrue((boolean)this.model.contains(s, p, o));
        }
    }

    public void testPrefixCachePersists() throws Exception {
        IDBConnection conn = TestConnection.makeAndCleanTestConnection();
        IRDBDriver d = conn.getDriver();
        d.setDoCompressURI(true);
        this.model = ModelRDB.createModel(conn);
        int cacheSize = d.getCompressCacheSize();
        d.setCompressCacheSize(cacheSize / 2);
        this.model.close();
        conn.close();
        conn = TestConnection.makeTestConnection();
        d = conn.getDriver();
        try {
            d.setDoCompressURI(false);
            TestBasicOperations.assertFalse((boolean)true);
        }
        catch (Exception e2) {
            this.model = ModelRDB.createModel(conn, "NamedModel");
            TestBasicOperations.assertTrue((d.getDoCompressURI() ? (byte)1 : 0) != 0);
            TestBasicOperations.assertTrue((d.getCompressCacheSize() == cacheSize ? (byte)1 : 0) != 0);
        }
    }

    public void testAddRemoveDatatype() {
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l = this.model.createTypedLiteral("stringType");
        this.addRemove(this.model.createStatement(s, p, l));
    }

    public void testAddRemoveHugeDatatype() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.model.createResource("test#subject");
        Property p = this.model.createProperty("test#predicate");
        Literal l2 = this.model.createTypedLiteral(buffer.toString());
        this.addRemove(this.model.createStatement(s, p, l2));
    }

    public void testAddRemoveBNode() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        this.addRemove(this.model.createStatement(s, p, o));
    }

    public void testBNodeIdentityPreservation() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        Statement spo = this.model.createStatement(s, p, o);
        Statement ops = this.model.createStatement(o, p, s);
        this.model.add(spo);
        this.addRemove(ops);
        TestBasicOperations.assertTrue((boolean)this.model.contains(spo));
        this.model.remove(spo);
    }

    public void testDuplicateCheck() {
        Resource s = this.model.createResource();
        Property p = this.model.createProperty("test#predicate");
        Resource o = this.model.createResource();
        Statement spo = this.model.createStatement(s, p, o);
        this.model.add(spo);
        try {
            this.model.add(spo);
            TestBasicOperations.assertTrue((this.model.size() == 1L ? (byte)1 : 0) != 0);
        }
        catch (Exception e2) {
            TestBasicOperations.assertTrue((boolean)false);
        }
        this.model.setDoDuplicateCheck(false);
        try {
            this.model.add(spo);
            TestBasicOperations.assertTrue((this.model.size() == 2L ? (byte)1 : 0) != 0);
        }
        catch (Exception e3) {
            TestBasicOperations.assertTrue((boolean)false);
        }
    }

    private int countIter(Iterator it) {
        int i = 0;
        while (it.hasNext()) {
            Statement s = (Statement)it.next();
            ++i;
        }
        return i;
    }

    private int countAll() {
        StmtIterator it = this.model.listStatements();
        return this.countIter(it);
    }

    private int countSubj(Resource s) {
        StmtIterator it = this.model.listStatements(s, (Property)null, (RDFNode)null);
        return this.countIter(it);
    }

    private int countObj(RDFNode o) {
        StmtIterator it = this.model.listStatements((Resource)null, (Property)null, o);
        return this.countIter(it);
    }

    private int countPred(Property o) {
        StmtIterator it = this.model.listStatements((Resource)null, o, (RDFNode)null);
        return this.countIter(it);
    }

    public void testQueryOnlyOption() {
        GraphRDB g = new GraphRDB(this.conn, null, null, 1, false);
        this.model = new ModelRDB(g);
        Statement a1 = this.crAssertedStmt("s1", "p1", "o1");
        Statement a2 = this.crAssertedStmt("s2", "p2", "s1");
        Resource r1 = this.crReifiedStmt("r1", a1);
        Resource r2 = this.crReifiedStmt("r2", a2);
        Resource s1 = a1.getSubject();
        Property p1 = a1.getPredicate();
        RDFNode o1 = a1.getObject();
        int cnt = this.countAll();
        TestBasicOperations.assertTrue((cnt == 10 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(s1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countObj(o1);
        TestBasicOperations.assertTrue((cnt == 2 ? (byte)1 : 0) != 0);
        cnt = this.countObj(s1);
        TestBasicOperations.assertTrue((cnt == 3 ? (byte)1 : 0) != 0);
        cnt = this.countPred(p1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countPred(RDF.predicate);
        TestBasicOperations.assertTrue((cnt == 2 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(r2);
        TestBasicOperations.assertTrue((cnt == 4 ? (byte)1 : 0) != 0);
        this.model.setQueryOnlyAsserted(true);
        cnt = this.countAll();
        TestBasicOperations.assertTrue((cnt == 2 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(s1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countObj(o1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countObj(s1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countPred(p1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countPred(RDF.predicate);
        TestBasicOperations.assertTrue((cnt == 0 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(r2);
        TestBasicOperations.assertTrue((cnt == 0 ? (byte)1 : 0) != 0);
        this.model.setQueryOnlyReified(true);
        cnt = this.countAll();
        TestBasicOperations.assertTrue((cnt == 8 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(s1);
        TestBasicOperations.assertTrue((cnt == 0 ? (byte)1 : 0) != 0);
        cnt = this.countObj(o1);
        TestBasicOperations.assertTrue((cnt == 1 ? (byte)1 : 0) != 0);
        cnt = this.countObj(s1);
        TestBasicOperations.assertTrue((cnt == 2 ? (byte)1 : 0) != 0);
        cnt = this.countPred(p1);
        TestBasicOperations.assertTrue((cnt == 0 ? (byte)1 : 0) != 0);
        cnt = this.countPred(RDF.predicate);
        TestBasicOperations.assertTrue((cnt == 2 ? (byte)1 : 0) != 0);
        cnt = this.countSubj(r2);
        TestBasicOperations.assertTrue((cnt == 4 ? (byte)1 : 0) != 0);
        this.model.setQueryOnlyReified(false);
        cnt = this.countAll();
        TestBasicOperations.assertTrue((cnt == 10 ? (byte)1 : 0) != 0);
    }
}

