/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.Difference;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestDifference
extends GraphTestBase {
    public TestDifference(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDifference.class);
    }

    public void testDifference() {
        Graph g1 = TestDifference.graphWith("x R y; p R q");
        Graph g2 = TestDifference.graphWith("r A s; x R y");
        Difference d = new Difference(g1, g2);
        TestDifference.assertOmits("Difference", d, "x R y");
        TestDifference.assertContains("Difference", "p R q", d);
        TestDifference.assertOmits("Difference", d, "r A s");
        if (d.size() != 1) {
            TestDifference.fail((String)"oops: size of difference is not 1");
        }
        d.add(TestDifference.triple("cats eat cheese"));
        TestDifference.assertContains("Difference.L", "cats eat cheese", g1);
        TestDifference.assertOmits("Difference.R", g2, "cats eat cheese");
    }
}

