/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.DisjointUnion;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import junit.framework.TestSuite;

public class TestDisjointUnion
extends GraphTestBase {
    public TestDisjointUnion(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDisjointUnion.class);
    }

    public void testEmptyUnion() {
        DisjointUnion du = new DisjointUnion(Graph.emptyGraph, Graph.emptyGraph);
        TestDisjointUnion.assertEquals((boolean)true, (boolean)du.isEmpty());
    }

    public void testLeftUnion() {
        Graph g = TestDisjointUnion.graphWith("");
        this.testSingleComponent(g, new DisjointUnion(g, Graph.emptyGraph));
    }

    public void testRightUnion() {
        Graph g = TestDisjointUnion.graphWith("");
        this.testSingleComponent(g, new DisjointUnion(Graph.emptyGraph, g));
    }

    protected void testSingleComponent(Graph g, DisjointUnion du) {
        TestDisjointUnion.graphAdd(g, "x R y; a P b; x Q b");
        TestDisjointUnion.assertIsomorphic(g, du);
        TestDisjointUnion.graphAdd(g, "roses growOn you");
        TestDisjointUnion.assertIsomorphic(g, du);
        g.delete(TestDisjointUnion.triple("a P b"));
        TestDisjointUnion.assertIsomorphic(g, du);
    }

    public void testBothComponents() {
        Graph L = TestDisjointUnion.graphWith("");
        Graph R = TestDisjointUnion.graphWith("");
        DisjointUnion du = new DisjointUnion(L, R);
        TestDisjointUnion.assertIsomorphic(Graph.emptyGraph, du);
        L.add(TestDisjointUnion.triple("x P y"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x P y"), du);
        R.add(TestDisjointUnion.triple("A rdf:type Route"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x P y; A rdf:type Route"), du);
    }

    public void testRemoveBoth() {
        Graph L = TestDisjointUnion.graphWith("x R y; a P b");
        Graph R = TestDisjointUnion.graphWith("x R y; p Q r");
        DisjointUnion du = new DisjointUnion(L, R);
        du.delete(TestDisjointUnion.triple("x R y"));
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("a P b"), L);
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("p Q r"), R);
    }

    public void testAddLeftOnlyIfNecessary() {
        Graph L = TestDisjointUnion.graphWith("");
        Graph R = TestDisjointUnion.graphWith("x R y");
        DisjointUnion du = new DisjointUnion(L, R);
        TestDisjointUnion.graphAdd(du, "x R y");
        TestDisjointUnion.assertEquals((boolean)true, (boolean)L.isEmpty());
        TestDisjointUnion.graphAdd(du, " a P b");
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("a P b"), L);
        TestDisjointUnion.assertIsomorphic(TestDisjointUnion.graphWith("x R y"), R);
    }
}

