/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphUtil;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class TestMultiUnionReifier
extends ModelTestBase {
    static int count = 0;

    public TestMultiUnionReifier(String name) {
        super(name);
    }

    public void testX() {
        MultiUnion mu = this.multi("a P b; !b Q c; ~c R d", "");
        ExtendedIterator it = GraphUtil.findAll(mu);
        while (it.hasNext()) {
            System.err.println("]]  " + it.next());
        }
    }

    private MultiUnion multi(String a, String b) {
        Graph A = this.graph(a);
        Graph B = this.graph(b);
        return new MultiUnion(new Graph[]{A, B});
    }

    private Graph graph(String facts) {
        Graph result = Factory.createDefaultGraph(ReificationStyle.Standard);
        String[] factArray = facts.split(";");
        for (int i = 0; i < factArray.length; ++i) {
            Triple t;
            String fact = factArray[i].trim();
            if (fact.equals("")) continue;
            if (fact.charAt(0) == '!') {
                t = Triple.create(fact.substring(1));
                result.add(t);
                result.getReifier().reifyAs(NodeCreateUtils.create("_r" + ++count), t);
                continue;
            }
            if (fact.charAt(0) == '~') {
                t = Triple.create(fact.substring(1));
                result.getReifier().reifyAs(NodeCreateUtils.create("_r" + ++count), t);
                continue;
            }
            result.add(Triple.create(fact));
        }
        return result;
    }
}

